/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.InlineSQLHelper;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.ResourceTypePermissionLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineSQLHelperImpl
implements InlineSQLHelper {
    public static final String FILTER_BY_RESOURCE_BLOCK_ID = String.valueOf(InlineSQLHelper.class.getName()) + ".filterByResourceBlockId";
    public static final String FILTER_BY_RESOURCE_BLOCK_ID_OWNER = String.valueOf(InlineSQLHelper.class.getName()) + ".filterByResourceBlockIdOwner";
    public static final String JOIN_RESOURCE_PERMISSION = String.valueOf(InlineSQLHelper.class.getName()) + ".joinResourcePermission";
    private static final String _GROUP_BY_CLAUSE = " GROUP BY ";
    private static final long _NO_RESOURCE_BLOCKS_ID = -1L;
    private static final long[] _NO_ROLE_IDS = new long[1];
    private static final String _ORDER_BY_CLAUSE = " ORDER BY ";
    private static final String _WHERE_CLAUSE = " WHERE ";

    public boolean isEnabled() {
        return this.isEnabled(0L);
    }

    public boolean isEnabled(long groupId) {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return false;
        }
        if (!PropsValues.PERMISSIONS_INLINE_SQL_CHECK_ENABLED) {
            return false;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return false;
        }
        return !(groupId > 0L ? permissionChecker.isGroupAdmin(groupId) || permissionChecker.isGroupOwner(groupId) : permissionChecker.isCompanyAdmin());
    }

    public boolean isEnabled(long[] groupIds) {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return false;
        }
        if (!PropsValues.PERMISSIONS_INLINE_SQL_CHECK_ENABLED) {
            return false;
        }
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            if (this.isEnabled(groupId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String replacePermissionCheck(String sql, String className, String classPKField) {
        return this.replacePermissionCheck(sql, className, classPKField, null, new long[1], null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long groupId) {
        return this.replacePermissionCheck(sql, className, classPKField, null, new long[]{groupId}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long groupId, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, null, new long[]{groupId}, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long[] groupIds) {
        return this.replacePermissionCheck(sql, className, classPKField, null, groupIds, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, long[] groupIds, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, null, groupIds, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[1], null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long groupId) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{groupId}, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long groupId, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, new long[]{groupId}, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long[] groupIds) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, groupIds, null);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, long[] groupIds, String bridgeJoin) {
        if (!this.isEnabled(groupIds)) {
            return sql;
        }
        if (Validator.isNull((String)className)) {
            throw new IllegalArgumentException("className is null");
        }
        if (Validator.isNull((String)sql)) {
            return sql;
        }
        if (ResourceBlockLocalServiceUtil.isSupported((String)className)) {
            return this.replacePermissionCheckBlocks(sql, className, classPKField, userIdField, groupIds, bridgeJoin);
        }
        return this.replacePermissionCheckJoin(sql, className, classPKField, userIdField, groupIds, bridgeJoin);
    }

    public String replacePermissionCheck(String sql, String className, String classPKField, String userIdField, String bridgeJoin) {
        return this.replacePermissionCheck(sql, className, classPKField, userIdField, 0L, bridgeJoin);
    }

    protected Set<Long> getOwnerResourceBlockIds(long companyId, long[] groupIds, String className) {
        HashSet<Long> resourceBlockIds = new HashSet<Long>();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            resourceBlockIds.addAll(permissionChecker.getOwnerResourceBlockIds(companyId, groupId, className, "VIEW"));
            ++n2;
        }
        return resourceBlockIds;
    }

    protected Set<Long> getResourceBlockIds(long companyId, long[] groupIds, String className) {
        HashSet<Long> resourceBlockIds = new HashSet<Long>();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            resourceBlockIds.addAll(permissionChecker.getResourceBlockIds(companyId, groupId, permissionChecker.getUserId(), className, "VIEW"));
            ++n2;
        }
        return resourceBlockIds;
    }

    protected long[] getRoleIds(long groupId) {
        long[] roleIds = PermissionChecker.DEFAULT_ROLE_IDS;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            roleIds = permissionChecker.getRoleIds(permissionChecker.getUserId(), groupId);
        }
        return roleIds;
    }

    protected long[] getRoleIds(long[] groupIds) {
        long[] roleIds = PermissionChecker.DEFAULT_ROLE_IDS;
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            long[] lArray2 = this.getRoleIds(groupId);
            int n3 = lArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                long roleId = lArray2[n4];
                if (!ArrayUtil.contains((long[])roleIds, (long)roleId)) {
                    roleIds = ArrayUtil.append((long[])roleIds, (long)roleId);
                }
                ++n4;
            }
            ++n2;
        }
        return roleIds;
    }

    protected long getUserId() {
        long userId = 0L;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            userId = permissionChecker.getUserId();
        }
        return userId;
    }

    protected String replacePermissionCheckBlocks(String sql, String className, String classPKField, String userIdField, long[] groupIds, String bridgeJoin) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long checkGroupId = 0L;
        if (groupIds.length == 1) {
            checkGroupId = groupIds[0];
        }
        long companyId = permissionChecker.getCompanyId();
        long[] roleIds = permissionChecker.getRoleIds(this.getUserId(), checkGroupId);
        try {
            long[] lArray = roleIds;
            int n = roleIds.length;
            int n2 = 0;
            while (n2 < n) {
                long roleId = lArray[n2];
                if (ResourceTypePermissionLocalServiceUtil.hasCompanyScopePermission((long)companyId, (String)className, (long)roleId, (String)"VIEW")) {
                    return sql;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        Set<Long> userResourceBlockIds = this.getResourceBlockIds(companyId, groupIds, className);
        String permissionWhere = "";
        if (Validator.isNotNull((String)bridgeJoin)) {
            permissionWhere = bridgeJoin;
        }
        Set<Long> ownerResourceBlockIds = this.getOwnerResourceBlockIds(companyId, groupIds, className);
        ownerResourceBlockIds.removeAll(userResourceBlockIds);
        if (userResourceBlockIds.size() == 0) {
            userResourceBlockIds.add(-1L);
        }
        if (Validator.isNotNull((String)userIdField) && ownerResourceBlockIds.size() > 0) {
            permissionWhere = permissionWhere.concat(CustomSQLUtil.get((String)FILTER_BY_RESOURCE_BLOCK_ID_OWNER));
            permissionWhere = StringUtil.replace((String)permissionWhere, (String[])new String[]{"[$OWNER_RESOURCE_BLOCK_IDS$]", "[$USER_ID$]", "[$USER_ID_FIELD$]", "[$USER_RESOURCE_BLOCK_IDS$]"}, (String[])new String[]{StringUtil.merge(ownerResourceBlockIds), String.valueOf(permissionChecker.getUserId()), userIdField, StringUtil.merge(userResourceBlockIds)});
        } else {
            permissionWhere = permissionWhere.concat(CustomSQLUtil.get((String)FILTER_BY_RESOURCE_BLOCK_ID));
            permissionWhere = StringUtil.replace((String)permissionWhere, (String)"[$USER_RESOURCE_BLOCK_IDS$]", (String)StringUtil.merge(userResourceBlockIds));
        }
        int pos = sql.indexOf(_WHERE_CLAUSE);
        if (pos != -1) {
            StringBundler sb = new StringBundler(4);
            sb.append(sql.substring(0, pos));
            sb.append(permissionWhere);
            sb.append(" AND ");
            sb.append(sql.substring(pos + 7));
            return sb.toString();
        }
        pos = sql.indexOf(_GROUP_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionWhere).concat(sql.substring(pos + 1));
        }
        pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionWhere).concat(sql.substring(pos + 1));
        }
        return sql.concat(" ").concat(permissionWhere);
    }

    protected String replacePermissionCheckJoin(String sql, String className, String classPKField, String userIdField, long[] groupIds, String bridgeJoin) {
        if (Validator.isNull((String)classPKField)) {
            throw new IllegalArgumentException("classPKField is null");
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long checkGroupId = 0L;
        if (groupIds.length == 1) {
            checkGroupId = groupIds[0];
        }
        if (permissionChecker.hasPermission(checkGroupId, className, 0L, "VIEW")) {
            return sql;
        }
        String permissionJoin = "";
        if (Validator.isNotNull((String)bridgeJoin)) {
            permissionJoin = bridgeJoin;
        }
        permissionJoin = String.valueOf(permissionJoin) + CustomSQLUtil.get((String)JOIN_RESOURCE_PERMISSION);
        StringBundler sb = new StringBundler();
        sb.append("(InlineSQLResourcePermission.scope = ");
        sb.append(4);
        sb.append(" AND ");
        sb.append("InlineSQLResourcePermission.primKey = CAST_TEXT(");
        sb.append(classPKField);
        sb.append(") AND (");
        long userId = this.getUserId();
        boolean hasPreviousViewableGroup = false;
        int j = 0;
        while (j < groupIds.length) {
            long groupId = groupIds[j];
            if (!permissionChecker.hasPermission(groupId, className, 0L, "VIEW")) {
                if (j > 0 && hasPreviousViewableGroup) {
                    sb.append(" OR ");
                }
                hasPreviousViewableGroup = true;
                sb.append("(");
                sb.append(classPKField.substring(0, classPKField.lastIndexOf(46)));
                sb.append(".groupId = ");
                sb.append(groupId);
                sb.append(")");
                long[] roleIds = this.getRoleIds(groupId);
                if (roleIds.length == 0) {
                    roleIds = _NO_ROLE_IDS;
                }
                sb.append(" AND (");
                int i = 0;
                while (i < roleIds.length) {
                    if (i > 0) {
                        sb.append(" OR ");
                    }
                    sb.append("InlineSQLResourcePermission.roleId = ");
                    sb.append(roleIds[i]);
                    ++i;
                }
                if (permissionChecker.isSignedIn()) {
                    sb.append(" OR ");
                    if (Validator.isNotNull((String)userIdField)) {
                        sb.append("(");
                        sb.append(userIdField);
                        sb.append(" = ");
                        sb.append(userId);
                        sb.append(")");
                    } else {
                        sb.append("(InlineSQLResourcePermission.ownerId = ");
                        sb.append(userId);
                        sb.append(")");
                    }
                }
                sb.append(")");
            }
            ++j;
        }
        sb.append("))");
        permissionJoin = StringUtil.replace((String)permissionJoin, (String[])new String[]{"[$CLASS_NAME$]", "[$COMPANY_ID$]", "[$PRIM_KEYS$]"}, (String[])new String[]{className, String.valueOf(permissionChecker.getCompanyId()), sb.toString()});
        int pos = sql.indexOf(_WHERE_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionJoin).concat(sql.substring(pos + 1));
        }
        pos = sql.indexOf(_GROUP_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionJoin).concat(sql.substring(pos + 1));
        }
        pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(permissionJoin).concat(sql.substring(pos + 1));
        }
        return sql.concat(" ").concat(permissionJoin);
    }
}

