/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.admin.util.OmniadminUtil;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePermissionChecker
implements PermissionChecker {
    protected User user;
    protected long defaultUserId;
    protected boolean signedIn;
    protected boolean checkGuest;
    protected Boolean omniadmin;
    protected Role ownerRole;
    private static Log _log = LogFactoryUtil.getLog(BasePermissionChecker.class);

    public abstract PermissionChecker clone();

    public long getCompanyId() {
        return this.user.getCompanyId();
    }

    public List<Long> getGuestResourceBlockIds(long companyId, long groupId, String name, String actionId) {
        return Collections.emptyList();
    }

    public List<Long> getOwnerResourceBlockIds(long companyId, long groupId, String name, String actionId) {
        return Collections.emptyList();
    }

    public long getOwnerRoleId() {
        return this.ownerRole.getRoleId();
    }

    public List<Long> getResourceBlockIds(long companyId, long groupId, long userId, String name, String actionId) {
        return Collections.emptyList();
    }

    public long[] getRoleIds(long userId, long groupId) {
        return PermissionChecker.DEFAULT_ROLE_IDS;
    }

    public long getUserId() {
        return this.user.getUserId();
    }

    public boolean hasOwnerPermission(long companyId, String name, long primKey, long ownerId, String actionId) {
        return this.hasOwnerPermission(companyId, name, String.valueOf(primKey), ownerId, actionId);
    }

    public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
        return this.hasPermission(groupId, name, String.valueOf(primKey), actionId);
    }

    public void init(User user, boolean checkGuest) {
        this.user = user;
        if (user.isDefaultUser()) {
            this.defaultUserId = user.getUserId();
            this.signedIn = false;
        } else {
            try {
                this.defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)user.getCompanyId());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            this.signedIn = true;
        }
        this.checkGuest = checkGuest;
        try {
            this.ownerRole = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"Owner");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public boolean isCheckGuest() {
        return this.checkGuest;
    }

    public boolean isCommunityAdmin(long groupId) {
        return this.isGroupAdmin(groupId);
    }

    public boolean isCommunityOwner(long groupId) {
        return this.isGroupOwner(groupId);
    }

    public boolean isOmniadmin() {
        if (this.omniadmin == null) {
            this.omniadmin = OmniadminUtil.isOmniadmin(this.getUserId());
        }
        return this.omniadmin;
    }

    public boolean isSignedIn() {
        return this.signedIn;
    }

    public void resetValues() {
    }

    public void setCheckGuest(boolean checkGuest) {
        this.checkGuest = checkGuest;
    }

    public void setValues(PortletRequest portletRequest) {
    }
}

