/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.NoSuchResourceException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PermissionedModel;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.security.permission.BasePermissionChecker;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.security.permission.PermissionCheckerBagImpl;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.security.permission.ResourceBlockIdsBag;
import com.liferay.portal.security.permission.comparator.PermissionActionIdComparator;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.UniqueList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedPermissionChecker
extends BasePermissionChecker {
    protected static final String RESULTS_SEPARATOR = "_RESULTS_SEPARATOR_";
    protected Map<Long, Boolean> companyAdmins = new HashMap<Long, Boolean>();
    private static Log _log = LogFactoryUtil.getLog(AdvancedPermissionChecker.class);

    @Override
    public AdvancedPermissionChecker clone() {
        return new AdvancedPermissionChecker();
    }

    @Override
    public long[] getRoleIds(long userId, long groupId) {
        PermissionCheckerBag bag = null;
        try {
            bag = this.getUserBag(userId, groupId);
        }
        catch (Exception exception) {}
        if (bag != null) {
            if (this.checkGuest) {
                Set roleIds = SetUtil.fromArray((long[])bag.getRoleIds());
                try {
                    PermissionCheckerBag guestBag = this.getGuestUserBag();
                    if (guestBag != null) {
                        long[] lArray = guestBag.getRoleIds();
                        int n = lArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            long roleId = lArray[n2];
                            roleIds.add(roleId);
                            ++n2;
                        }
                    }
                }
                catch (Exception exception) {}
                return ArrayUtil.toArray((Long[])roleIds.toArray(new Long[roleIds.size()]));
            }
            return bag.getRoleIds();
        }
        return PermissionChecker.DEFAULT_ROLE_IDS;
    }

    @Override
    public List<Long> getGuestResourceBlockIds(long companyId, long groupId, String name, String actionId) {
        try {
            ResourceBlockIdsBag resourceBlockIdsBag = this.getGuestResourceBlockIdsBag(companyId, groupId, name);
            return ResourceBlockLocalServiceUtil.getResourceBlockIds((ResourceBlockIdsBag)resourceBlockIdsBag, (String)name, (String)actionId);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public ResourceBlockIdsBag getGuestResourceBlockIdsBag(long companyId, long groupId, String name) throws Exception {
        ResourceBlockIdsBag resourceBlockIdsBag = PermissionCacheUtil.getResourceBlockIdsBag(companyId, groupId, this.defaultUserId, name, true);
        if (resourceBlockIdsBag != null) {
            return resourceBlockIdsBag;
        }
        try {
            PermissionCheckerBag bag = this.getGuestUserBag();
            long[] roleIds = bag.getRoleIds();
            resourceBlockIdsBag = ResourceBlockLocalServiceUtil.getResourceBlockIdsBag((long)this.getCompanyId(), (long)groupId, (String)name, (long[])roleIds);
            PermissionCacheUtil.putResourceBlockIdsBag(companyId, groupId, this.defaultUserId, name, true, resourceBlockIdsBag);
            ResourceBlockIdsBag resourceBlockIdsBag2 = resourceBlockIdsBag;
            return resourceBlockIdsBag2;
        }
        finally {
            if (resourceBlockIdsBag == null) {
                resourceBlockIdsBag = new ResourceBlockIdsBag();
            }
            PermissionCacheUtil.putResourceBlockIdsBag(companyId, this.defaultUserId, groupId, name, true, resourceBlockIdsBag);
        }
    }

    public PermissionCheckerBag getGuestUserBag() throws Exception {
        Group guestGroup = GroupLocalServiceUtil.getGroup((long)this.getCompanyId(), (String)"Guest");
        PermissionCheckerBag bag = PermissionCacheUtil.getBag(this.defaultUserId, guestGroup.getGroupId());
        if (bag == null) {
            try {
                ArrayList<Group> groups = new ArrayList<Group>();
                groups.add(guestGroup);
                List roles = RoleLocalServiceUtil.getUserRelatedRoles((long)this.defaultUserId, groups);
                bag = new PermissionCheckerBagImpl(this.defaultUserId, new ArrayList<Group>(), new ArrayList<Organization>(), new ArrayList<Group>(), new ArrayList<Group>(), groups, roles);
            }
            finally {
                if (bag == null) {
                    bag = new PermissionCheckerBagImpl(this.defaultUserId, new ArrayList<Group>(), new ArrayList<Organization>(), new ArrayList<Group>(), new ArrayList<Group>(), new ArrayList<Group>(), new ArrayList<Role>());
                }
                PermissionCacheUtil.putBag(this.defaultUserId, guestGroup.getGroupId(), bag);
            }
        }
        return bag;
    }

    @Override
    public List<Long> getOwnerResourceBlockIds(long companyId, long groupId, String name, String actionId) {
        try {
            ResourceBlockIdsBag resourceBlockIdsBag = this.getOwnerResourceBlockIdsBag(companyId, groupId, name);
            return ResourceBlockLocalServiceUtil.getResourceBlockIds((ResourceBlockIdsBag)resourceBlockIdsBag, (String)name, (String)actionId);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public ResourceBlockIdsBag getOwnerResourceBlockIdsBag(long companyId, long groupId, String name) throws SystemException {
        ResourceBlockIdsBag resourceBlockIdsBag = PermissionCacheUtil.getResourceBlockIdsBag(companyId, groupId, -1L, name, true);
        if (resourceBlockIdsBag != null) {
            return resourceBlockIdsBag;
        }
        try {
            long[] roleIds = new long[]{this.getOwnerRoleId()};
            resourceBlockIdsBag = ResourceBlockLocalServiceUtil.getResourceBlockIdsBag((long)this.getCompanyId(), (long)groupId, (String)name, (long[])roleIds);
            PermissionCacheUtil.putResourceBlockIdsBag(companyId, groupId, -1L, name, true, resourceBlockIdsBag);
            ResourceBlockIdsBag resourceBlockIdsBag2 = resourceBlockIdsBag;
            return resourceBlockIdsBag2;
        }
        finally {
            if (resourceBlockIdsBag == null) {
                resourceBlockIdsBag = new ResourceBlockIdsBag();
            }
            PermissionCacheUtil.putResourceBlockIdsBag(companyId, -1L, groupId, name, true, resourceBlockIdsBag);
        }
    }

    @Override
    public List<Long> getResourceBlockIds(long companyId, long groupId, long userId, String name, String actionId) {
        try {
            ResourceBlockIdsBag resourceBlockIdsBag = this.getResourceBlockIdsBag(companyId, groupId, userId, name);
            return ResourceBlockLocalServiceUtil.getResourceBlockIds((ResourceBlockIdsBag)resourceBlockIdsBag, (String)name, (String)actionId);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public ResourceBlockIdsBag getResourceBlockIdsBag(long companyId, long groupId, long userId, String name) throws Exception {
        ResourceBlockIdsBag resourceBlockIdsBag = PermissionCacheUtil.getResourceBlockIdsBag(companyId, groupId, userId, name, this.checkGuest);
        if (resourceBlockIdsBag != null) {
            return resourceBlockIdsBag;
        }
        try {
            long[] roleIds = this.getRoleIds(userId, groupId);
            resourceBlockIdsBag = ResourceBlockLocalServiceUtil.getResourceBlockIdsBag((long)this.getCompanyId(), (long)groupId, (String)name, (long[])roleIds);
            PermissionCacheUtil.putResourceBlockIdsBag(companyId, groupId, userId, name, this.checkGuest, resourceBlockIdsBag);
            ResourceBlockIdsBag resourceBlockIdsBag2 = resourceBlockIdsBag;
            return resourceBlockIdsBag2;
        }
        finally {
            if (resourceBlockIdsBag == null) {
                resourceBlockIdsBag = new ResourceBlockIdsBag();
            }
            PermissionCacheUtil.putResourceBlockIdsBag(companyId, userId, groupId, name, this.checkGuest, resourceBlockIdsBag);
        }
    }

    public PermissionCheckerBag getUserBag(long userId, long groupId) throws Exception {
        PermissionCheckerBag bag = PermissionCacheUtil.getBag(userId, groupId);
        if (bag != null) {
            return bag;
        }
        try {
            long parentGroupId;
            Group group = null;
            if (groupId > 0L && (group = GroupLocalServiceUtil.getGroup((long)groupId)).isLayout() && (parentGroupId = group.getParentGroupId()) > 0L) {
                group = GroupLocalServiceUtil.getGroup((long)parentGroupId);
            }
            List userGroups = GroupLocalServiceUtil.getUserGroups((long)userId, (boolean)true);
            List<Organization> userOrgs = this.getUserOrgs(userId);
            List userOrgGroups = GroupLocalServiceUtil.getOrganizationsGroups(userOrgs);
            List userUserGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)userId);
            List userUserGroupGroups = GroupLocalServiceUtil.getUserGroupsGroups((List)userUserGroups);
            ArrayList<Group> groups = new ArrayList<Group>(userGroups.size() + userOrgGroups.size() + userUserGroupGroups.size());
            groups.addAll(userGroups);
            groups.addAll(userOrgGroups);
            groups.addAll(userUserGroupGroups);
            Object roles = new UniqueList();
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 3 || PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 4 || PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5 || PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                if (groups.size() > 0) {
                    List userRelatedRoles = RoleLocalServiceUtil.getUserRelatedRoles((long)userId, groups);
                    roles.addAll(userRelatedRoles);
                } else {
                    roles.addAll(RoleLocalServiceUtil.getUserRoles((long)userId));
                }
                List userGroupRoles = RoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)groupId);
                roles.addAll(userGroupRoles);
                List userGroupGroupRoles = RoleLocalServiceUtil.getUserGroupGroupRoles((long)userId, (long)groupId);
                roles.addAll(userGroupGroupRoles);
                if (group != null) {
                    if (group.isOrganization() && userOrgGroups.contains(group)) {
                        Role organizationUserRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Organization User");
                        roles.add(organizationUserRole);
                    }
                    if (group.isSite() && (userGroups.contains(group) || userOrgGroups.contains(group))) {
                        Role siteMemberRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Site Member");
                        roles.add(siteMemberRole);
                    }
                    if (group.isOrganization() && userOrgGroups.contains(group) || group.isSite() && userGroups.contains(group)) {
                        this.addTeamRoles(userId, group, (List<Role>)roles);
                    }
                }
            } else {
                roles = new ArrayList();
            }
            PermissionCheckerBag permissionCheckerBag = bag = new PermissionCheckerBagImpl(userId, userGroups, userOrgs, userOrgGroups, userUserGroupGroups, groups, (List<Role>)roles);
            return permissionCheckerBag;
        }
        finally {
            if (bag == null) {
                bag = new PermissionCheckerBagImpl(userId, new ArrayList<Group>(), new ArrayList<Organization>(), new ArrayList<Group>(), new ArrayList<Group>(), new ArrayList<Group>(), new ArrayList<Role>());
            }
            PermissionCacheUtil.putBag(userId, groupId, bag);
        }
    }

    public boolean hasOwnerPermission(long companyId, String name, String primKey, long ownerId, String actionId) {
        block8: {
            if (ownerId != this.getUserId()) {
                return false;
            }
            if (ownerId == this.defaultUserId) {
                return actionId.equals("VIEW");
            }
            try {
                if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                    if (ResourceBlockLocalServiceUtil.isSupported((String)name)) {
                        PermissionedModel permissionedModel = ResourceBlockLocalServiceUtil.getPermissionedModel((String)name, (long)GetterUtil.getLong((String)primKey));
                        long groupId = 0L;
                        if (permissionedModel instanceof GroupedModel) {
                            GroupedModel groupedModel = (GroupedModel)permissionedModel;
                            groupId = groupedModel.getGroupId();
                        }
                        ResourceBlockIdsBag resourceBlockIdsBag = this.getOwnerResourceBlockIdsBag(companyId, groupId, name);
                        return ResourceBlockLocalServiceUtil.hasPermission((String)name, (PermissionedModel)permissionedModel, (String)actionId, (ResourceBlockIdsBag)resourceBlockIdsBag);
                    }
                    return ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)name, (int)4, (String)primKey, (long)this.getOwnerRoleId(), (String)actionId);
                }
                ResourceActionsUtil.checkAction((String)name, (String)actionId);
                Resource resource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)4, (String)primKey);
                List permissions = PermissionLocalServiceUtil.getRolePermissions((long)this.getOwnerRoleId(), (long)resource.getResourceId());
                int pos = Collections.binarySearch(permissions, actionId, new PermissionActionIdComparator());
                if (pos >= 0) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return false;
    }

    public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
        Boolean value;
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        Group group = null;
        try {
            if (groupId > 0L) {
                group = GroupLocalServiceUtil.getGroup((long)groupId);
                if (group.isUser() && group.getClassPK() == this.getUserId()) {
                    group = GroupLocalServiceUtil.getGroup((long)this.getCompanyId(), (String)"User Personal Site");
                    groupId = group.getGroupId();
                }
                if (group.isLayout()) {
                    Layout layout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
                    groupId = layout.getGroupId();
                    group = GroupLocalServiceUtil.getGroup((long)groupId);
                }
                if (group.isStagingGroup()) {
                    if (primKey.equals(String.valueOf(groupId))) {
                        primKey = String.valueOf(group.getLiveGroupId());
                    }
                    groupId = group.getLiveGroupId();
                    group = group.getLiveGroup();
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if ((value = PermissionCacheUtil.getPermission(this.user.getUserId(), this.signedIn, this.checkGuest, groupId, name, primKey, actionId)) == null) {
            try {
                value = this.hasPermissionImpl(groupId, name, primKey, actionId);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Checking permission for " + groupId + " " + name + " " + primKey + " " + actionId + " takes " + stopWatch.getTime() + " ms"));
                }
            }
            finally {
                if (value == null) {
                    value = Boolean.FALSE;
                }
                PermissionCacheUtil.putPermission(this.user.getUserId(), this.signedIn, this.checkGuest, groupId, name, primKey, actionId, value);
            }
        }
        return value;
    }

    public boolean hasUserPermission(long groupId, String name, String primKey, String actionId, boolean checkAdmin) {
        try {
            return this.hasUserPermissionImpl(groupId, name, primKey, actionId, checkAdmin);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isCompanyAdmin() {
        try {
            return this.isCompanyAdminImpl();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isCompanyAdmin(long companyId) {
        try {
            return this.isCompanyAdminImpl(companyId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isGroupAdmin(long groupId) {
        try {
            return this.isGroupAdminImpl(groupId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isGroupOwner(long groupId) {
        try {
            return this.isGroupOwnerImpl(groupId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected void addTeamRoles(long userId, Group group, List<Role> roles) throws Exception {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5 || PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            List userTeams = TeamLocalServiceUtil.getUserTeams((long)userId, (long)group.getGroupId());
            for (Team team : userTeams) {
                Role role = RoleLocalServiceUtil.getTeamRole((long)team.getCompanyId(), (long)team.getTeamId());
                roles.add(role);
            }
            LinkedHashMap<String, Long> teamParams = new LinkedHashMap<String, Long>();
            teamParams.put("usersUserGroups", userId);
            List userGroupTeams = TeamLocalServiceUtil.search((long)group.getGroupId(), null, null, teamParams, (int)-1, (int)-1, null);
            for (Team team : userGroupTeams) {
                Role role = RoleLocalServiceUtil.getTeamRole((long)team.getCompanyId(), (long)team.getTeamId());
                roles.add(role);
            }
        }
    }

    protected List<Resource> getResources(long companyId, long groupId, String name, String primKey, String actionId) throws Exception {
        ArrayList<Resource> resources;
        block13: {
            Resource resource;
            block12: {
                block11: {
                    block10: {
                        resources = new ArrayList<Resource>(4);
                        try {
                            resource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)4, (String)primKey);
                            resources.add(resource);
                        }
                        catch (NoSuchResourceException noSuchResourceException) {
                            if (!_log.isWarnEnabled()) break block10;
                            _log.warn((Object)("Resource " + companyId + " " + name + " " + 4 + " " + primKey + " does not exist"));
                        }
                    }
                    try {
                        if (groupId > 0L) {
                            resource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)2, (String)String.valueOf(groupId));
                            resources.add(resource);
                        }
                    }
                    catch (NoSuchResourceException noSuchResourceException) {
                        if (!_log.isWarnEnabled()) break block11;
                        _log.warn((Object)("Resource " + companyId + " " + name + " " + 2 + " " + groupId + " does not exist"));
                    }
                }
                try {
                    if (this.signedIn && groupId > 0L) {
                        resource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)3, (String)String.valueOf(0L));
                        resources.add(resource);
                    }
                }
                catch (NoSuchResourceException noSuchResourceException) {
                    if (!_log.isWarnEnabled()) break block12;
                    _log.warn((Object)("Resource " + companyId + " " + name + " " + 3 + " " + 0L + " does not exist"));
                }
            }
            try {
                resource = ResourceLocalServiceUtil.getResource((long)companyId, (String)name, (int)1, (String)String.valueOf(companyId));
                resources.add(resource);
            }
            catch (NoSuchResourceException noSuchResourceException) {
                if (!_log.isWarnEnabled()) break block13;
                _log.warn((Object)("Resource " + companyId + " " + name + " " + 1 + " " + companyId + " does not exist"));
            }
        }
        return resources;
    }

    protected List<Organization> getUserOrgs(long userId) throws Exception {
        List userOrgs = OrganizationLocalServiceUtil.getUserOrganizations((long)userId);
        if (userOrgs.size() == 0) {
            return userOrgs;
        }
        UniqueList organizations = new UniqueList();
        for (Organization organization : userOrgs) {
            if (organizations.contains(organization)) continue;
            organizations.add(organization);
            List ancestorOrganizations = OrganizationLocalServiceUtil.getParentOrganizations((long)organization.getOrganizationId());
            organizations.addAll(ancestorOrganizations);
        }
        return organizations;
    }

    protected boolean hasGuestPermission(long groupId, String name, String primKey, String actionId) throws Exception {
        List actions;
        ResourceActionsUtil.checkAction((String)name, (String)actionId);
        if (name.indexOf(46) != -1 ? (actions = ResourceActionsUtil.getModelResourceGuestUnsupportedActions((String)name)).contains(actionId) : (actions = ResourceActionsUtil.getPortletResourceGuestUnsupportedActions((String)name)).contains(actionId)) {
            return false;
        }
        long companyId = this.user.getCompanyId();
        List<Resource> resources = this.getResources(companyId, groupId, name, primKey, actionId);
        PermissionCheckerBag bag = this.getGuestUserBag();
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6 && ResourceBlockLocalServiceUtil.isSupported((String)name)) {
                ResourceBlockIdsBag resourceBlockIdsBag = this.getGuestResourceBlockIdsBag(companyId, groupId, name);
                return ResourceBlockLocalServiceUtil.hasPermission((String)name, (long)GetterUtil.getLong((String)primKey), (String)actionId, (ResourceBlockIdsBag)resourceBlockIdsBag);
            }
            return PermissionLocalServiceUtil.hasUserPermissions((long)this.defaultUserId, (long)groupId, resources, (String)actionId, (PermissionCheckerBag)bag);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected boolean hasPermissionImpl(long groupId, String name, String primKey, String actionId) {
        try {
            if (!this.signedIn) {
                return this.hasGuestPermission(groupId, name, primKey, actionId);
            }
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6 && ResourceBlockLocalServiceUtil.isSupported((String)name)) {
                return this.hasUserPermission(groupId, name, primKey, actionId, true);
            }
            boolean value = false;
            if (this.checkGuest) {
                value = this.hasGuestPermission(groupId, name, primKey, actionId);
            }
            if (!value) {
                value = this.hasUserPermission(groupId, name, primKey, actionId, true);
            }
            return value;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected boolean hasUserPermissionImpl(long groupId, String name, String primKey, String actionId, boolean checkAdmin) throws Exception {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        long companyId = this.user.getCompanyId();
        boolean hasLayoutManagerPermission = true;
        if (Validator.isNotNull((String)name) && Validator.isNotNull((String)primKey) && primKey.indexOf("_LAYOUT_") != -1) {
            hasLayoutManagerPermission = PortletPermissionUtil.hasLayoutManagerPermission((String)name, (String)actionId);
        }
        if (checkAdmin && (this.isCompanyAdminImpl(companyId) || this.isGroupAdminImpl(groupId) && hasLayoutManagerPermission)) {
            return true;
        }
        this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 1);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6 && ResourceBlockLocalServiceUtil.isSupported((String)name)) {
            ResourceBlockIdsBag resourceBlockIdsBag = this.getResourceBlockIdsBag(companyId, groupId, this.getUserId(), name);
            boolean value = ResourceBlockLocalServiceUtil.hasPermission((String)name, (long)GetterUtil.getLong((String)primKey), (String)actionId, (ResourceBlockIdsBag)resourceBlockIdsBag);
            this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 2);
            return value;
        }
        List<Resource> resources = this.getResources(companyId, groupId, name, primKey, actionId);
        this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 3);
        PermissionCheckerBag bag = this.getUserBag(this.user.getUserId(), groupId);
        boolean value = PermissionLocalServiceUtil.hasUserPermissions((long)this.user.getUserId(), (long)groupId, resources, (String)actionId, (PermissionCheckerBag)bag);
        this.logHasUserPermission(groupId, name, primKey, actionId, stopWatch, 4);
        return value;
    }

    protected boolean isCompanyAdminImpl() throws Exception {
        return this.isCompanyAdminImpl(this.user.getCompanyId());
    }

    protected boolean isCompanyAdminImpl(long companyId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        Boolean value = this.companyAdmins.get(companyId);
        if (value == null) {
            boolean hasAdminRole = RoleLocalServiceUtil.hasUserRole((long)this.user.getUserId(), (long)companyId, (String)"Administrator", (boolean)true);
            value = hasAdminRole;
            this.companyAdmins.put(companyId, value);
        }
        return value;
    }

    protected boolean isGroupAdminImpl(long groupId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (groupId <= 0L) {
            return false;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (this.isCompanyAdmin(group.getCompanyId())) {
            return true;
        }
        PermissionCheckerBag bag = this.getUserBag(this.user.getUserId(), groupId);
        if (bag == null) {
            _log.error((Object)"Bag should never be null");
        }
        return bag.isGroupAdmin((PermissionChecker)this, group);
    }

    protected boolean isGroupOwnerImpl(long groupId) throws Exception {
        if (!this.signedIn) {
            return false;
        }
        if (this.isOmniadmin()) {
            return true;
        }
        if (groupId <= 0L) {
            return false;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (this.isCompanyAdmin(group.getCompanyId())) {
            return true;
        }
        PermissionCheckerBag bag = this.getUserBag(this.user.getUserId(), groupId);
        if (bag == null) {
            _log.error((Object)"Bag should never be null");
        }
        return bag.isGroupOwner((PermissionChecker)this, group);
    }

    protected void logHasUserPermission(long groupId, String name, String primKey, String actionId, StopWatch stopWatch, int block) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Checking user permission block " + block + " for " + groupId + " " + name + " " + primKey + " " + actionId + " takes " + stopWatch.getTime() + " ms"));
    }
}

