/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ntlm;

import com.liferay.portal.security.ntlm.NtlmLogonException;
import com.liferay.portal.security.ntlm.NtlmServiceAccount;
import com.liferay.portal.security.ntlm.msrpc.NetlogonAuthenticator;
import com.liferay.portal.security.ntlm.msrpc.NetrServerAuthenticate3;
import com.liferay.portal.security.ntlm.msrpc.NetrServerReqChallenge;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.DcerpcMessage;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.util.DES;
import jcifs.util.Encdec;
import jcifs.util.HMACT64;
import jcifs.util.MD4;

public class NetlogonConnection {
    private static int _negotiateFlags;
    private byte[] _clientCredential;
    private DcerpcHandle _dcerpcHandle;
    private byte[] _sessionKey;

    public NetlogonConnection() {
        if (_negotiateFlags == 0) {
            String negotiateFlags = PropsValues.NTLM_AUTH_NEGOTIATE_FLAGS;
            _negotiateFlags = negotiateFlags.startsWith("0x") ? Integer.valueOf(negotiateFlags.substring(2), 16) : 0x600FFFFF;
        }
    }

    public NetlogonAuthenticator computeNetlogonAuthenticator() {
        int timestamp = (int)System.currentTimeMillis();
        int input = Encdec.dec_uint32le((byte[])this._clientCredential, (int)0) + timestamp;
        Encdec.enc_uint32le((int)input, (byte[])this._clientCredential, (int)0);
        byte[] credential = this.computeNetlogonCredential(this._clientCredential, this._sessionKey);
        return new NetlogonAuthenticator(credential, timestamp);
    }

    public void connect(String domainController, String domainControllerName, NtlmServiceAccount ntlmServiceAccount, SecureRandom secureRandom) throws IOException, NtlmLogonException, NoSuchAlgorithmException {
        NtlmPasswordAuthentication ntlmPasswordAuthentication = new NtlmPasswordAuthentication(null, ntlmServiceAccount.getAccount(), ntlmServiceAccount.getPassword());
        String endpoint = "ncacn_np:" + domainController + "[\\PIPE\\NETLOGON]";
        DcerpcHandle dcerpcHandle = DcerpcHandle.getHandle((String)endpoint, (NtlmPasswordAuthentication)ntlmPasswordAuthentication);
        this.setDcerpcHandle(dcerpcHandle);
        dcerpcHandle.bind();
        byte[] clientChallenge = new byte[8];
        secureRandom.nextBytes(clientChallenge);
        NetrServerReqChallenge netrServerReqChallenge = new NetrServerReqChallenge(domainControllerName, ntlmServiceAccount.getComputerName(), clientChallenge, new byte[8]);
        dcerpcHandle.sendrecv((DcerpcMessage)netrServerReqChallenge);
        MD4 md4 = new MD4();
        md4.update(ntlmServiceAccount.getPassword().getBytes("UTF-16LE"));
        byte[] sessionKey = this.computeSessionKey(md4.digest(), clientChallenge, netrServerReqChallenge.getServerChallenge());
        byte[] clientCredential = this.computeNetlogonCredential(clientChallenge, sessionKey);
        NetrServerAuthenticate3 netrServerAuthenticate3 = new NetrServerAuthenticate3(domainControllerName, ntlmServiceAccount.getAccountName(), 2, ntlmServiceAccount.getComputerName(), clientCredential, new byte[8], _negotiateFlags);
        dcerpcHandle.sendrecv((DcerpcMessage)netrServerAuthenticate3);
        byte[] serverCredential = this.computeNetlogonCredential(netrServerReqChallenge.getServerChallenge(), sessionKey);
        if (!Arrays.equals(serverCredential, netrServerAuthenticate3.getServerCredential())) {
            throw new NtlmLogonException("Session key negotiation failed");
        }
        this._clientCredential = clientCredential;
        this._sessionKey = sessionKey;
    }

    public void disconnect() throws IOException {
        if (this._dcerpcHandle != null) {
            this._dcerpcHandle.close();
        }
    }

    public byte[] getClientCredential() {
        return this._clientCredential;
    }

    public DcerpcHandle getDcerpcHandle() {
        return this._dcerpcHandle;
    }

    public byte[] getSessionKey() {
        return this._sessionKey;
    }

    public void setDcerpcHandle(DcerpcHandle dcerpcHandle) {
        this._dcerpcHandle = dcerpcHandle;
    }

    protected byte[] computeNetlogonCredential(byte[] input, byte[] sessionKey) {
        byte[] k1 = new byte[7];
        byte[] k2 = new byte[7];
        System.arraycopy(sessionKey, 0, k1, 0, 7);
        System.arraycopy(sessionKey, 7, k2, 0, 7);
        DES k3 = new DES(k1);
        DES k4 = new DES(k2);
        byte[] output1 = new byte[8];
        byte[] output2 = new byte[8];
        k3.encrypt(input, output1);
        k4.encrypt(output1, output2);
        return output2;
    }

    protected byte[] computeSessionKey(byte[] sharedSecret, byte[] clientChallenge, byte[] serverChallenge) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] zeroes = new byte[4];
        messageDigest.update(zeroes, 0, 4);
        messageDigest.update(clientChallenge, 0, 8);
        messageDigest.update(serverChallenge, 0, 8);
        HMACT64 hmact64 = new HMACT64(sharedSecret);
        hmact64.update(messageDigest.digest());
        return hmact64.digest();
    }
}

