/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.security.ldap.AttributesTransformer;
import com.liferay.portal.security.ldap.AttributesTransformerFactory;
import com.liferay.portal.security.ldap.LDAPGroup;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.ldap.LDAPToPortalConverter;
import com.liferay.portal.security.ldap.LDAPUser;
import com.liferay.portal.security.ldap.LDAPUserGroupTransactionThreadLocal;
import com.liferay.portal.security.ldap.LDAPUserTransactionThreadLocal;
import com.liferay.portal.security.ldap.PortalLDAPImporter;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import com.liferay.portlet.expando.util.ExpandoConverterUtil;
import com.liferay.util.ldap.LDAPUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalLDAPImporterImpl
implements PortalLDAPImporter {
    private static final String _IMPORT_BY_GROUP = "group";
    private static final String _IMPORT_BY_USER = "user";
    private static final String _USER_PASSWORD_SCREEN_NAME = "screenName";
    private static Log _log = LogFactoryUtil.getLog(PortalLDAPImporterImpl.class);
    private LDAPToPortalConverter _ldapToPortalConverter;
    private PortalCache _portalCache = SingleVMPoolUtil.getCache((String)PortalLDAPImporter.class.getName(), (boolean)false);

    public void importFromLDAP() throws Exception {
        List companies = CompanyLocalServiceUtil.getCompanies((boolean)false);
        for (Company company : companies) {
            this.importFromLDAP(company.getCompanyId());
        }
    }

    public void importFromLDAP(long companyId) throws Exception {
        if (!LDAPSettingsUtil.isImportEnabled(companyId)) {
            return;
        }
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        if (LockLocalServiceUtil.hasLock((long)defaultUserId, (String)PortalLDAPImporterUtil.class.getName(), (long)companyId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping LDAP import for company " + companyId + "because another LDAP import is in process"));
            }
            return;
        }
        LockLocalServiceUtil.lock((long)defaultUserId, (String)PortalLDAPImporterUtil.class.getName(), (long)companyId, (String)PortalLDAPImporterImpl.class.getName(), (boolean)false, (long)86400000L);
        try {
            String postfix;
            String providerUrl;
            long[] ldapServerIds;
            long[] lArray = ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L);
            int n = ldapServerIds.length;
            int n2 = 0;
            while (n2 < n) {
                long ldapServerId = lArray[n2];
                this.importFromLDAP(ldapServerId, companyId);
                ++n2;
            }
            int ldapServerId = 0;
            while (!Validator.isNull((String)(providerUrl = PrefsPropsUtil.getString(companyId, "ldap.base.provider.url" + (postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId)))))) {
                this.importFromLDAP(ldapServerId, companyId);
                ++ldapServerId;
            }
        }
        finally {
            LockLocalServiceUtil.unlock((String)PortalLDAPImporterUtil.class.getName(), (long)companyId);
        }
    }

    public void importFromLDAP(long ldapServerId, long companyId) throws Exception {
        if (!LDAPSettingsUtil.isImportEnabled(companyId)) {
            return;
        }
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        if (ldapContext == null) {
            return;
        }
        try {
            try {
                Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
                Properties userExpandoMappings = LDAPSettingsUtil.getUserExpandoMappings(ldapServerId, companyId);
                Properties contactMappings = LDAPSettingsUtil.getContactMappings(ldapServerId, companyId);
                Properties contactExpandoMappings = LDAPSettingsUtil.getContactExpandoMappings(ldapServerId, companyId);
                Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
                String importMethod = PrefsPropsUtil.getString(companyId, "ldap.import.method");
                if (importMethod.equals(_IMPORT_BY_GROUP)) {
                    this.importFromLDAPByGroup(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, groupMappings);
                } else if (importMethod.equals(_IMPORT_BY_USER)) {
                    this.importFromLDAPByUser(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, groupMappings);
                }
            }
            catch (Exception e) {
                _log.error((Object)"Error importing LDAP users and groups", (Throwable)e);
                if (ldapContext != null) {
                    ldapContext.close();
                }
            }
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public User importLDAPUser(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, String password) throws Exception {
        Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
        Properties userExpandoMappings = LDAPSettingsUtil.getUserExpandoMappings(ldapServerId, companyId);
        Properties contactMappings = LDAPSettingsUtil.getContactMappings(ldapServerId, companyId);
        Properties contactExpandoMappings = LDAPSettingsUtil.getContactExpandoMappings(ldapServerId, companyId);
        User user = this.importUser(companyId, attributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, password);
        Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
        this.importGroups(ldapServerId, companyId, ldapContext, attributes, user, userMappings, groupMappings);
        return user;
    }

    public User importLDAPUser(long ldapServerId, long companyId, String emailAddress, String screenName) throws Exception {
        Context ldapContext = null;
        try {
            String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
            if (ldapContext == null) {
                throw new SystemException("Failed to bind to the LDAP server");
            }
            String filter = PrefsPropsUtil.getString(companyId, "ldap.auth.search.filter" + postfix);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter before transformation " + filter));
            }
            filter = StringUtil.replace((String)filter, (String[])new String[]{"@company_id@", "@email_address@", "@screen_name@"}, (String[])new String[]{String.valueOf(companyId), emailAddress, screenName});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter after transformation " + filter));
            }
            Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty(_USER_PASSWORD_SCREEN_NAME)).toLowerCase();
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            NamingEnumeration<SearchResult> enu = ldapContext.search(baseDN, filter, searchControls);
            if (enu.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                Binding binding = (Binding)enu.nextElement();
                Attributes attributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, (LdapContext)ldapContext, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding));
                User user = this.importLDAPUser(ldapServerId, companyId, (LdapContext)ldapContext, attributes, "");
                return user;
            }
            return null;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Problem accessing LDAP server " + e.getMessage()));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            throw new SystemException("Problem accessing LDAP server " + e.getMessage());
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public User importLDAPUser(long companyId, String emailAddress, String screenName) throws Exception {
        long[] ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L);
        if (ldapServerIds.length <= 0) {
            ldapServerIds = new long[1];
        }
        long[] lArray = ldapServerIds;
        int n = ldapServerIds.length;
        int n2 = 0;
        while (n2 < n) {
            long ldapServerId = lArray[n2];
            User user = this.importLDAPUser(ldapServerId, companyId, emailAddress, screenName);
            if (user != null) {
                return user;
            }
            ++n2;
        }
        if (_log.isDebugEnabled()) {
            if (Validator.isNotNull((String)emailAddress)) {
                _log.debug((Object)("User with the email address " + emailAddress + " was not found in any LDAP servers"));
            } else {
                _log.debug((Object)("User with the screen name " + screenName + " was not found in any LDAP servers"));
            }
        }
        return null;
    }

    public User importLDAPUserByScreenName(long companyId, String screenName) throws Exception {
        long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, screenName, "");
        SearchResult result = (SearchResult)PortalLDAPUtil.getUser(ldapServerId, companyId, screenName, "");
        if (result == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user was found in LDAP with screenName " + screenName));
            }
            return null;
        }
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        String fullUserDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, result);
        Attributes attributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN);
        User user = this.importLDAPUser(ldapServerId, companyId, ldapContext, attributes, "");
        ldapContext.close();
        return user;
    }

    public void setLDAPToPortalConverter(LDAPToPortalConverter ldapToPortalConverter) {
        this._ldapToPortalConverter = ldapToPortalConverter;
    }

    protected void addRole(long companyId, LDAPGroup ldapGroup, UserGroup userGroup) throws Exception {
        if (!PropsValues.LDAP_IMPORT_CREATE_ROLE_PER_GROUP) {
            return;
        }
        Role role = null;
        try {
            role = RoleLocalServiceUtil.getRole((long)companyId, (String)ldapGroup.getGroupName());
        }
        catch (NoSuchRoleException noSuchRoleException) {
            User defaultUser = UserLocalServiceUtil.getDefaultUser((long)companyId);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), "Autogenerated role from LDAP import");
            role = RoleLocalServiceUtil.addRole((long)defaultUser.getUserId(), (long)companyId, (String)ldapGroup.getGroupName(), null, descriptionMap, (int)1);
        }
        Group group = userGroup.getGroup();
        if (GroupLocalServiceUtil.hasRoleGroup((long)role.getRoleId(), (long)group.getGroupId())) {
            return;
        }
        GroupLocalServiceUtil.addRoleGroups((long)role.getRoleId(), (long[])new long[]{group.getGroupId()});
    }

    protected User addUser(long companyId, LDAPUser ldapUser, String password) throws Exception {
        byte[] portraitBytes;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding user " + ldapUser.getEmailAddress()));
        }
        boolean autoPassword = ldapUser.isAutoPassword();
        if (!PropsValues.LDAP_IMPORT_USER_PASSWORD_ENABLED && !(autoPassword = PropsValues.LDAP_IMPORT_USER_PASSWORD_AUTOGENERATED)) {
            String defaultPassword = PropsValues.LDAP_IMPORT_USER_PASSWORD_DEFAULT;
            if (defaultPassword.equalsIgnoreCase(_USER_PASSWORD_SCREEN_NAME)) {
                defaultPassword = ldapUser.getScreenName();
            }
            password = defaultPassword;
        }
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(ldapUser.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        User user = UserLocalServiceUtil.addUser((long)ldapUser.getCreatorUserId(), (long)companyId, (boolean)autoPassword, (String)password, (String)password, (boolean)ldapUser.isAutoScreenName(), (String)ldapUser.getScreenName(), (String)ldapUser.getEmailAddress(), (long)0L, (String)"", (Locale)ldapUser.getLocale(), (String)ldapUser.getFirstName(), (String)ldapUser.getMiddleName(), (String)ldapUser.getLastName(), (int)0, (int)0, (boolean)ldapUser.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)"", (long[])ldapUser.getGroupIds(), (long[])ldapUser.getOrganizationIds(), (long[])ldapUser.getRoleIds(), (long[])ldapUser.getUserGroupIds(), (boolean)ldapUser.isSendEmail(), (ServiceContext)ldapUser.getServiceContext());
        if (ldapUser.isUpdatePortrait() && (portraitBytes = ldapUser.getPortraitBytes()) != null && portraitBytes.length > 0) {
            user = UserLocalServiceUtil.updatePortrait((long)user.getUserId(), (byte[])portraitBytes);
        }
        return user;
    }

    protected void addUserGroupsNotAddedByLDAPImport(long userId, List<Long> userGroupIds) throws Exception {
        List userGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)userId);
        for (UserGroup userGroup : userGroups) {
            if (userGroupIds.contains(userGroup.getUserGroupId()) || userGroup.isAddedByLDAPImport()) continue;
            userGroupIds.add(userGroup.getUserGroupId());
        }
    }

    protected String escapeValue(String value) {
        return StringUtil.replace((String)value, (String)"\\,", (String)"\\\\,");
    }

    protected User getUser(long companyId, LDAPUser ldapUser) throws Exception {
        User user = null;
        try {
            String authType = PrefsPropsUtil.getString(companyId, "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
            user = authType.equals(_USER_PASSWORD_SCREEN_NAME) && !ldapUser.isAutoScreenName() ? UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)ldapUser.getScreenName()) : UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)ldapUser.getEmailAddress());
        }
        catch (NoSuchUserException noSuchUserException) {}
        return user;
    }

    protected Attribute getUsers(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, UserGroup userGroup, Properties groupMappings) throws Exception {
        Attribute attribute = attributes.get(groupMappings.getProperty(_IMPORT_BY_USER));
        if (attribute == null) {
            return null;
        }
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        StringBundler sb = new StringBundler(7);
        sb.append("(&");
        sb.append(PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix));
        sb.append("(");
        sb.append(groupMappings.getProperty("groupName"));
        sb.append("=");
        sb.append(this.escapeValue(userGroup.getName()));
        sb.append("))");
        return PortalLDAPUtil.getMultivaluedAttribute(companyId, ldapContext, baseDN, sb.toString(), attribute);
    }

    protected void importFromLDAPByGroup(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, Properties groupMappings) throws Exception {
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName")).toLowerCase();
            cookie = PortalLDAPUtil.getGroups(ldapServerId, companyId, ldapContext, cookie, 0, new String[]{groupMappingsGroupName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                try {
                    Attributes attributes = PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ldapContext, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, searchResult), true);
                    UserGroup userGroup = this.importUserGroup(companyId, attributes, groupMappings);
                    Attribute usersAttribute = this.getUsers(ldapServerId, companyId, ldapContext, attributes, userGroup, groupMappings);
                    if (usersAttribute == null) {
                        if (!_log.isInfoEnabled()) continue;
                        _log.info((Object)("No users found in " + userGroup.getName()));
                        continue;
                    }
                    this.importUsers(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, userGroup.getUserGroupId(), usersAttribute);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to import group " + searchResult), (Throwable)e);
                }
            }
        }
    }

    protected void importFromLDAPByUser(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, Properties groupMappings) throws Exception {
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty(_USER_PASSWORD_SCREEN_NAME)).toLowerCase();
            cookie = PortalLDAPUtil.getUsers(ldapServerId, companyId, ldapContext, cookie, 0, new String[]{userMappingsScreenName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                try {
                    Attributes userAttributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, searchResult));
                    User user = this.importUser(companyId, userAttributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, "");
                    this.importGroups(ldapServerId, companyId, ldapContext, userAttributes, user, userMappings, groupMappings);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to import user " + searchResult), (Throwable)e);
                }
            }
        }
    }

    protected List<Long> importGroup(long ldapServerId, long companyId, LdapContext ldapContext, String fullGroupDN, User user, Properties groupMappings, List<Long> newUserGroupIds) throws Exception {
        String userGroupIdKey = null;
        Long userGroupId = null;
        if (PropsValues.LDAP_IMPORT_GROUP_CACHE_ENABLED) {
            StringBundler sb = new StringBundler(5);
            sb.append(ldapServerId);
            sb.append("_");
            sb.append(companyId);
            sb.append("_");
            sb.append(fullGroupDN);
            userGroupIdKey = sb.toString();
            userGroupId = (Long)this._portalCache.get((Serializable)((Object)userGroupIdKey));
        }
        if (userGroupId != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping reimport of full group DN " + fullGroupDN));
            }
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Importing full group DN " + fullGroupDN));
            }
            Attributes groupAttributes = null;
            try {
                groupAttributes = PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ldapContext, fullGroupDN);
            }
            catch (NameNotFoundException nnfe) {
                _log.error((Object)("LDAP group not found with full group DN " + fullGroupDN), (Throwable)nnfe);
            }
            UserGroup userGroup = this.importUserGroup(companyId, groupAttributes, groupMappings);
            userGroupId = userGroup.getUserGroupId();
            if (PropsValues.LDAP_IMPORT_GROUP_CACHE_ENABLED) {
                this._portalCache.put((Serializable)((Object)userGroupIdKey), (Serializable)userGroupId);
            }
        }
        if (userGroupId != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding " + user.getUserId() + " to group " + userGroupId));
            }
            newUserGroupIds.add(userGroupId);
        }
        return newUserGroupIds;
    }

    protected void importGroups(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, User user, Properties userMappings, Properties groupMappings) throws Exception {
        List<Long> newUserGroupIds = new ArrayList<Long>();
        if (PrefsPropsUtil.getBoolean(companyId, "ldap.import.group.search.filter.enabled")) {
            String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            Binding binding = PortalLDAPUtil.getUser(ldapServerId, companyId, user.getScreenName(), user.getEmailAddress());
            String fullUserDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding);
            StringBundler sb = new StringBundler(9);
            sb.append("(");
            sb.append("&");
            sb.append(PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix));
            sb.append("(");
            sb.append(groupMappings.getProperty(_IMPORT_BY_USER));
            sb.append("=");
            sb.append(this.escapeValue(fullUserDN));
            sb.append(")");
            sb.append(")");
            byte[] cookie = new byte[]{};
            while (cookie != null) {
                ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
                String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName")).toLowerCase();
                cookie = PortalLDAPUtil.searchLDAP(companyId, ldapContext, cookie, 0, baseDN, sb.toString(), new String[]{groupMappingsGroupName}, searchResults);
                for (SearchResult searchResult : searchResults) {
                    String fullGroupDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, searchResult);
                    newUserGroupIds = this.importGroup(ldapServerId, companyId, ldapContext, fullGroupDN, user, groupMappings, newUserGroupIds);
                }
            }
        } else {
            String userMappingsGroup = userMappings.getProperty(_IMPORT_BY_GROUP);
            if (Validator.isNull((String)userMappingsGroup)) {
                return;
            }
            Attribute userGroupAttribute = attributes.get(userMappingsGroup);
            if (userGroupAttribute == null) {
                return;
            }
            int i = 0;
            while (i < userGroupAttribute.size()) {
                String fullGroupDN = (String)userGroupAttribute.get(i);
                newUserGroupIds = this.importGroup(ldapServerId, companyId, ldapContext, fullGroupDN, user, groupMappings, newUserGroupIds);
                ++i;
            }
        }
        this.addUserGroupsNotAddedByLDAPImport(user.getUserId(), newUserGroupIds);
        Iterator iterator = newUserGroupIds.iterator();
        while (iterator.hasNext()) {
            long newUserGroupId = (Long)iterator.next();
            UserLocalServiceUtil.addUserGroupUsers((long)newUserGroupId, (long[])new long[]{user.getUserId()});
        }
        List userUserGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)user.getUserId());
        for (UserGroup userGroup : userUserGroups) {
            if (newUserGroupIds.contains(userGroup.getUserGroupId())) continue;
            UserLocalServiceUtil.deleteUserGroupUser((long)userGroup.getUserGroupId(), (long)user.getUserId());
        }
    }

    protected User importUser(long companyId, Attributes attributes, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, String password) throws Exception {
        LDAPUserTransactionThreadLocal.setOriginatesFromLDAP(true);
        try {
            AttributesTransformer attributesTransformer = AttributesTransformerFactory.getInstance();
            attributes = attributesTransformer.transformUser(attributes);
            LDAPUser ldapUser = this._ldapToPortalConverter.importLDAPUser(companyId, attributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, password);
            User user = this.getUser(companyId, ldapUser);
            if (user != null && user.isDefaultUser()) {
                User user2 = user;
                return user2;
            }
            if (user == null) {
                user = this.addUser(companyId, ldapUser, password);
            }
            String modifiedDate = LDAPUtil.getAttributeString((Attributes)attributes, (String)"modifyTimestamp");
            user = this.updateUser(companyId, ldapUser, user, password, modifiedDate);
            this.updateExpandoAttributes(user, ldapUser);
            User user3 = user;
            return user3;
        }
        finally {
            LDAPUserTransactionThreadLocal.setOriginatesFromLDAP(false);
        }
    }

    protected UserGroup importUserGroup(long companyId, Attributes attributes, Properties groupMappings) throws Exception {
        UserGroup userGroup;
        LDAPGroup ldapGroup;
        block10: {
            AttributesTransformer attributesTransformer = AttributesTransformerFactory.getInstance();
            attributes = attributesTransformer.transformGroup(attributes);
            ldapGroup = this._ldapToPortalConverter.importLDAPGroup(companyId, attributes, groupMappings);
            userGroup = null;
            try {
                userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)ldapGroup.getGroupName());
                UserGroupLocalServiceUtil.updateUserGroup((long)companyId, (long)userGroup.getUserGroupId(), (String)ldapGroup.getGroupName(), (String)ldapGroup.getDescription());
            }
            catch (NoSuchUserGroupException noSuchUserGroupException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding user group to portal " + ldapGroup.getGroupName()));
                }
                long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
                LDAPUserGroupTransactionThreadLocal.setOriginatesFromLDAP(true);
                try {
                    try {
                        userGroup = UserGroupLocalServiceUtil.addUserGroup((long)defaultUserId, (long)companyId, (String)ldapGroup.getGroupName(), (String)ldapGroup.getDescription());
                    }
                    catch (Exception e) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to create user group " + ldapGroup.getGroupName()));
                        }
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)e, (Throwable)e);
                        }
                        LDAPUserGroupTransactionThreadLocal.setOriginatesFromLDAP(false);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    LDAPUserGroupTransactionThreadLocal.setOriginatesFromLDAP(false);
                    throw throwable;
                }
                LDAPUserGroupTransactionThreadLocal.setOriginatesFromLDAP(false);
            }
        }
        this.addRole(companyId, ldapGroup, userGroup);
        return userGroup;
    }

    protected void importUsers(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, long userGroupId, Attribute attribute) throws Exception {
        ArrayList<Long> newUserIds = new ArrayList<Long>(attribute.size());
        int i = 0;
        while (i < attribute.size()) {
            block8: {
                String fullUserDN = (String)attribute.get(i);
                Attributes userAttributes = null;
                try {
                    userAttributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN);
                }
                catch (NameNotFoundException nnfe) {
                    _log.error((Object)("LDAP user not found with fullUserDN " + fullUserDN), (Throwable)nnfe);
                    break block8;
                }
                try {
                    User user = this.importUser(companyId, userAttributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, "");
                    if (user != null) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Adding " + user.getUserId() + " to group " + userGroupId));
                        }
                        UserLocalServiceUtil.addUserGroupUsers((long)userGroupId, (long[])new long[]{user.getUserId()});
                        newUserIds.add(user.getUserId());
                    }
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to load user " + userAttributes), (Throwable)e);
                }
            }
            ++i;
        }
        List userGroupUsers = UserLocalServiceUtil.getUserGroupUsers((long)userGroupId);
        for (User user : userGroupUsers) {
            if (newUserIds.contains(user.getUserId())) continue;
            UserLocalServiceUtil.deleteUserGroupUser((long)userGroupId, (long)user.getUserId());
        }
    }

    protected void populateExpandoAttributes(ExpandoBridge expandoBridge, Map<String, String> expandoAttributes) {
        for (Map.Entry<String, String> expandoAttribute : expandoAttributes.entrySet()) {
            String name = expandoAttribute.getKey();
            if (!expandoBridge.hasAttribute(name)) continue;
            int type = expandoBridge.getAttributeType(name);
            Serializable value = ExpandoConverterUtil.getAttributeFromString(type, expandoAttribute.getValue());
            try {
                ExpandoValueLocalServiceUtil.addValue((long)expandoBridge.getCompanyId(), (String)expandoBridge.getClassName(), (String)"CUSTOM_FIELDS", (String)name, (long)expandoBridge.getClassPK(), (Object)value);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void updateExpandoAttributes(User user, LDAPUser ldapUser) throws Exception {
        ExpandoBridge userExpandoBridge = user.getExpandoBridge();
        this.populateExpandoAttributes(userExpandoBridge, ldapUser.getUserExpandoAttributes());
        Contact contact = user.getContact();
        ExpandoBridge contactExpandoBridge = contact.getExpandoBridge();
        this.populateExpandoAttributes(contactExpandoBridge, ldapUser.getContactExpandoAttributes());
    }

    protected User updateUser(long companyId, LDAPUser ldapUser, User user, String password, String modifiedDate) throws Exception {
        Date ldapUserModifiedDate;
        block16: {
            ldapUserModifiedDate = null;
            try {
                if (Validator.isNull((String)modifiedDate)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("LDAP entry never modified, skipping user " + user.getEmailAddress()));
                    }
                    return user;
                }
                ldapUserModifiedDate = LDAPUtil.parseDate((String)modifiedDate);
                if (ldapUserModifiedDate.equals(user.getModifiedDate()) && ldapUser.isAutoPassword()) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("User is already synchronized, skipping user " + user.getEmailAddress()));
                    }
                    return user;
                }
            }
            catch (ParseException pe) {
                if (!_log.isDebugEnabled()) break block16;
                _log.debug((Object)("Unable to parse LDAP modify timestamp " + modifiedDate), (Throwable)pe);
            }
        }
        boolean passwordReset = ldapUser.isPasswordReset();
        if (PrefsPropsUtil.getBoolean(companyId, "ldap.export.enabled", PropsValues.LDAP_EXPORT_ENABLED)) {
            passwordReset = user.isPasswordReset();
        }
        if (Validator.isNull((String)ldapUser.getScreenName())) {
            ldapUser.setAutoScreenName(true);
        }
        if (ldapUser.isAutoScreenName()) {
            ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
            ldapUser.setScreenName(screenNameGenerator.generate(companyId, user.getUserId(), ldapUser.getEmailAddress()));
        }
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(user.getContact().getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        if (PropsValues.LDAP_IMPORT_USER_PASSWORD_ENABLED) {
            UserLocalServiceUtil.updatePassword((long)user.getUserId(), (String)password, (String)password, (boolean)passwordReset, (boolean)true);
        }
        Contact contact = user.getContact();
        Set ldapIgnoreAttributes = SetUtil.fromArray((Object[])PropsValues.LDAP_USER_IGNORE_ATTRIBUTES);
        for (String attribute : ldapIgnoreAttributes) {
            Object value = BeanPropertiesUtil.getObjectSilent((Object)user, (String)attribute);
            if (value == null) {
                value = BeanPropertiesUtil.getObjectSilent((Object)contact, (String)attribute);
            }
            if (value == null) continue;
            BeanPropertiesUtil.setProperty((Object)ldapUser, (String)attribute, (Object)value);
        }
        user = UserLocalServiceUtil.updateUser((long)user.getUserId(), (String)password, (String)"", (String)"", (boolean)passwordReset, (String)ldapUser.getReminderQueryQuestion(), (String)ldapUser.getReminderQueryAnswer(), (String)ldapUser.getScreenName(), (String)ldapUser.getEmailAddress(), (long)ldapUser.getFacebookId(), (String)ldapUser.getOpenId(), (String)ldapUser.getLanguageId(), (String)ldapUser.getTimeZoneId(), (String)ldapUser.getGreeting(), (String)ldapUser.getComments(), (String)ldapUser.getFirstName(), (String)ldapUser.getMiddleName(), (String)ldapUser.getLastName(), (int)ldapUser.getPrefixId(), (int)ldapUser.getSuffixId(), (boolean)ldapUser.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)ldapUser.getSmsSn(), (String)ldapUser.getAimSn(), (String)ldapUser.getFacebookSn(), (String)ldapUser.getIcqSn(), (String)ldapUser.getJabberSn(), (String)ldapUser.getMsnSn(), (String)ldapUser.getMySpaceSn(), (String)ldapUser.getSkypeSn(), (String)ldapUser.getTwitterSn(), (String)ldapUser.getYmSn(), (String)ldapUser.getJobTitle(), (long[])ldapUser.getGroupIds(), (long[])ldapUser.getOrganizationIds(), (long[])ldapUser.getRoleIds(), (List)ldapUser.getUserGroupRoles(), (long[])ldapUser.getUserGroupIds(), (ServiceContext)ldapUser.getServiceContext());
        if (ldapUserModifiedDate != null) {
            user = UserLocalServiceUtil.updateModifiedDate((long)user.getUserId(), (Date)ldapUserModifiedDate);
        }
        if (ldapUser.isUpdatePortrait()) {
            byte[] portraitBytes = ldapUser.getPortraitBytes();
            if (portraitBytes != null && portraitBytes.length > 0) {
                UserLocalServiceUtil.updatePortrait((long)user.getUserId(), (byte[])portraitBytes);
            } else {
                UserLocalServiceUtil.deletePortrait((long)user.getUserId());
            }
        }
        return user;
    }
}

