/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.ContactConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ContactImpl;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.security.ldap.LDAPGroup;
import com.liferay.portal.security.ldap.LDAPToPortalConverter;
import com.liferay.portal.security.ldap.LDAPUser;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.util.ldap.LDAPUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseLDAPToPortalConverter
implements LDAPToPortalConverter {
    private static Log _log = LogFactoryUtil.getLog(BaseLDAPToPortalConverter.class);

    public LDAPGroup importLDAPGroup(long companyId, Attributes attributes, Properties groupMappings) throws Exception {
        LDAPGroup ldapGroup = new LDAPGroup();
        ldapGroup.setCompanyId(companyId);
        String description = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)groupMappings, (String)"description");
        ldapGroup.setDescription(description);
        String groupName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)groupMappings, (String)"groupName").toLowerCase();
        ldapGroup.setGroupName(groupName);
        return ldapGroup;
    }

    public LDAPUser importLDAPUser(long companyId, Attributes attributes, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, String password) throws Exception {
        boolean autoScreenName = PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate");
        String screenName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"screenName").toLowerCase();
        String emailAddress = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"emailAddress");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Screen name " + screenName + " and email address " + emailAddress));
        }
        String firstName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"firstName");
        String middleName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"middleName");
        String lastName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"lastName");
        if (Validator.isNull((String)firstName) || Validator.isNull((String)lastName)) {
            String fullName = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"fullName");
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String[] names = fullNameGenerator.splitFullName(fullName);
            firstName = names[0];
            middleName = names[1];
            lastName = names[2];
        }
        if (!autoScreenName && Validator.isNull((String)screenName)) {
            throw new UserScreenNameException("Screen name cannot be null for " + ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName));
        }
        if (Validator.isNull((String)emailAddress) && PrefsPropsUtil.getBoolean(companyId, "users.email.address.required")) {
            throw new UserEmailAddressException("Email address cannot be null for " + ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName));
        }
        LDAPUser ldapUser = new LDAPUser();
        ldapUser.setAutoPassword(password.equals(""));
        ldapUser.setAutoScreenName(autoScreenName);
        ContactImpl contact = new ContactImpl();
        Calendar birthdayCalendar = CalendarFactoryUtil.getCalendar((int)1970, (int)0, (int)1);
        contact.setBirthday(birthdayCalendar.getTime());
        contact.setMale(true);
        contact.setPrefixId(0);
        contact.setSuffixId(0);
        ldapUser.setContact((Contact)contact);
        Map<String, String> contactExpandoAttributes = this.getExpandoAttributes(attributes, contactExpandoMappings);
        ldapUser.setContactExpandoAttributes(contactExpandoAttributes);
        ldapUser.setCreatorUserId(0L);
        ldapUser.setGroupIds(null);
        ldapUser.setOrganizationIds(null);
        ldapUser.setPasswordReset(false);
        Object portrait = LDAPUtil.getAttributeObject((Attributes)attributes, (String)userMappings.getProperty("portrait"));
        if (portrait != null) {
            byte[] portraitBytes = (byte[])portrait;
            if (portraitBytes.length > 0) {
                ldapUser.setPortraitBytes((byte[])portrait);
            }
            ldapUser.setUpdatePortrait(true);
        }
        ldapUser.setRoleIds(null);
        ldapUser.setSendEmail(false);
        ServiceContext serviceContext = new ServiceContext();
        String uuid = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"uuid");
        serviceContext.setUuid(uuid);
        ldapUser.setServiceContext(serviceContext);
        ldapUser.setUpdatePassword(!password.equals(""));
        UserImpl user = new UserImpl();
        user.setCompanyId(companyId);
        user.setEmailAddress(emailAddress);
        user.setFirstName(firstName);
        String jobTitle = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)userMappings, (String)"jobTitle");
        user.setJobTitle(jobTitle);
        Locale locale = LocaleUtil.getDefault();
        user.setLanguageId(locale.toString());
        user.setLastName(lastName);
        user.setMiddleName(middleName);
        user.setOpenId("");
        user.setPasswordUnencrypted(password);
        user.setScreenName(screenName);
        ldapUser.setUser((User)user);
        Map<String, String> userExpandoAttributes = this.getExpandoAttributes(attributes, userExpandoMappings);
        ldapUser.setUserExpandoAttributes(userExpandoAttributes);
        ldapUser.setUserGroupIds(null);
        ldapUser.setUserGroupRoles(null);
        return ldapUser;
    }

    protected Map<String, String> getExpandoAttributes(Attributes attributes, Properties expandoMappings) throws NamingException {
        HashMap<String, String> expandoAttributes = new HashMap<String, String>();
        for (Object key : expandoMappings.keySet()) {
            String name = (String)key;
            String value = LDAPUtil.getAttributeString((Attributes)attributes, (Properties)expandoMappings, (String)name);
            if (!Validator.isNotNull((String)value)) continue;
            expandoAttributes.put(name, value);
        }
        return expandoAttributes;
    }
}

