/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class TransientTokenUtil {
    private static final SortedMap<Long, String> _tokens = Collections.synchronizedSortedMap(new TreeMap());

    public static boolean checkToken(String token) {
        long currentTime = System.currentTimeMillis();
        TransientTokenUtil.expungeExpiredToken(currentTime);
        Set<Map.Entry<Long, String>> tokens = _tokens.entrySet();
        Iterator<Map.Entry<Long, String>> itr = tokens.iterator();
        while (itr.hasNext()) {
            Map.Entry<Long, String> entry = itr.next();
            String curToken = entry.getValue();
            if (!token.equals(curToken)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public static void clearAll() {
        _tokens.clear();
    }

    public static String createToken(long timeTolive) {
        long currentTime = System.currentTimeMillis();
        long expireTime = currentTime + timeTolive;
        TransientTokenUtil.expungeExpiredToken(currentTime);
        String token = PortalUUIDUtil.generate();
        _tokens.put(expireTime, token);
        return token;
    }

    private static void expungeExpiredToken(long currentTime) {
        SortedMap<Long, String> headMap = _tokens.headMap(currentTime);
        headMap.clear();
    }
}

