/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AuthSettingsUtil;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiteMinderAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(SiteMinderAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            Company company = PortalUtil.getCompany((HttpServletRequest)request);
            long companyId = company.getCompanyId();
            if (!AuthSettingsUtil.isSiteMinderEnabled(companyId)) {
                return credentials;
            }
            String siteMinderUserHeader = request.getHeader(PrefsPropsUtil.getString(companyId, "siteminder.user.header", PropsValues.SITEMINDER_USER_HEADER));
            if (Validator.isNull((String)siteMinderUserHeader)) {
                return credentials;
            }
            String authType = company.getAuthType();
            User user = null;
            if (PrefsPropsUtil.getBoolean(companyId, "siteminder.import.from.ldap", PropsValues.SITEMINDER_IMPORT_FROM_LDAP)) {
                try {
                    user = authType.equals("emailAddress") ? PortalLDAPImporterUtil.importLDAPUser((long)companyId, (String)siteMinderUserHeader, (String)"") : PortalLDAPImporterUtil.importLDAPUser((long)companyId, (String)"", (String)siteMinderUserHeader);
                }
                catch (SystemException systemException) {}
            }
            if (user == null) {
                user = authType.equals("emailAddress") ? UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)siteMinderUserHeader) : UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)siteMinderUserHeader);
            }
            credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            return credentials;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return credentials;
        }
    }
}

