/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.security.auth.AuthToken;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import com.liferay.util.PwdGenerator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionAuthToken
implements AuthToken {
    private static final String _PORTAL = "PORTAL";

    public void check(HttpServletRequest request) throws PrincipalException {
        if (this.isIgnoreAction(request) || this.isIgnorePortlet(request)) {
            return;
        }
        String requestAuthenticationToken = ParamUtil.getString((HttpServletRequest)request, (String)"p_auth");
        String sessionAuthenticationToken = this.getSessionAuthenticationToken(request, _PORTAL);
        String propertiesAuthenticatonTokenSharedSecret = Encryptor.digest((String)PropsValues.AUTH_TOKEN_SHARED_SECRET);
        String requestAuthenticatonTokenSharedSecret = ParamUtil.getString((HttpServletRequest)request, (String)"p_auth_secret");
        if (!requestAuthenticationToken.equals(sessionAuthenticationToken) && !requestAuthenticatonTokenSharedSecret.equals(propertiesAuthenticatonTokenSharedSecret)) {
            throw new PrincipalException("Invalid authentication token");
        }
    }

    public String getToken(HttpServletRequest request) {
        return this.getSessionAuthenticationToken(request, _PORTAL);
    }

    public String getToken(HttpServletRequest request, long plid, String portletId) {
        return this.getSessionAuthenticationToken(request, PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId));
    }

    protected String getSessionAuthenticationToken(HttpServletRequest request, String key) {
        String tokenKey;
        HttpSession session = request.getSession();
        String sessionAuthenticationToken = (String)session.getAttribute(tokenKey = "LIFERAY_SHARED_AUTHENTICATION_TOKEN".concat(key));
        if (Validator.isNull((String)sessionAuthenticationToken)) {
            sessionAuthenticationToken = PwdGenerator.getPassword();
            session.setAttribute(tokenKey, (Object)sessionAuthenticationToken);
        }
        return sessionAuthenticationToken;
    }

    protected boolean isIgnoreAction(HttpServletRequest request) {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        String portletNamespace = PortalUtil.getPortletNamespace((String)ppid);
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)(String.valueOf(portletNamespace) + "struts_action"));
        return this.isIgnoreAction(companyId, ppid, strutsAction);
    }

    protected boolean isIgnoreAction(long companyId, String ppid, String strutsAction) {
        Portlet portlet;
        block5: {
            Set authTokenIgnoreActions = PortalUtil.getAuthTokenIgnoreActions();
            if (!authTokenIgnoreActions.contains(strutsAction)) {
                return false;
            }
            try {
                portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)ppid);
                if (portlet != null) break block5;
                return false;
            }
            catch (Exception exception) {}
        }
        String strutsPath = strutsAction.substring(1, strutsAction.lastIndexOf(47));
        if (strutsPath.equals(portlet.getStrutsPath()) || strutsPath.equals(portlet.getParentStrutsPath())) {
            return true;
        }
        return false;
    }

    protected boolean isIgnorePortlet(HttpServletRequest request) {
        String ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        return this.isIgnorePortlet(ppid);
    }

    protected boolean isIgnorePortlet(String portletId) {
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        Set authTokenIgnorePortlets = PortalUtil.getAuthTokenIgnorePortlets();
        return authTokenIgnorePortlets.contains(rootPortletId);
    }
}

