/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RememberMeAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(RememberMeAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) throws AutoLoginException {
        try {
            Company company;
            String[] credentials = null;
            String autoUserId = CookieKeys.getCookie(request, "ID", false);
            String autoPassword = CookieKeys.getCookie(request, "PASSWORD", false);
            String rememberMe = CookieKeys.getCookie(request, "REMEMBER_ME", false);
            String proxyPath = PortalUtil.getPathProxy();
            String contextPath = PortalUtil.getPathContext();
            if (proxyPath.equals(contextPath)) {
                if (Validator.isNotNull((String)request.getContextPath())) {
                    rememberMe = Boolean.TRUE.toString();
                }
            } else if (!contextPath.equals(request.getContextPath())) {
                rememberMe = Boolean.TRUE.toString();
            }
            if (Validator.isNotNull((String)autoUserId) && Validator.isNotNull((String)autoPassword) && Validator.isNotNull((String)rememberMe)) {
                company = PortalUtil.getCompany((HttpServletRequest)request);
                KeyValuePair kvp = null;
                if (company.isAutoLogin()) {
                    kvp = UserLocalServiceUtil.decryptUserId((long)company.getCompanyId(), (String)autoUserId, (String)autoPassword);
                    credentials = new String[]{kvp.getKey(), kvp.getValue(), Boolean.FALSE.toString()};
                }
            }
            if (credentials != null) {
                company = PortalUtil.getCompany((HttpServletRequest)request);
                User defaultUser = UserLocalServiceUtil.getDefaultUser((long)company.getCompanyId());
                long userId = GetterUtil.getLong((String)credentials[0]);
                if (defaultUser.getUserId() == userId) {
                    credentials = null;
                    this.removeCookies(request, response);
                }
            }
            return credentials;
        }
        catch (Exception e) {
            _log.warn((Object)e, (Throwable)e);
            this.removeCookies(request, response);
            throw new AutoLoginException((Throwable)e);
        }
    }

    protected void removeCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie("ID", "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        CookieKeys.addCookie(request, response, cookie);
        cookie = new Cookie("PASSWORD", "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        CookieKeys.addCookie(request, response, cookie);
    }
}

