/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.util.PropsValues;

public class EmailAddressGeneratorFactory {
    private static Log _log = LogFactoryUtil.getLog(EmailAddressGeneratorFactory.class);
    private static EmailAddressGenerator _emailAddressGenerator;

    public static EmailAddressGenerator getInstance() {
        if (_emailAddressGenerator == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Instantiate " + PropsValues.USERS_EMAIL_ADDRESS_GENERATOR));
            }
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            try {
                _emailAddressGenerator = (EmailAddressGenerator)classLoader.loadClass(PropsValues.USERS_EMAIL_ADDRESS_GENERATOR).newInstance();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Return " + _emailAddressGenerator.getClass().getName()));
        }
        return _emailAddressGenerator;
    }

    public static void setInstance(EmailAddressGenerator emailAddressGenerator) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set " + emailAddressGenerator.getClass().getName()));
        }
        _emailAddressGenerator = emailAddressGenerator;
    }
}

