/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene.dump;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.lucene.dump.IndexCommitMetaInfo;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class IndexCommitSerializationUtil {
    private static final int _BUFFER_SIZE = 8192;
    private static final String _SEGMENTS_GEN_FILE_NAME = "segments.gen";
    private static Log _log = LogFactoryUtil.getLog(IndexCommitSerializationUtil.class);

    public static void deserializeIndex(InputStream inputStream, Directory directory) throws IOException {
        if (PropsValues.INDEX_DUMP_COMPRESSION_ENABLED) {
            inputStream = new GZIPInputStream(inputStream);
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            IndexCommitMetaInfo indexCommitMetaInfo = null;
            try {
                indexCommitMetaInfo = (IndexCommitMetaInfo)objectInputStream.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.getMessage());
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Deserializing " + indexCommitMetaInfo));
            }
            if (indexCommitMetaInfo.isEmpty()) {
                return;
            }
            List<IndexCommitMetaInfo.Segment> segments = indexCommitMetaInfo.getSegments();
            for (IndexCommitMetaInfo.Segment segment : segments) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Deserializing segment " + segment));
                }
                IndexCommitSerializationUtil.deserializeSegment(objectInputStream, segment.getFileSize(), directory.createOutput(segment.getFileName()));
            }
            IndexCommitSerializationUtil.writeSegmentsGen(directory, indexCommitMetaInfo.getGeneration());
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    public static void serializeIndex(IndexCommit indexCommit, OutputStream outputStream) throws IOException {
        if (PropsValues.INDEX_DUMP_COMPRESSION_ENABLED) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        ObjectOutputStream objectOputStream = new ObjectOutputStream(outputStream);
        IndexCommitMetaInfo indexCommitMetaInfo = new IndexCommitMetaInfo(indexCommit);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Serializing " + indexCommitMetaInfo));
        }
        objectOputStream.writeObject(indexCommitMetaInfo);
        List<IndexCommitMetaInfo.Segment> segments = indexCommitMetaInfo.getSegments();
        Directory directory = indexCommit.getDirectory();
        for (IndexCommitMetaInfo.Segment segment : segments) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Serializing segment " + segment));
            }
            IndexCommitSerializationUtil.serializeSegment(directory.openInput(segment.getFileName()), segment.getFileSize(), objectOputStream);
        }
        objectOputStream.flush();
        if (PropsValues.INDEX_DUMP_COMPRESSION_ENABLED) {
            GZIPOutputStream gZipOutputStream = (GZIPOutputStream)outputStream;
            gZipOutputStream.finish();
        }
    }

    private static void deserializeSegment(InputStream inputStream, long length, IndexOutput indexOutput) throws IOException {
        try {
            indexOutput.setLength(length);
            byte[] buffer = new byte[8192];
            long received = 0L;
            while (received < length) {
                int bufferSize = 8192;
                if (received + 8192L > length) {
                    bufferSize = (int)(length - received);
                }
                int actualSize = inputStream.read(buffer, 0, bufferSize);
                indexOutput.writeBytes(buffer, actualSize);
                received += (long)actualSize;
            }
        }
        finally {
            indexOutput.close();
        }
    }

    private static void serializeSegment(IndexInput indexInput, long length, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[8192];
        int count = (int)(length / 8192L);
        int tail = (int)(length - (long)(count * 8192));
        try {
            int i = 0;
            while (i < count) {
                indexInput.readBytes(buffer, 0, 8192);
                outputStream.write(buffer);
                ++i;
            }
            indexInput.readBytes(buffer, 0, tail);
            outputStream.write(buffer, 0, tail);
        }
        finally {
            indexInput.close();
        }
    }

    private static void writeSegmentsGen(Directory directory, long generation) throws IOException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Writing segments.gen with generation " + generation));
        }
        IndexOutput indexOutput = directory.createOutput(_SEGMENTS_GEN_FILE_NAME);
        try {
            indexOutput.writeInt(-2);
            indexOutput.writeLong(generation);
            indexOutput.writeLong(generation);
        }
        finally {
            indexOutput.close();
        }
    }
}

