/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import java.io.IOException;
import java.io.InputStream;

public class LuceneClusterUtil {
    public static void loadIndexesFromCluster(long companyId) throws SystemException {
        Address bootupAddress = LuceneHelperUtil.selectBootupClusterAddress(companyId, LuceneHelperUtil.getLastGeneration(companyId));
        LuceneClusterUtil.loadIndexesFromCluster(new long[]{companyId}, bootupAddress);
    }

    public static void loadIndexesFromCluster(long[] companyIds, Address bootupAddress) throws SystemException {
        if (bootupAddress == null) {
            return;
        }
        InputStream inputStream = null;
        long[] lArray = companyIds;
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            try {
                try {
                    inputStream = LuceneHelperUtil.getLoadIndexesInputStreamFromCluster(companyId, bootupAddress);
                    LuceneHelperUtil.loadIndex(companyId, inputStream);
                }
                catch (SystemException se) {
                    throw se;
                }
                catch (IOException ioe) {
                    throw new SystemException((Throwable)ioe);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        throw new SystemException((Throwable)ioe);
                    }
                }
            }
            ++n2;
        }
    }
}

