/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.browseengine.bobo.api.BoboBrowser;
import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseResult;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.impl.MultiValueFacetHandler;
import com.browseengine.bobo.facets.impl.RangeFacetHandler;
import com.browseengine.bobo.facets.impl.SimpleFacetHandler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.QueryTranslatorUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.search.facet.RangeFacet;
import com.liferay.portal.kernel.search.facet.SimpleFacet;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.BoboFacetCollector;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;

public class LuceneIndexSearcherImpl
implements IndexSearcher {
    private static Log _log = LogFactoryUtil.getLog(LuceneIndexSearcherImpl.class);

    /*
     * Exception decompiling
     */
    public Hits search(String searchEngineId, long companyId, com.liferay.portal.kernel.search.Query query, Sort[] sorts, int start, int end) throws SearchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 14[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public Hits search(SearchContext searchContext, com.liferay.portal.kernel.search.Query query) throws SearchException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Query " + query));
        }
        Hits hits = null;
        org.apache.lucene.search.IndexSearcher indexSearcher = null;
        Map facets = null;
        BrowseRequest browseRequest = null;
        BoboBrowser browsable = null;
        try {
            try {
                indexSearcher = LuceneHelperUtil.getSearcher(searchContext.getCompanyId(), true);
                ArrayList<Object> facetHandlers = new ArrayList<Object>();
                facets = searchContext.getFacets();
                for (Facet facet : facets.values()) {
                    JSONObject dataJSONObject;
                    if (facet.isStatic()) continue;
                    FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
                    if (facet instanceof MultiValueFacet) {
                        MultiValueFacetHandler multiValueFacetHandler = new MultiValueFacetHandler(facetConfiguration.getFieldName(), facetConfiguration.getFieldName());
                        dataJSONObject = facetConfiguration.getData();
                        if (dataJSONObject.has("maxTerms")) {
                            multiValueFacetHandler.setMaxItems(dataJSONObject.getInt("maxTerms"));
                        }
                        facetHandlers.add(multiValueFacetHandler);
                        continue;
                    }
                    if (facet instanceof RangeFacet) {
                        ArrayList<String> ranges = new ArrayList<String>();
                        dataJSONObject = facetConfiguration.getData();
                        JSONArray rangesJSONArray = dataJSONObject.getJSONArray("ranges");
                        if (rangesJSONArray != null) {
                            int i = 0;
                            while (i < rangesJSONArray.length()) {
                                JSONObject rangeJSONObject = rangesJSONArray.getJSONObject(i);
                                ranges.add(rangeJSONObject.getString("range"));
                                ++i;
                            }
                        }
                        RangeFacetHandler rangeFacetHandler = new RangeFacetHandler(facetConfiguration.getFieldName(), facetConfiguration.getFieldName(), ranges);
                        rangeFacetHandler.setTermCountSize(FacetHandler.TermCountSize.large);
                        facetHandlers.add(rangeFacetHandler);
                        continue;
                    }
                    if (!(facet instanceof SimpleFacet)) continue;
                    SimpleFacetHandler simpleFacetHandler = new SimpleFacetHandler(facetConfiguration.getFieldName(), facetConfiguration.getFieldName());
                    facetHandlers.add(simpleFacetHandler);
                }
                BoboIndexReader boboIndexReader = BoboIndexReader.getInstance((IndexReader)indexSearcher.getIndexReader(), facetHandlers);
                SortField[] sortFields = new SortField[]{};
                Sort[] sorts = searchContext.getSorts();
                if (sorts != null) {
                    sortFields = new SortField[sorts.length];
                    int i = 0;
                    while (i < sorts.length) {
                        Sort sort = sorts[i];
                        sortFields[i] = new SortField(sort.getFieldName(), sort.getType(), sort.isReverse());
                        ++i;
                    }
                }
                browseRequest = new BrowseRequest();
                for (Facet facet : facets.values()) {
                    if (facet.isStatic()) continue;
                    FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
                    FacetSpec facetSpec = new FacetSpec();
                    facetSpec.setOrderBy(FacetSpec.FacetSortSpec.valueOf((String)facetConfiguration.getOrder()));
                    browseRequest.setFacetSpec(facet.getFieldName(), facetSpec);
                }
                browseRequest.setCount(PropsValues.INDEX_SEARCH_LIMIT);
                browseRequest.setOffset(0);
                browseRequest.setQuery((Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query));
                browseRequest.setSort(sortFields);
                browsable = new BoboBrowser(boboIndexReader);
                long startTime = System.currentTimeMillis();
                BrowseResult browseResult = browsable.browse(browseRequest);
                BrowseHit[] browseHits = browseResult.getHits();
                long endTime = System.currentTimeMillis();
                float searchTime = (float)(endTime - startTime) / 1000.0f;
                hits = this.toHits(indexSearcher, new HitDocs(browseHits), query, startTime, searchTime, searchContext.getStart(), searchContext.getEnd());
                Map facetMap = browseResult.getFacetMap();
                for (Map.Entry entry : facetMap.entrySet()) {
                    Facet facet = (Facet)facets.get(entry.getKey());
                    FacetAccessible facetAccessible = (FacetAccessible)entry.getValue();
                    BoboFacetCollector facetCollector = new BoboFacetCollector((String)entry.getKey(), facetAccessible);
                    facet.setFacetCollector((FacetCollector)facetCollector);
                }
            }
            catch (BooleanQuery.TooManyClauses tooManyClauses) {
                int maxClauseCount = BooleanQuery.getMaxClauseCount();
                BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
                try {
                    try {
                        long startTime = System.currentTimeMillis();
                        BrowseResult result = browsable.browse(browseRequest);
                        BrowseHit[] browseHits = result.getHits();
                        long endTime = System.currentTimeMillis();
                        float searchTime = (float)(endTime - startTime) / 1000.0f;
                        hits = this.toHits(indexSearcher, new HitDocs(browseHits), query, startTime, searchTime, searchContext.getStart(), searchContext.getEnd());
                        Map facetMap = result.getFacetMap();
                        for (Map.Entry entry : facetMap.entrySet()) {
                            Facet facet = (Facet)facets.get(entry.getKey());
                            FacetAccessible facetAccessible = (FacetAccessible)entry.getValue();
                            BoboFacetCollector facetCollector = new BoboFacetCollector((String)entry.getKey(), facetAccessible);
                            facet.setFacetCollector((FacetCollector)facetCollector);
                        }
                    }
                    catch (Exception e) {
                        throw new SearchException((Throwable)e);
                    }
                }
                finally {
                    BooleanQuery.setMaxClauseCount((int)maxClauseCount);
                }
            }
            catch (ParseException pe) {
                HitsImpl hitsImpl;
                block47: {
                    _log.error((Object)("Query " + query), (Throwable)pe);
                    hitsImpl = new HitsImpl();
                    if (browsable == null) break block47;
                    try {
                        browsable.close();
                    }
                    catch (IOException ioe) {
                        _log.error((Object)ioe, (Throwable)ioe);
                    }
                }
                if (indexSearcher != null) {
                    try {
                        indexSearcher.close();
                    }
                    catch (IOException ioe) {
                        _log.error((Object)ioe, (Throwable)ioe);
                    }
                }
                return hitsImpl;
            }
            catch (Exception e) {
                throw new SearchException((Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (browsable != null) {
                try {
                    browsable.close();
                }
                catch (IOException ioe) {
                    _log.error((Object)ioe, (Throwable)ioe);
                }
            }
            if (indexSearcher != null) {
                try {
                    indexSearcher.close();
                }
                catch (IOException ioe) {
                    _log.error((Object)ioe, (Throwable)ioe);
                }
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search found " + hits.getLength() + " results in " + hits.getSearchTime() + "ms"));
        }
        return hits;
    }

    protected DocumentImpl getDocument(org.apache.lucene.document.Document oldDocument) {
        DocumentImpl newDocument = new DocumentImpl();
        List oldFieldables = oldDocument.getFields();
        for (Fieldable oldFieldable : oldFieldables) {
            Field newField = null;
            String[] values = oldDocument.getValues(oldFieldable.name());
            newField = values != null && values.length > 1 ? new Field(oldFieldable.name(), values) : new Field(oldFieldable.name(), oldFieldable.stringValue());
            newField.setNumeric(oldFieldable instanceof NumericField);
            newField.setTokenized(oldFieldable.isTokenized());
            newDocument.add(newField);
        }
        return newDocument;
    }

    protected String[] getQueryTerms(com.liferay.portal.kernel.search.Query query) {
        String[] queryTerms = new String[]{};
        try {
            queryTerms = LuceneHelperUtil.getQueryTerms((Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query));
        }
        catch (ParseException pe) {
            _log.error((Object)("Query " + query), (Throwable)pe);
        }
        return queryTerms;
    }

    protected String getSnippet(org.apache.lucene.document.Document doc, com.liferay.portal.kernel.search.Query query, String field, Locale locale) throws IOException {
        String localizedName = DocumentImpl.getLocalizedName((Locale)locale, (String)field);
        Object[] values = doc.getValues(localizedName);
        if (values == null || values.length == 0) {
            values = doc.getValues(field);
        }
        String snippet = null;
        if (Validator.isNull((Object[])values)) {
            return snippet;
        }
        String s = StringUtil.merge((Object[])values);
        try {
            snippet = LuceneHelperUtil.getSnippet((Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query), field, s);
        }
        catch (ParseException pe) {
            _log.error((Object)("Query " + query), (Throwable)pe);
        }
        return snippet;
    }

    protected Hits toHits(org.apache.lucene.search.IndexSearcher indexSearcher, HitDocs hitDocs, com.liferay.portal.kernel.search.Query query, long startTime, float searchTime, int start, int end) throws IOException, ParseException {
        int length = hitDocs.getTotalHits();
        if (start == -1 && end == -1) {
            start = 0;
            end = length;
        }
        String[] queryTerms = this.getQueryTerms(query);
        IndexReader indexReader = indexSearcher.getIndexReader();
        ArrayList indexedFieldNames = new ArrayList(indexReader.getFieldNames(IndexReader.FieldOption.INDEXED));
        Query luceneQuery = (Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query);
        int scoredFieldNamesCount = LuceneHelperUtil.countScoredFieldNames(luceneQuery, ArrayUtil.toStringArray((Object[])indexedFieldNames.toArray()));
        HitsImpl hits = new HitsImpl();
        if (start > -1 && start <= end) {
            int subsetTotal;
            if (end > length) {
                end = length;
            }
            if (start > end) {
                start = end;
            }
            if ((subsetTotal = end - start) > PropsValues.INDEX_SEARCH_LIMIT) {
                subsetTotal = PropsValues.INDEX_SEARCH_LIMIT;
            }
            ArrayList<DocumentImpl> subsetDocs = new ArrayList<DocumentImpl>(subsetTotal);
            ArrayList<String> subsetSnippets = new ArrayList<String>(subsetTotal);
            ArrayList<Float> subsetScores = new ArrayList<Float>(subsetTotal);
            QueryConfig queryConfig = query.getQueryConfig();
            int i = start;
            while (i < end) {
                if (i >= PropsValues.INDEX_SEARCH_LIMIT) break;
                int docId = hitDocs.getDocId(i);
                org.apache.lucene.document.Document document = indexSearcher.doc(docId);
                DocumentImpl subsetDocument = this.getDocument(document);
                String subsetSnippet = "";
                if (queryConfig.isHighlightEnabled()) {
                    subsetSnippet = this.getSnippet(document, query, "content", queryConfig.getLocale());
                }
                subsetDocument.addText("snippet", subsetSnippet);
                subsetSnippets.add(subsetSnippet);
                subsetDocs.add(subsetDocument);
                Float subsetScore = Float.valueOf(hitDocs.getScore(i));
                if (scoredFieldNamesCount > 0) {
                    subsetScore = Float.valueOf(subsetScore.floatValue() / (float)scoredFieldNamesCount);
                }
                subsetScores.add(subsetScore);
                if (_log.isDebugEnabled()) {
                    try {
                        Explanation explanation = indexSearcher.explain(luceneQuery, docId);
                        _log.debug((Object)explanation.toString());
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
            hits.setStart(startTime);
            hits.setSearchTime(searchTime);
            hits.setQuery(query);
            hits.setQueryTerms(queryTerms);
            hits.setDocs(subsetDocs.toArray(new Document[subsetDocs.size()]));
            hits.setLength(length);
            hits.setSnippets(subsetSnippets.toArray(new String[subsetSnippets.size()]));
            hits.setScores(subsetScores.toArray(new Float[subsetScores.size()]));
        }
        return hits;
    }

    private class HitDocs {
        private BrowseHit[] _browseHits;
        private TopFieldDocs _topFieldDocs;

        public HitDocs(BrowseHit[] browseHits) {
            this._browseHits = browseHits;
        }

        public HitDocs(TopFieldDocs topFieldDocs) {
            this._topFieldDocs = topFieldDocs;
        }

        public int getDocId(int i) {
            if (this._topFieldDocs != null) {
                ScoreDoc scoreDoc = this._topFieldDocs.scoreDocs[i];
                return scoreDoc.doc;
            }
            if (this._browseHits != null) {
                return this._browseHits[i].getDocid();
            }
            throw new IllegalStateException();
        }

        public float getScore(int i) {
            if (this._topFieldDocs != null) {
                ScoreDoc scoreDoc = this._topFieldDocs.scoreDocs[i];
                return scoreDoc.score;
            }
            if (this._browseHits != null) {
                return this._browseHits[i].getScore();
            }
            throw new IllegalStateException();
        }

        public int getTotalHits() {
            if (this._topFieldDocs != null) {
                return this._topFieldDocs.totalHits;
            }
            if (this._browseHits != null) {
                return this._browseHits.length;
            }
            throw new IllegalStateException();
        }
    }
}

