/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.generic;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseBooleanQueryImpl;
import com.liferay.portal.kernel.search.BaseQueryImpl;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanClauseOccurImpl;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.generic.BooleanClauseImpl;
import com.liferay.portal.search.generic.QueryTermImpl;
import com.liferay.portal.search.generic.TermQueryImpl;
import com.liferay.portal.search.generic.TermRangeQueryImpl;
import com.liferay.portal.search.generic.WildcardQueryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanQueryImpl
extends BaseBooleanQueryImpl {
    private static Log _log = LogFactoryUtil.getLog(BooleanQueryImpl.class);
    private List<BooleanClause> _booleanClauses = new ArrayList<BooleanClause>();

    public void add(Query query, BooleanClauseOccur booleanClauseOccur) {
        this._booleanClauses.add(new BooleanClauseImpl(query, booleanClauseOccur));
    }

    public void add(Query query, String occur) {
        BooleanClauseOccurImpl booleanClauseOccur = new BooleanClauseOccurImpl(occur);
        this.add(query, (BooleanClauseOccur)booleanClauseOccur);
    }

    public void addExactTerm(String field, boolean value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, Boolean value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, double value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, Double value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, int value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, Integer value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, long value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, Long value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, short value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, Short value) {
        this.addExactTerm(field, String.valueOf(value));
    }

    public void addExactTerm(String field, String value) {
        TermQueryImpl termQuery = new TermQueryImpl(new QueryTermImpl(field, String.valueOf(value)));
        this.add((Query)termQuery, BooleanClauseOccur.SHOULD);
    }

    public void addNumericRangeTerm(String field, int startValue, int endValue) {
        int i = startValue;
        while (i <= endValue) {
            this.addExactTerm(field, i);
            ++i;
        }
    }

    public void addNumericRangeTerm(String field, Integer startValue, Integer endValue) {
        this.addNumericRangeTerm(field, (int)startValue, (int)endValue);
    }

    public void addNumericRangeTerm(String field, long startValue, long endValue) {
        long i = startValue;
        while (i <= endValue) {
            this.addExactTerm(field, i);
            ++i;
        }
    }

    public void addNumericRangeTerm(String field, Long startValue, Long endValue) {
        this.addNumericRangeTerm(field, (long)startValue, (long)endValue);
    }

    public void addNumericRangeTerm(String field, short startValue, short endValue) {
        short i = startValue;
        while (i <= endValue) {
            this.addExactTerm(field, i);
            i = (short)(i + 1);
        }
    }

    public void addNumericRangeTerm(String field, Short startValue, Short endValue) {
        this.addNumericRangeTerm(field, (short)startValue, (short)endValue);
    }

    public void addRangeTerm(String field, int startValue, int endValue) {
        TermRangeQueryImpl termRangeQuery = new TermRangeQueryImpl(field, String.valueOf(startValue), String.valueOf(endValue), true, true);
        this.add((Query)termRangeQuery, BooleanClauseOccur.SHOULD);
    }

    public void addRangeTerm(String field, Integer startValue, Integer endValue) {
        this.addRangeTerm(field, (int)startValue, (int)endValue);
    }

    public void addRangeTerm(String field, long startValue, long endValue) {
        TermRangeQueryImpl termRangeQuery = new TermRangeQueryImpl(field, String.valueOf(startValue), String.valueOf(endValue), true, true);
        this.add((Query)termRangeQuery, BooleanClauseOccur.SHOULD);
    }

    public void addRangeTerm(String field, Long startValue, Long endValue) {
        this.addRangeTerm(field, (long)startValue, (long)endValue);
    }

    public void addRangeTerm(String field, short startValue, short endValue) {
        TermRangeQueryImpl termRangeQuery = new TermRangeQueryImpl(field, String.valueOf(startValue), String.valueOf(endValue), true, true);
        this.add((Query)termRangeQuery, BooleanClauseOccur.SHOULD);
    }

    public void addRangeTerm(String field, Short startValue, Short endValue) {
        this.addRangeTerm(field, (short)startValue, (short)endValue);
    }

    public void addRangeTerm(String field, String startValue, String endValue) {
        TermRangeQueryImpl termRangeQuery = new TermRangeQueryImpl(field, startValue, endValue, true, true);
        this.add((Query)termRangeQuery, BooleanClauseOccur.SHOULD);
    }

    public void addRequiredTerm(String field, boolean value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, Boolean value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, double value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, Double value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, int value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, Integer value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, long value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, Long value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, short value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, Short value) {
        this.addRequiredTerm(field, String.valueOf(value), false);
    }

    public void addRequiredTerm(String field, String value) {
        this.addRequiredTerm(field, value, false);
    }

    public void addRequiredTerm(String field, String value, boolean like) {
        this.addRequiredTerm(field, value, like, false);
    }

    public void addRequiredTerm(String field, String value, boolean like, boolean parseKeywords) {
        if (like) {
            value = StringUtil.replace((String)value, (String)"%", (String)"");
        }
        String[] values = null;
        values = parseKeywords ? this.parseKeywords(value) : new String[]{value};
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                String curValue = stringArray[n2];
                QueryTermImpl queryTerm = new QueryTermImpl(field, String.valueOf(curValue));
                BaseQueryImpl query = null;
                query = like ? new WildcardQueryImpl(queryTerm) : new TermQueryImpl(queryTerm);
                try {
                    booleanQuery.add((Query)query, BooleanClauseOccur.SHOULD);
                }
                catch (ParseException pe) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)"ParseException thrown, skipping query", (Throwable)pe);
                }
            }
            ++n2;
        }
        this.add((Query)booleanQuery, BooleanClauseOccur.MUST);
    }

    public void addTerm(String field, long value) {
        this.addTerm(field, String.valueOf(value), false);
    }

    public void addTerm(String field, String value) {
        this.addTerm(field, value, false);
    }

    public void addTerm(String field, String value, boolean like) {
        this.addTerm(field, value, like, BooleanClauseOccur.SHOULD);
    }

    public void addTerm(String field, String value, boolean like, BooleanClauseOccur booleanClauseOccur) {
        BaseQueryImpl query = null;
        query = like ? new WildcardQueryImpl(new QueryTermImpl(field, String.valueOf(value))) : new TermQueryImpl(new QueryTermImpl(field, String.valueOf(value)));
        this.add((Query)query, booleanClauseOccur);
    }

    public void addTerm(String field, String value, boolean like, boolean parseKeywords) {
        if (like) {
            value = StringUtil.replace((String)value, (String)"%", (String)"");
        }
        if (parseKeywords) {
            String[] keywords;
            String[] stringArray = keywords = this.parseKeywords(value);
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                this.addTerm(field, keyword, like);
                ++n2;
            }
        } else {
            this.addTerm(field, value, like);
        }
    }

    public List<BooleanClause> clauses() {
        return Collections.unmodifiableList(this._booleanClauses);
    }

    public Object getWrappedQuery() {
        return this;
    }

    public boolean hasClauses() {
        return !this._booleanClauses.isEmpty();
    }
}

