/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseOpenSearchImpl;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class PortalOpenSearchImpl
extends BaseOpenSearchImpl {
    public static final String SEARCH_PATH = "/c/search/open_search";
    private static Log _log = LogFactoryUtil.getLog(PortalOpenSearchImpl.class);

    public String search(HttpServletRequest request, long groupId, long userId, String keywords, int startPage, int itemsPerPage, String format) throws SearchException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            int start = startPage * itemsPerPage - itemsPerPage;
            int end = startPage * itemsPerPage;
            Hits results = CompanyLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long)userId, (String)keywords, (int)start, (int)end);
            String[] queryTerms = results.getQueryTerms();
            int total = results.getLength();
            Object[] values = this.addSearchResults(queryTerms, keywords, startPage, itemsPerPage, total, start, "Liferay Portal Search: " + keywords, SEARCH_PATH, format, themeDisplay);
            com.liferay.portal.kernel.xml.Document doc = (com.liferay.portal.kernel.xml.Document)values[0];
            Element root = (Element)values[1];
            int i = 0;
            while (i < results.getDocs().length) {
                Document result = results.doc(i);
                String portletId = result.get("portletId");
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
                if (portlet != null) {
                    String portletTitle = PortalUtil.getPortletTitle((String)portletId, (User)themeDisplay.getUser());
                    long resultGroupId = GetterUtil.getLong((String)result.get("groupId"));
                    long resultScopeGroupId = GetterUtil.getLong((String)result.get("scopeGroupId"));
                    if (resultScopeGroupId == 0L) {
                        resultScopeGroupId = themeDisplay.getScopeGroupId();
                    }
                    String entryClassName = GetterUtil.getString((String)result.get("entryClassName"));
                    long entryClassPK = GetterUtil.getLong((String)result.get("entryClassPK"));
                    String title = "";
                    PortletURL portletURL = this.getPortletURL(request, portletId, resultScopeGroupId);
                    String url = portletURL.toString();
                    Date modifiedDate = result.getDate("modified");
                    String content = "";
                    Indexer indexer = IndexerRegistryUtil.getIndexer((String)entryClassName);
                    if (indexer != null) {
                        String snippet = results.snippet(i);
                        Summary summary = indexer.getSummary(result, themeDisplay.getLocale(), snippet, portletURL);
                        title = summary.getTitle();
                        url = portletURL.toString();
                        content = summary.getContent();
                        if (portlet.getPortletId().equals("15")) {
                            url = this.getJournalURL(themeDisplay, resultGroupId, result);
                        }
                    }
                    double score = results.score(i);
                    this.addSearchResult(root, resultGroupId, resultScopeGroupId, entryClassName, entryClassPK, String.valueOf(portletTitle) + " " + '\u00bb' + " " + title, url, modifiedDate, content, score, format);
                }
                ++i;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Return\n" + doc.asXML()));
            }
            return doc.asXML();
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    protected String getJournalURL(ThemeDisplay themeDisplay, long groupId, Document result) throws Exception {
        String articleId = result.get("entryClassPK");
        JournalArticle article = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId);
        if (Validator.isNotNull((String)article.getLayoutUuid())) {
            String groupFriendlyURL = PortalUtil.getGroupFriendlyURL((Group)GroupLocalServiceUtil.getGroup((long)article.getGroupId()), (boolean)false, (ThemeDisplay)themeDisplay);
            return groupFriendlyURL.concat("/-/").concat(article.getUrlTitle());
        }
        Layout layout = themeDisplay.getLayout();
        List hitLayoutIds = JournalContentSearchLocalServiceUtil.getLayoutIds((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (String)articleId);
        if (!hitLayoutIds.isEmpty()) {
            Long hitLayoutId = (Long)hitLayoutIds.get(0);
            Layout hitLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)hitLayoutId);
            return PortalUtil.getLayoutURL((Layout)hitLayout, (ThemeDisplay)themeDisplay);
        }
        StringBundler sb = new StringBundler(7);
        sb.append(themeDisplay.getPathMain());
        sb.append("/journal/view_article_content?groupId=");
        sb.append(groupId);
        sb.append("&articleId=");
        sb.append(articleId);
        sb.append("&version=");
        String version = result.get("version");
        sb.append(version);
        return sb.toString();
    }
}

