/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.ruby;

import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.LocalContextProvider;
import org.jruby.exceptions.RaiseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyExecutor
extends BaseScriptingExecutor {
    public static final String LANGUAGE = "ruby";
    private static final String _COMPILE_MODE_FORCE = "force";
    private static final String _COMPILE_MODE_JIT = "jit";
    private String _basePath;
    private List<String> _loadPaths;
    private ScriptingContainer _scriptingContainer = new ScriptingContainer(LocalContextScope.THREADSAFE);

    public RubyExecutor() {
        LocalContextProvider localContextProvider = this._scriptingContainer.getProvider();
        RubyInstanceConfig rubyInstanceConfig = localContextProvider.getRubyInstanceConfig();
        rubyInstanceConfig.setLoader(PortalClassLoaderUtil.getClassLoader());
        if (PropsValues.SCRIPTING_JRUBY_COMPILE_MODE.equals(_COMPILE_MODE_FORCE)) {
            rubyInstanceConfig.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
        } else if (PropsValues.SCRIPTING_JRUBY_COMPILE_MODE.equals(_COMPILE_MODE_JIT)) {
            rubyInstanceConfig.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
        }
        rubyInstanceConfig.setJitThreshold(PropsValues.SCRIPTING_JRUBY_COMPILE_THRESHOLD);
        this._basePath = PortalUtil.getPortalLibDir();
        this._loadPaths = new ArrayList<String>(PropsValues.SCRIPTING_JRUBY_LOAD_PATHS.length);
        String[] stringArray = PropsValues.SCRIPTING_JRUBY_LOAD_PATHS;
        int n = PropsValues.SCRIPTING_JRUBY_LOAD_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String gemLibPath = stringArray[n2];
            this._loadPaths.add(gemLibPath);
            ++n2;
        }
        rubyInstanceConfig.setLoadPaths(this._loadPaths);
        this._scriptingContainer.setCurrentDirectory(this._basePath);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile) throws ScriptingException {
        return this.eval(allowedClasses, inputObjects, outputNames, scriptFile, null);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script) throws ScriptingException {
        return this.eval(allowedClasses, inputObjects, outputNames, null, script);
    }

    public String getLanguage() {
        return LANGUAGE;
    }

    protected Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile, String script) throws ScriptingException {
        block10: {
            if (allowedClasses != null) {
                throw new ExecutionException("Constrained execution not supported for Ruby");
            }
            LocalContextProvider localContextProvider = this._scriptingContainer.getProvider();
            RubyInstanceConfig rubyInstanceConfig = localContextProvider.getRubyInstanceConfig();
            rubyInstanceConfig.setCurrentDirectory(this._basePath);
            rubyInstanceConfig.setLoadPaths(this._loadPaths);
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                String inputName = entry.getKey();
                Object inputObject = entry.getValue();
                if (!inputName.startsWith("$")) {
                    inputName = "$" + inputName;
                }
                this._scriptingContainer.put(inputName, inputObject);
            }
            if (scriptFile != null) {
                this._scriptingContainer.runScriptlet((InputStream)new FileInputStream(scriptFile), scriptFile.toString());
            } else {
                this._scriptingContainer.runScriptlet(script);
            }
            if (outputNames != null) break block10;
            return null;
        }
        try {
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, this._scriptingContainer.get(outputName));
            }
            return outputObjects;
        }
        catch (RaiseException re) {
            throw new ScriptingException(String.valueOf(re.getException().message.asJavaString()) + "\n\n", (Throwable)re);
        }
        catch (FileNotFoundException fnfe) {
            throw new ScriptingException((Throwable)fnfe);
        }
    }
}

