/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.javascript;

import com.liferay.mozilla.javascript.ClassShutter;
import com.liferay.mozilla.javascript.Context;
import com.liferay.mozilla.javascript.Script;
import com.liferay.mozilla.javascript.Scriptable;
import com.liferay.mozilla.javascript.ScriptableObject;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.scripting.javascript.JavaScriptClassVisibilityChecker;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptExecutor
extends BaseScriptingExecutor {
    private static final String _CACHE_NAME = JavaScriptExecutor.class.getName();
    private static final String _LANGUAGE = "javascript";

    public void clearCache() {
        SingleVMPoolUtil.clear((String)_CACHE_NAME);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script) throws ScriptingException {
        Script compiledScript = this.getCompiledScript(script);
        try {
            Context context = Context.enter();
            ScriptableObject scriptable = context.initStandardObjects();
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                ScriptableObject.putProperty((Scriptable)scriptable, (String)key, (Object)Context.javaToJS((Object)value, (Scriptable)scriptable));
            }
            if (allowedClasses != null) {
                context.setClassShutter((ClassShutter)new JavaScriptClassVisibilityChecker(allowedClasses));
            }
            compiledScript.exec(context, (Scriptable)scriptable);
            if (outputNames == null) {
                return null;
            }
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, ScriptableObject.getProperty((Scriptable)scriptable, (String)outputName));
            }
            HashMap<String, Object> hashMap = outputObjects;
            return hashMap;
        }
        catch (Exception e) {
            throw new ScriptingException(String.valueOf(e.getMessage()) + "\n\n", (Throwable)e);
        }
        finally {
            Context.exit();
        }
    }

    public String getLanguage() {
        return _LANGUAGE;
    }

    protected Script getCompiledScript(String script) {
        String key = String.valueOf(script.hashCode());
        Script compiledScript = (Script)SingleVMPoolUtil.get((String)_CACHE_NAME, (String)key);
        if (compiledScript == null) {
            try {
                Context context = Context.enter();
                compiledScript = context.compileString(script, "script", 0, null);
            }
            finally {
                Context.exit();
            }
            SingleVMPoolUtil.put((String)_CACHE_NAME, (String)key, (Object)compiledScript);
        }
        return compiledScript;
    }
}

