/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scripting.Scripting;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import com.liferay.portal.kernel.scripting.UnsupportedLanguageException;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.time.StopWatch;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyObject;
import org.python.core.PySyntaxError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingImpl
implements Scripting {
    private static Log _log = LogFactoryUtil.getLog(ScriptingImpl.class);
    private Map<String, ScriptingExecutor> _scriptingExecutors = new ConcurrentHashMap<String, ScriptingExecutor>();

    public void addScriptionExecutor(String language, ScriptingExecutor scriptingExecutor) {
        this._scriptingExecutors.put(language, scriptingExecutor);
    }

    public void clearCache(String language) throws ScriptingException {
        ScriptingExecutor scriptingExecutor = this._scriptingExecutors.get(language);
        if (scriptingExecutor == null) {
            throw new UnsupportedLanguageException(language);
        }
        scriptingExecutor.clearCache();
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String language, String script) throws ScriptingException {
        ScriptingExecutor scriptingExecutor = this._scriptingExecutors.get(language);
        if (scriptingExecutor == null) {
            throw new UnsupportedLanguageException(language);
        }
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        try {
            Map map = scriptingExecutor.eval(allowedClasses, inputObjects, outputNames, script);
            return map;
        }
        catch (Exception e) {
            throw new ScriptingException(this.getErrorMessage(script, e), (Throwable)e);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Evaluated script in " + stopWatch.getTime() + " ms"));
            }
        }
    }

    public void exec(Set<String> allowedClasses, Map<String, Object> inputObjects, String language, String script) throws ScriptingException {
        this.eval(allowedClasses, inputObjects, null, language, script);
    }

    public Map<String, Object> getPortletObjects(PortletConfig portletConfig, PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("portletConfig", portletConfig);
        objects.put("portletContext", portletContext);
        objects.put("preferences", portletRequest.getPreferences());
        if (portletRequest instanceof ActionRequest) {
            objects.put("actionRequest", portletRequest);
        } else if (portletRequest instanceof RenderRequest) {
            objects.put("renderRequest", portletRequest);
        } else if (portletRequest instanceof ResourceRequest) {
            objects.put("resourceRequest", portletRequest);
        } else {
            objects.put("portletRequest", portletRequest);
        }
        if (portletResponse instanceof ActionResponse) {
            objects.put("actionResponse", portletResponse);
        } else if (portletResponse instanceof RenderResponse) {
            objects.put("renderResponse", portletResponse);
        } else if (portletResponse instanceof ResourceResponse) {
            objects.put("resourceResponse", portletResponse);
        } else {
            objects.put("portletResponse", portletResponse);
        }
        objects.put("userInfo", portletRequest.getAttribute("javax.portlet.userinfo"));
        return objects;
    }

    public Set<String> getSupportedLanguages() {
        return this._scriptingExecutors.keySet();
    }

    public void setScriptingExecutors(Map<String, ScriptingExecutor> scriptingExecutors) {
        for (Map.Entry<String, ScriptingExecutor> entry : scriptingExecutors.entrySet()) {
            this._scriptingExecutors.put(entry.getKey(), entry.getValue());
        }
    }

    protected String getErrorMessage(Exception e) {
        String message = e.getMessage();
        if (e instanceof PySyntaxError) {
            PySyntaxError pySyntaxError = (PySyntaxError)e;
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            Py.displayException((PyObject)pySyntaxError.type, (PyObject)pySyntaxError.value, (PyObject)pySyntaxError.traceback, (PyObject)new PyFile((OutputStream)unsyncByteArrayOutputStream));
            message = unsyncByteArrayOutputStream.toString();
        }
        return message;
    }

    protected String getErrorMessage(String script, Exception e) {
        StringBundler sb = new StringBundler();
        sb.append(this.getErrorMessage(e));
        sb.append("\n");
        try {
            String line;
            LineNumberReader lineNumberReader = new LineNumberReader((Reader)new UnsyncStringReader(script));
            while ((line = lineNumberReader.readLine()) != null) {
                sb.append("Line ");
                sb.append(lineNumberReader.getLineNumber());
                sb.append(": ");
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException iOException) {
            sb.setIndex(0);
            sb.append(this.getErrorMessage(e));
            sb.append("\n");
            sb.append(script);
        }
        return sb.toString();
    }
}

