/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.quartz;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scheduler.CronTrigger;
import com.liferay.portal.kernel.scheduler.IntervalTrigger;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.JobStateSerializeUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.scheduler.job.MessageSenderJob;
import com.liferay.portal.service.QuartzLocalService;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.UpdateLockRowSemaphore;
import org.quartz.impl.matchers.GroupMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzSchedulerEngine
implements SchedulerEngine {
    @BeanReference(name="com.liferay.portal.service.QuartzLocalService")
    protected QuartzLocalService quartzLocalService;
    private static Log _log = LogFactoryUtil.getLog(QuartzSchedulerEngine.class);
    private Scheduler _memoryScheduler;
    private Scheduler _persistedScheduler;

    public void afterPropertiesSet() {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            this.quartzLocalService.checkQuartzTables();
            this._persistedScheduler = this.initializeScheduler("persisted.scheduler.", true);
            this._memoryScheduler = this.initializeScheduler("memory.scheduler.", false);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to initialize engine", (Throwable)e);
        }
    }

    public void delete(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            for (JobKey jobKey : jobKeys) {
                scheduler.deleteJob(jobKey);
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to delete jobs in group " + groupName, (Throwable)e);
        }
    }

    public void delete(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            jobName = this.fixMaxLength(jobName, JOB_NAME_MAX_LENGTH);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            JobKey jobKey = new JobKey(jobName, groupName);
            scheduler.deleteJob(jobKey);
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to delete job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
    }

    public void destroy() {
        block2: {
            try {
                this.shutdown();
            }
            catch (SchedulerException se) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to shutdown", (Throwable)se);
            }
        }
    }

    public SchedulerResponse getScheduledJob(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return null;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            jobName = this.fixMaxLength(jobName, JOB_NAME_MAX_LENGTH);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            JobKey jobKey = new JobKey(jobName, groupName);
            return this.getScheduledJob(scheduler, jobKey);
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
    }

    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return Collections.emptyList();
        }
        try {
            List groupNames = this._persistedScheduler.getJobGroupNames();
            ArrayList<SchedulerResponse> schedulerResponses = new ArrayList<SchedulerResponse>();
            for (String groupName : groupNames) {
                schedulerResponses.addAll(this.getScheduledJobs(this._persistedScheduler, groupName));
            }
            groupNames = this._memoryScheduler.getJobGroupNames();
            for (String groupName : groupNames) {
                schedulerResponses.addAll(this.getScheduledJobs(this._memoryScheduler, groupName));
            }
            return schedulerResponses;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get jobs", (Throwable)e);
        }
    }

    public List<SchedulerResponse> getScheduledJobs(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return Collections.emptyList();
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            return this.getScheduledJobs(scheduler, groupName);
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get jobs in group " + groupName, (Throwable)e);
        }
    }

    public void pause(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            for (JobKey jobKey : jobKeys) {
                this.updateJobState(scheduler, jobKey, TriggerState.PAUSED, false);
            }
            scheduler.pauseJobs(GroupMatcher.jobGroupEquals((String)groupName));
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to pause jobs in group " + groupName, (Throwable)e);
        }
    }

    public void pause(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            jobName = this.fixMaxLength(jobName, JOB_NAME_MAX_LENGTH);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            JobKey jobKey = new JobKey(jobName, groupName);
            this.updateJobState(scheduler, jobKey, TriggerState.PAUSED, false);
            scheduler.pauseJob(jobKey);
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to pause job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
    }

    public void resume(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            for (JobKey jobKey : jobKeys) {
                this.updateJobState(scheduler, jobKey, TriggerState.NORMAL, false);
            }
            scheduler.resumeJobs(GroupMatcher.jobGroupEquals((String)groupName));
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to resume jobs in group " + groupName, (Throwable)e);
        }
    }

    public void resume(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            jobName = this.fixMaxLength(jobName, JOB_NAME_MAX_LENGTH);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            JobKey jobKey = new JobKey(jobName, groupName);
            this.updateJobState(scheduler, jobKey, TriggerState.NORMAL, false);
            scheduler.resumeJob(jobKey);
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to resume job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
    }

    public void schedule(Trigger trigger, String description, String destination, Message message) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(trigger.getGroupName());
            StorageType storageType = this.getStorageType(trigger.getGroupName());
            trigger = TriggerFactoryUtil.buildTrigger((TriggerType)trigger.getTriggerType(), (String)trigger.getJobName(), (String)this.getOriginalGroupName(trigger.getGroupName()), (Date)trigger.getStartDate(), (Date)trigger.getEndDate(), (Object)trigger.getTriggerContent());
            org.quartz.Trigger quartzTrigger = this.getQuartzTrigger(trigger);
            if (quartzTrigger == null) {
                return;
            }
            description = this.fixMaxLength(description, DESCRIPTION_MAX_LENGTH);
            message = message == null ? new Message() : message.clone();
            TriggerKey triggerKey = quartzTrigger.getKey();
            message.put("RECEIVER_KEY", (Object)this.getFullName(triggerKey.getName(), triggerKey.getGroup()));
            this.schedule(scheduler, storageType, quartzTrigger, description, destination, message);
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to schedule job", (Throwable)e);
        }
    }

    public void shutdown() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (!this._persistedScheduler.isShutdown()) {
                this._persistedScheduler.shutdown(false);
            }
            if (!this._memoryScheduler.isShutdown()) {
                this._memoryScheduler.shutdown(false);
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to shutdown scheduler", (Throwable)e);
        }
    }

    public void start() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            this._persistedScheduler.start();
            this.initJobState();
            this._memoryScheduler.start();
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to start scheduler", (Throwable)e);
        }
    }

    public void suppressError(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            jobName = this.fixMaxLength(jobName, JOB_NAME_MAX_LENGTH);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            JobKey jobKey = new JobKey(jobName, groupName);
            this.updateJobState(scheduler, jobKey, null, true);
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to suppress error for job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
    }

    public void unschedule(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            for (JobKey jobKey : jobKeys) {
                this.unschedule(scheduler, jobKey);
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to unschedule jobs in group " + groupName, (Throwable)e);
        }
    }

    public void unschedule(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(groupName);
            jobName = this.fixMaxLength(jobName, JOB_NAME_MAX_LENGTH);
            groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
            JobKey jobKey = new JobKey(jobName, groupName);
            this.unschedule(scheduler, jobKey);
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to unschedule job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
    }

    public void update(Trigger trigger) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            Scheduler scheduler = this.getScheduler(trigger.getGroupName());
            trigger = TriggerFactoryUtil.buildTrigger((TriggerType)trigger.getTriggerType(), (String)trigger.getJobName(), (String)this.getOriginalGroupName(trigger.getGroupName()), (Date)trigger.getStartDate(), (Date)trigger.getEndDate(), (Object)trigger.getTriggerContent());
            this.update(scheduler, trigger);
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to update trigger", (Throwable)e);
        }
    }

    protected String fixMaxLength(String argument, int maxLength) {
        if (argument == null) {
            return null;
        }
        if (argument.length() > maxLength) {
            argument = argument.substring(0, maxLength);
        }
        return argument;
    }

    protected String getFullName(String jobName, String groupName) {
        return groupName.concat(".").concat(jobName);
    }

    protected JobState getJobState(JobDataMap jobDataMap) {
        Map jobStateMap = (Map)jobDataMap.get((Object)"JOB_STATE");
        return JobStateSerializeUtil.deserialize((Map)jobStateMap);
    }

    protected Message getMessage(JobDataMap jobDataMap) {
        String messageJSON = (String)jobDataMap.get((Object)"MESSAGE");
        return (Message)JSONFactoryUtil.deserialize((String)messageJSON);
    }

    protected String getOriginalGroupName(String groupName) {
        int pos = groupName.indexOf(35);
        return groupName.substring(pos + 1);
    }

    protected org.quartz.Trigger getQuartzTrigger(Trigger trigger) throws SchedulerException {
        if (trigger == null) {
            return null;
        }
        Date endDate = trigger.getEndDate();
        String jobName = this.fixMaxLength(trigger.getJobName(), JOB_NAME_MAX_LENGTH);
        String groupName = this.fixMaxLength(trigger.getGroupName(), GROUP_NAME_MAX_LENGTH);
        Date startDate = trigger.getStartDate();
        if (startDate == null) {
            startDate = ServerDetector.isTomcat() ? new Date(System.currentTimeMillis() + 60000L) : new Date(System.currentTimeMillis() + 180000L);
        }
        org.quartz.Trigger quartzTrigger = null;
        TriggerType triggerType = trigger.getTriggerType();
        if (triggerType.equals((Object)TriggerType.CRON)) {
            try {
                TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
                triggerBuilder.endAt(endDate);
                triggerBuilder.forJob(jobName, groupName);
                triggerBuilder.startAt(startDate);
                triggerBuilder.withIdentity(jobName, groupName);
                CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)((String)trigger.getTriggerContent()));
                triggerBuilder.withSchedule((ScheduleBuilder)cronScheduleBuilder);
                quartzTrigger = triggerBuilder.build();
            }
            catch (ParseException parseException) {
                throw new SchedulerException("Unable to parse cron text " + trigger.getTriggerContent());
            }
        } else if (triggerType.equals((Object)TriggerType.SIMPLE)) {
            long interval = (Long)trigger.getTriggerContent();
            if (interval <= 0L) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Not scheduling " + trigger.getJobName() + " because interval is less than or equal to 0"));
                }
                return null;
            }
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.endAt(endDate);
            triggerBuilder.forJob(jobName, groupName);
            triggerBuilder.startAt(startDate);
            triggerBuilder.withIdentity(jobName, groupName);
            SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule();
            simpleScheduleBuilder.withIntervalInMilliseconds(interval);
            simpleScheduleBuilder.withRepeatCount(-1);
            triggerBuilder.withSchedule((ScheduleBuilder)simpleScheduleBuilder);
            quartzTrigger = triggerBuilder.build();
        } else {
            throw new SchedulerException("Unknown trigger type " + trigger.getTriggerType());
        }
        return quartzTrigger;
    }

    protected SchedulerResponse getScheduledJob(Scheduler scheduler, JobKey jobKey) throws Exception {
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return null;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        String description = jobDataMap.getString("DESCRIPTION");
        String destinationName = jobDataMap.getString("DESTINATION_NAME");
        Message message = this.getMessage(jobDataMap);
        StorageType storageType = StorageType.valueOf((String)jobDataMap.getString("STORAGE_TYPE"));
        SchedulerResponse schedulerResponse = null;
        String jobName = jobKey.getName();
        String groupName = jobKey.getGroup();
        TriggerKey triggerKey = new TriggerKey(jobName, groupName);
        org.quartz.Trigger trigger = scheduler.getTrigger(triggerKey);
        JobState jobState = this.getJobState(jobDataMap);
        message.put("JOB_STATE", (Object)jobState);
        if (trigger == null) {
            schedulerResponse = new SchedulerResponse();
            schedulerResponse.setDescription(description);
            schedulerResponse.setDestinationName(destinationName);
            schedulerResponse.setGroupName(groupName);
            schedulerResponse.setJobName(jobName);
            schedulerResponse.setMessage(message);
            schedulerResponse.setStorageType(storageType);
        } else {
            message.put("END_TIME", (Object)trigger.getEndTime());
            message.put("FINAL_FIRE_TIME", (Object)trigger.getFinalFireTime());
            message.put("NEXT_FIRE_TIME", (Object)trigger.getNextFireTime());
            message.put("PREVIOUS_FIRE_TIME", (Object)trigger.getPreviousFireTime());
            message.put("START_TIME", (Object)trigger.getStartTime());
            if (org.quartz.CronTrigger.class.isAssignableFrom(trigger.getClass())) {
                org.quartz.CronTrigger cronTrigger = (org.quartz.CronTrigger)org.quartz.CronTrigger.class.cast(trigger);
                schedulerResponse = new SchedulerResponse();
                schedulerResponse.setDescription(description);
                schedulerResponse.setDestinationName(destinationName);
                schedulerResponse.setMessage(message);
                schedulerResponse.setStorageType(storageType);
                schedulerResponse.setTrigger((Trigger)new CronTrigger(jobName, groupName, cronTrigger.getStartTime(), cronTrigger.getEndTime(), cronTrigger.getCronExpression()));
            } else if (SimpleTrigger.class.isAssignableFrom(trigger.getClass())) {
                SimpleTrigger simpleTrigger = (SimpleTrigger)SimpleTrigger.class.cast(trigger);
                schedulerResponse = new SchedulerResponse();
                schedulerResponse.setDescription(description);
                schedulerResponse.setDestinationName(destinationName);
                schedulerResponse.setMessage(message);
                schedulerResponse.setStorageType(storageType);
                schedulerResponse.setTrigger((Trigger)new IntervalTrigger(jobName, groupName, simpleTrigger.getStartTime(), simpleTrigger.getEndTime(), simpleTrigger.getRepeatInterval()));
            }
        }
        return schedulerResponse;
    }

    protected List<SchedulerResponse> getScheduledJobs(Scheduler scheduler, String groupName) throws Exception {
        groupName = this.fixMaxLength(this.getOriginalGroupName(groupName), GROUP_NAME_MAX_LENGTH);
        ArrayList<SchedulerResponse> schedulerResponses = new ArrayList<SchedulerResponse>();
        Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
        for (JobKey jobKey : jobKeys) {
            SchedulerResponse schedulerResponse = this.getScheduledJob(scheduler, jobKey);
            if (schedulerResponse == null) continue;
            schedulerResponses.add(schedulerResponse);
        }
        return schedulerResponses;
    }

    protected Scheduler getScheduler(String groupName) throws Exception {
        if (groupName.startsWith(StorageType.PERSISTED.toString())) {
            return this._persistedScheduler;
        }
        return this._memoryScheduler;
    }

    protected StorageType getStorageType(String groupName) {
        int pos = groupName.indexOf(35);
        String storageTypeString = groupName.substring(0, pos);
        return StorageType.valueOf((String)storageTypeString);
    }

    protected Scheduler initializeScheduler(String propertiesPrefix, boolean useQuartzCluster) throws Exception {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        Properties properties = PropsUtil.getProperties(propertiesPrefix, true);
        if (useQuartzCluster) {
            DB db = DBFactoryUtil.getDB();
            String dbType = db.getType();
            if (dbType.equals("sqlserver")) {
                properties.setProperty("org.quartz.jobStore.lockHandler.class", UpdateLockRowSemaphore.class.getName());
            }
            if (PropsValues.CLUSTER_LINK_ENABLED) {
                if (dbType.equals("hypersonic")) {
                    _log.error((Object)"Unable to cluster scheduler on Hypersonic");
                } else {
                    properties.put("org.quartz.jobStore.isClustered", Boolean.TRUE.toString());
                }
            }
        }
        schedulerFactory.initialize(properties);
        return schedulerFactory.getScheduler();
    }

    protected void initJobState() throws Exception {
        List groupNames = this._persistedScheduler.getJobGroupNames();
        for (String groupName : groupNames) {
            Set jobkeys = this._persistedScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            for (JobKey jobKey : jobkeys) {
                org.quartz.Trigger trigger = this._persistedScheduler.getTrigger(new TriggerKey(jobKey.getName(), jobKey.getGroup()));
                if (trigger != null) continue;
                JobDetail jobDetail = this._persistedScheduler.getJobDetail(jobKey);
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                JobState jobState = this.getJobState(jobDataMap);
                jobState.setTriggerState(TriggerState.COMPLETE);
                jobDataMap.put("JOB_STATE", (Object)JobStateSerializeUtil.serialize((JobState)jobState));
                this._persistedScheduler.addJob(jobDetail, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(Scheduler scheduler, StorageType storageType, org.quartz.Trigger trigger, String description, String destinationName, Message message) throws Exception {
        block5: {
            try {
                JobDetail jobDetail = null;
                JobBuilder jobBuilder = JobBuilder.newJob(MessageSenderJob.class);
                jobBuilder.storeDurably(scheduler == this._persistedScheduler);
                jobBuilder.withIdentity(trigger.getJobKey());
                jobDetail = jobBuilder.build();
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                jobDataMap.put("DESCRIPTION", description);
                jobDataMap.put("DESTINATION_NAME", destinationName);
                jobDataMap.put("MESSAGE", JSONFactoryUtil.serialize((Object)message));
                jobDataMap.put("STORAGE_TYPE", storageType.toString());
                JobState jobState = new JobState(TriggerState.NORMAL, message.getInteger("EXCEPTIONS_MAX_SIZE"));
                jobDataMap.put("JOB_STATE", (Object)JobStateSerializeUtil.serialize((JobState)jobState));
                QuartzSchedulerEngine quartzSchedulerEngine = this;
                synchronized (quartzSchedulerEngine) {
                    scheduler.deleteJob(trigger.getJobKey());
                    scheduler.scheduleJob(jobDetail, trigger);
                }
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                if (!_log.isInfoEnabled()) break block5;
                _log.info((Object)"Message is already scheduled");
            }
        }
    }

    protected void unschedule(Scheduler scheduler, JobKey jobKey) throws Exception {
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        TriggerKey triggerKey = new TriggerKey(jobKey.getName(), jobKey.getGroup());
        if (jobDetail == null) {
            return;
        }
        if (scheduler == this._memoryScheduler) {
            scheduler.unscheduleJob(triggerKey);
            return;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        JobState jobState = this.getJobState(jobDataMap);
        org.quartz.Trigger trigger = scheduler.getTrigger(triggerKey);
        jobState.setTriggerDate("END_TIME", new Date());
        jobState.setTriggerDate("FINAL_FIRE_TIME", trigger.getPreviousFireTime());
        jobState.setTriggerDate("NEXT_FIRE_TIME", null);
        jobState.setTriggerDate("PREVIOUS_FIRE_TIME", trigger.getPreviousFireTime());
        jobState.setTriggerDate("START_TIME", trigger.getStartTime());
        jobState.setTriggerState(TriggerState.UNSCHEDULED);
        jobState.clearExceptions();
        jobDataMap.put("JOB_STATE", (Object)JobStateSerializeUtil.serialize((JobState)jobState));
        scheduler.unscheduleJob(triggerKey);
        scheduler.addJob(jobDetail, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Scheduler scheduler, Trigger trigger) throws Exception {
        org.quartz.Trigger quartzTrigger = this.getQuartzTrigger(trigger);
        if (quartzTrigger == null) {
            return;
        }
        TriggerKey triggerKey = quartzTrigger.getKey();
        if (scheduler.getTrigger(triggerKey) != null) {
            scheduler.rescheduleJob(triggerKey, quartzTrigger);
        } else {
            JobKey jobKey = quartzTrigger.getJobKey();
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            if (jobDetail == null) {
                return;
            }
            this.updateJobState(scheduler, jobKey, TriggerState.NORMAL, true);
            QuartzSchedulerEngine quartzSchedulerEngine = this;
            synchronized (quartzSchedulerEngine) {
                scheduler.deleteJob(jobKey);
                scheduler.scheduleJob(jobDetail, quartzTrigger);
            }
        }
    }

    protected void updateJobState(Scheduler scheduler, JobKey jobKey, TriggerState triggerState, boolean suppressError) throws Exception {
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        JobState jobState = this.getJobState(jobDataMap);
        if (triggerState != null) {
            jobState.setTriggerState(triggerState);
        }
        if (suppressError) {
            jobState.clearExceptions();
        }
        jobDataMap.put("JOB_STATE", (Object)JobStateSerializeUtil.serialize((JobState)jobState));
        scheduler.addJob(jobDetail, true);
    }
}

