/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.job;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.concurrent.LockRegistry;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.JobStateSerializeUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.spring.context.PortletContextLoaderListener;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class MessageSenderJob
implements Job {
    private static Log _log = LogFactoryUtil.getLog(MessageSenderJob.class);
    private static MethodKey _deleteJobMethodKey = new MethodKey(SchedulerEngineUtil.class.getName(), "delete", new Class[]{String.class, String.class, StorageType.class});

    public void execute(JobExecutionContext jobExecutionContext) {
        try {
            this.doExecute(jobExecutionContext);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to execute job", (Throwable)e);
        }
    }

    protected void doExecute(JobExecutionContext jobExecutionContext) throws Exception {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        String destinationName = jobDataMap.getString("DESTINATION_NAME");
        String messageJSON = (String)jobDataMap.get((Object)"MESSAGE");
        Message message = null;
        message = messageJSON == null ? new Message() : (Message)JSONFactoryUtil.deserialize((String)messageJSON);
        String contextPath = message.getString("CONTEXT_PATH");
        String lockKey = PortletContextLoaderListener.getLockKey(contextPath);
        ReentrantLock executionLock = null;
        if (lockKey != null && (executionLock = LockRegistry.getLock((String)lockKey, (String)lockKey)) != null) {
            if (executionLock.hasQueuedThreads()) {
                return;
            }
            executionLock.lock();
        }
        try {
            message.put("DESTINATION_NAME", (Object)destinationName);
            Scheduler scheduler = jobExecutionContext.getScheduler();
            Map jobStateMap = (Map)jobDataMap.get((Object)"JOB_STATE");
            JobState jobState = JobStateSerializeUtil.deserialize((Map)jobStateMap);
            if (jobExecutionContext.getNextFireTime() == null) {
                Trigger trigger = jobExecutionContext.getTrigger();
                StorageType storageType = StorageType.valueOf((String)jobDataMap.getString("STORAGE_TYPE"));
                if (storageType.equals((Object)StorageType.PERSISTED)) {
                    JobState jobStateClone = this.updatePersistedJobState(jobState, trigger);
                    jobDataMap.put("JOB_STATE", (Object)JobStateSerializeUtil.serialize((JobState)jobStateClone));
                    scheduler.addJob(jobDetail, true);
                } else {
                    message.put("DISABLE", (Object)true);
                    if (PropsValues.CLUSTER_LINK_ENABLED && storageType.equals((Object)StorageType.MEMORY_CLUSTERED)) {
                        this.notifyClusterMember(trigger.getKey(), storageType);
                    }
                }
            }
            message.put("JOB_STATE", (Object)jobState);
            MessageBusUtil.sendMessage((String)destinationName, (Message)message);
        }
        finally {
            if (executionLock != null) {
                executionLock.unlock();
            }
        }
    }

    protected void notifyClusterMember(TriggerKey triggerKey, StorageType storageType) throws Exception {
        MethodHandler methodHandler = new MethodHandler(_deleteJobMethodKey, new Object[]{triggerKey.getName(), triggerKey.getGroup(), storageType});
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)methodHandler, (boolean)true);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
    }

    protected JobState updatePersistedJobState(JobState jobState, Trigger trigger) {
        jobState.setTriggerDate("END_TIME", trigger.getEndTime());
        jobState.setTriggerDate("FINAL_FIRE_TIME", trigger.getFinalFireTime());
        jobState.setTriggerDate("NEXT_FIRE_TIME", null);
        jobState.setTriggerDate("PREVIOUS_FIRE_TIME", trigger.getPreviousFireTime());
        jobState.setTriggerDate("START_TIME", trigger.getStartTime());
        jobState.setTriggerState(TriggerState.COMPLETE);
        JobState jobStateClone = (JobState)jobState.clone();
        jobStateClone.clearExceptions();
        return jobStateClone;
    }
}

