/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterEventType;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineClusterManager;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterSchedulerEngine
implements IdentifiableBean,
SchedulerEngine,
SchedulerEngineClusterManager {
    @BeanReference(name="com.liferay.portal.scheduler.ClusterSchedulerEngineService")
    protected SchedulerEngine schedulerEngine;
    private static final String _LOCK_CLASS_NAME = SchedulerEngine.class.getName();
    private static Log _log = LogFactoryUtil.getLog(ClusterSchedulerEngine.class);
    private static MethodKey _getScheduledJobMethodKey = new MethodKey(SchedulerEngine.class.getName(), "getScheduledJob", new Class[]{String.class, String.class});
    private static MethodKey _getScheduledJobsMethodKey1 = new MethodKey(SchedulerEngine.class.getName(), "getScheduledJobs", new Class[0]);
    private static MethodKey _getScheduledJobsMethodKey2 = new MethodKey(SchedulerEngine.class.getName(), "getScheduledJobs", new Class[]{String.class});
    private static MethodKey _getScheduledJobsMethodKey3 = new MethodKey(SchedulerEngineUtil.class.getName(), "getScheduledJobs", new Class[]{StorageType.class});
    private String _beanIdentifier;
    private ClusterEventListener _clusterEventListener;
    private volatile String _localClusterNodeAddress;
    private volatile boolean _master;
    private Map<String, ObjectValuePair<SchedulerResponse, TriggerState>> _memoryClusteredJobs = new ConcurrentHashMap<String, ObjectValuePair<SchedulerResponse, TriggerState>>();
    private java.util.concurrent.locks.Lock _readLock;
    private SchedulerEngine _schedulerEngine;
    private java.util.concurrent.locks.Lock _writeLock;

    public static SchedulerEngine createClusterSchedulerEngine(SchedulerEngine schedulerEngine) {
        if (PropsValues.CLUSTER_LINK_ENABLED) {
            schedulerEngine = new ClusterSchedulerEngine(schedulerEngine);
        }
        return schedulerEngine;
    }

    public ClusterSchedulerEngine(SchedulerEngine schedulerEngine) {
        this._schedulerEngine = schedulerEngine;
    }

    @Clusterable
    public void delete(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                this.removeMemoryClusteredJobs(groupName);
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to delete jobs in group " + groupName, (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.delete(groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void delete(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                this._memoryClusteredJobs.remove(this.getFullName(jobName, groupName));
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to delete job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.delete(jobName, groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    public String getBeanIdentifier() {
        return this._beanIdentifier;
    }

    public SchedulerResponse getScheduledJob(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return null;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                return (SchedulerResponse)this.callMaster(_getScheduledJobMethodKey, jobName, groupName);
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
        this._readLock.lock();
        try {
            SchedulerResponse schedulerResponse = this._schedulerEngine.getScheduledJob(jobName, groupName);
            return schedulerResponse;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return Collections.emptyList();
        }
        try {
            if (this.isMemorySchedulerSlave()) {
                return (List)this.callMaster(_getScheduledJobsMethodKey1, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get jobs", (Throwable)e);
        }
        this._readLock.lock();
        try {
            List list = this._schedulerEngine.getScheduledJobs();
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public List<SchedulerResponse> getScheduledJobs(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return Collections.emptyList();
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                return (List)this.callMaster(_getScheduledJobsMethodKey2, groupName);
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get jobs in group " + groupName, (Throwable)e);
        }
        this._readLock.lock();
        try {
            List list = this._schedulerEngine.getScheduledJobs(groupName);
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void initialize() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
            this._readLock = readWriteLock.readLock();
            this._writeLock = readWriteLock.writeLock();
            this._localClusterNodeAddress = this.getSerializedString(ClusterExecutorUtil.getLocalClusterNodeAddress());
            this._clusterEventListener = new MemorySchedulerClusterEventListener();
            ClusterExecutorUtil.addClusterEventListener((ClusterEventListener)this._clusterEventListener);
            if (!this.isMemorySchedulerClusterLockOwner(this.lockMemorySchedulerCluster(null))) {
                this.initMemoryClusteredJobs();
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to initialize scheduler", (Throwable)e);
        }
    }

    @Clusterable
    public void pause(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                this.updateMemoryClusteredJobs(groupName, TriggerState.PAUSED);
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to pause jobs in group " + groupName, (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.pause(groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void pause(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                this.updateMemoryClusteredJob(jobName, groupName, TriggerState.PAUSED);
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to pause job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.pause(jobName, groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void resume(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                this.updateMemoryClusteredJobs(groupName, TriggerState.NORMAL);
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to resume jobs in group " + groupName, (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.resume(groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void resume(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                this.updateMemoryClusteredJob(jobName, groupName, TriggerState.NORMAL);
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to resume job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.resume(jobName, groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void schedule(Trigger trigger, String description, String destinationName, Message message) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        String groupName = trigger.getGroupName();
        String jobName = trigger.getJobName();
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                SchedulerResponse schedulerResponse = new SchedulerResponse();
                schedulerResponse.setDescription(description);
                schedulerResponse.setDestinationName(destinationName);
                schedulerResponse.setGroupName(groupName);
                schedulerResponse.setJobName(jobName);
                schedulerResponse.setMessage(message);
                schedulerResponse.setTrigger(trigger);
                this._memoryClusteredJobs.put(this.getFullName(jobName, groupName), (ObjectValuePair<SchedulerResponse, TriggerState>)new ObjectValuePair((Object)schedulerResponse, (Object)TriggerState.NORMAL));
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to schedule job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.schedule(trigger, description, destinationName, message);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    public void setBeanIdentifier(String beanIdentifier) {
        this._beanIdentifier = beanIdentifier;
    }

    public void shutdown() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            ClusterExecutorUtil.removeClusterEventListener((ClusterEventListener)this._clusterEventListener);
            LockLocalServiceUtil.unlock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress, (boolean)PropsValues.MEMORY_CLUSTER_SCHEDULER_LOCK_CACHE_ENABLED);
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to shutdown scheduler", (Throwable)e);
        }
        this._schedulerEngine.shutdown();
    }

    public void start() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        this._schedulerEngine.start();
    }

    @Clusterable
    public void suppressError(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to suppress error for job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.suppressError(jobName, groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void unschedule(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                this.removeMemoryClusteredJobs(groupName);
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to unschedule jobs in group " + groupName, (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.unschedule(groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void unschedule(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                this._memoryClusteredJobs.remove(this.getFullName(jobName, groupName));
                return;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to unschedule job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.unschedule(jobName, groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void update(Trigger trigger) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        String jobName = trigger.getJobName();
        String groupName = trigger.getGroupName();
        try {
            if (this.isMemorySchedulerSlave(groupName)) {
                for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
                    SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
                    if (!jobName.equals(schedulerResponse.getJobName()) || !groupName.equals(schedulerResponse.getGroupName())) continue;
                    schedulerResponse.setTrigger(trigger);
                    return;
                }
                throw new Exception("Unable to update trigger for memory clustered job");
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to update job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)e);
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.update(trigger);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    public Lock updateMemorySchedulerClusterMaster() throws SchedulerException {
        try {
            Lock lock = this.lockMemorySchedulerCluster(null);
            Address address = (Address)this.getDeserializedObject(lock.getOwner());
            if (ClusterExecutorUtil.isClusterNodeAlive((Address)address)) {
                return lock;
            }
            return this.lockMemorySchedulerCluster(lock.getOwner());
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to update memory scheduler cluster master", (Throwable)e);
        }
    }

    protected Object callMaster(MethodKey methodKey, Object ... arguments) throws Exception {
        MethodHandler methodHandler = new MethodHandler(methodKey, arguments);
        Lock lock = this.updateMemorySchedulerClusterMaster();
        Address address = (Address)this.getDeserializedObject(lock.getOwner());
        if (address.equals(ClusterExecutorUtil.getLocalClusterNodeAddress())) {
            if (methodKey == _getScheduledJobsMethodKey3) {
                return methodHandler.invoke(false);
            }
            return methodHandler.invoke((Object)this.schedulerEngine);
        }
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)methodHandler, (Address[])new Address[]{address});
        clusterRequest.setBeanIdentifier(this._beanIdentifier);
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        try {
            ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20L, TimeUnit.SECONDS);
            ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(address);
            return clusterNodeResponse.getResult();
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to load scheduled jobs from cluster node " + address.getDescription(), (Throwable)e);
        }
    }

    protected Object getDeserializedObject(String string) throws Exception {
        byte[] bytes = Base64.decode((String)string);
        UnsyncByteArrayInputStream byteArrayInputStream = new UnsyncByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)byteArrayInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    protected String getFullName(String jobName, String groupName) {
        return groupName.concat(".").concat(jobName);
    }

    protected String getSerializedString(Object object) throws Exception {
        UnsyncByteArrayOutputStream byteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return Base64.encode((byte[])bytes);
    }

    protected StorageType getStorageType(String groupName) {
        int pos = groupName.indexOf(35);
        String storageTypeString = groupName.substring(0, pos);
        return StorageType.valueOf((String)storageTypeString);
    }

    protected void initMemoryClusteredJobs() throws Exception {
        List schedulerResponses = (List)this.callMaster(_getScheduledJobsMethodKey3, StorageType.MEMORY_CLUSTERED);
        for (SchedulerResponse schedulerResponse : schedulerResponses) {
            Trigger oldTrigger = schedulerResponse.getTrigger();
            String jobName = schedulerResponse.getJobName();
            String groupName = SchedulerEngineUtil.namespaceGroupName((String)schedulerResponse.getGroupName(), (StorageType)StorageType.MEMORY_CLUSTERED);
            Trigger newTrigger = TriggerFactoryUtil.buildTrigger((TriggerType)oldTrigger.getTriggerType(), (String)jobName, (String)groupName, (Date)oldTrigger.getStartDate(), (Date)oldTrigger.getEndDate(), (Object)oldTrigger.getTriggerContent());
            schedulerResponse.setTrigger(newTrigger);
            TriggerState triggerState = SchedulerEngineUtil.getJobState((SchedulerResponse)schedulerResponse);
            Message message = schedulerResponse.getMessage();
            message.remove("JOB_STATE");
            this._memoryClusteredJobs.put(this.getFullName(jobName, groupName), (ObjectValuePair<SchedulerResponse, TriggerState>)new ObjectValuePair((Object)schedulerResponse, (Object)triggerState));
        }
    }

    protected boolean isMemorySchedulerClusterLockOwner(Lock lock) throws Exception {
        boolean master = this._localClusterNodeAddress.equals(lock.getOwner());
        if (master == this._master) {
            return master;
        }
        if (!this._master) {
            this._master = master;
            return this._master;
        }
        this._localClusterNodeAddress = this.getSerializedString(ClusterExecutorUtil.getLocalClusterNodeAddress());
        for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
            SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
            this._schedulerEngine.delete(schedulerResponse.getJobName(), schedulerResponse.getGroupName());
        }
        this.initMemoryClusteredJobs();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Another node is now the memory scheduler master");
        }
        this._master = master;
        return master;
    }

    protected boolean isMemorySchedulerSlave() throws Exception {
        return this.isMemorySchedulerSlave(null);
    }

    protected boolean isMemorySchedulerSlave(String groupName) throws Exception {
        StorageType storageType;
        if (groupName != null && !(storageType = this.getStorageType(groupName)).equals((Object)StorageType.MEMORY_CLUSTERED)) {
            return false;
        }
        Lock lock = this.lockMemorySchedulerCluster(null);
        return !this.isMemorySchedulerClusterLockOwner(lock);
    }

    protected Lock lockMemorySchedulerCluster(String owner) throws Exception {
        Lock lock = null;
        while (true) {
            try {
                if (owner == null) {
                    lock = LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress, (boolean)PropsValues.MEMORY_CLUSTER_SCHEDULER_LOCK_CACHE_ENABLED);
                    break;
                }
                lock = LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)owner, (String)this._localClusterNodeAddress, (boolean)PropsValues.MEMORY_CLUSTER_SCHEDULER_LOCK_CACHE_ENABLED);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)"Unable to obtain memory scheduler cluster lock. Trying again.");
                continue;
            }
            break;
        }
        if (!lock.isNew()) {
            return lock;
        }
        boolean forceSync = ProxyModeThreadLocal.isForceSync();
        ProxyModeThreadLocal.setForceSync(true);
        this._writeLock.lock();
        try {
            for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
                SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
                this._schedulerEngine.schedule(schedulerResponse.getTrigger(), schedulerResponse.getDescription(), schedulerResponse.getDestinationName(), schedulerResponse.getMessage());
                TriggerState triggerState = (TriggerState)memoryClusteredJob.getValue();
                if (!triggerState.equals((Object)TriggerState.PAUSED)) continue;
                this._schedulerEngine.pause(schedulerResponse.getJobName(), schedulerResponse.getGroupName());
            }
        }
        finally {
            ProxyModeThreadLocal.setForceSync(forceSync);
            this._writeLock.unlock();
        }
        return lock;
    }

    protected void removeMemoryClusteredJobs(String groupName) {
        Set<Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>>> memoryClusteredJobs = this._memoryClusteredJobs.entrySet();
        Iterator<Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>>> itr = memoryClusteredJobs.iterator();
        while (itr.hasNext()) {
            Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>> entry = itr.next();
            ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob = entry.getValue();
            SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
            if (!groupName.equals(schedulerResponse.getGroupName())) continue;
            itr.remove();
        }
    }

    protected void skipClusterInvoking(String groupName) throws SchedulerException {
        StorageType storageType = this.getStorageType(groupName);
        if (storageType.equals((Object)StorageType.PERSISTED)) {
            SchedulerException schedulerException = new SchedulerException();
            schedulerException.setSwallowable(true);
            throw schedulerException;
        }
    }

    protected void updateMemoryClusteredJob(String jobName, String groupName, TriggerState triggerState) {
        ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob = this._memoryClusteredJobs.get(this.getFullName(jobName, groupName));
        if (memoryClusteredJob != null) {
            memoryClusteredJob.setValue((Object)triggerState);
        }
    }

    protected void updateMemoryClusteredJobs(String groupName, TriggerState triggerState) {
        for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
            SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
            if (!groupName.equals(schedulerResponse.getGroupName())) continue;
            memoryClusteredJob.setValue((Object)triggerState);
        }
    }

    private class MemorySchedulerClusterEventListener
    implements ClusterEventListener {
        private MemorySchedulerClusterEventListener() {
        }

        public void processClusterEvent(ClusterEvent clusterEvent) {
            ClusterEventType clusterEventType = clusterEvent.getClusterEventType();
            if (!clusterEventType.equals((Object)ClusterEventType.DEPART)) {
                return;
            }
            try {
                ClusterSchedulerEngine.this.updateMemorySchedulerClusterMaster();
            }
            catch (Exception e) {
                _log.error((Object)"Unable to update memory scheduler cluster lock", (Throwable)e);
            }
        }
    }
}

