/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.util;

import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.repository.util.RepositoryFactory;
import com.liferay.portal.repository.util.RepositoryFactoryImpl;
import com.liferay.portal.util.PropsValues;
import java.util.concurrent.ConcurrentHashMap;

public class RepositoryFactoryUtil {
    private static ConcurrentHashMap<String, RepositoryFactory> _repositoryFactories = new ConcurrentHashMap();

    static {
        String[] stringArray = PropsValues.DL_REPOSITORY_IMPL;
        int n = PropsValues.DL_REPOSITORY_IMPL.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            RepositoryFactoryImpl repositoryFactory = new RepositoryFactoryImpl(className);
            _repositoryFactories.put(className, repositoryFactory);
            ++n2;
        }
    }

    public static BaseRepository getInstance(String className) throws Exception {
        RepositoryFactory repositoryFactory = _repositoryFactories.get(className);
        BaseRepository baseRepository = null;
        if (repositoryFactory != null) {
            baseRepository = repositoryFactory.getInstance();
        }
        if (baseRepository != null) {
            return baseRepository;
        }
        throw new RepositoryException("Repository with class name " + className + " is unavailable");
    }

    public static String[] getRepositoryClassNames() {
        return _repositoryFactories.keySet().toArray(new String[0]);
    }

    public static void registerRepositoryFactory(String className, RepositoryFactory repositoryFactory) {
        _repositoryFactories.put(className, repositoryFactory);
    }

    public static void unregisterRepositoryFactory(String className) {
        _repositoryFactories.remove(className);
    }
}

