/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.search.RepositorySearchQueryBuilder;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class RepositorySearchQueryBuilderImpl
implements RepositorySearchQueryBuilder {
    private static Log _log = LogFactoryUtil.getLog(RepositorySearchQueryBuilderImpl.class);
    private Analyzer _analyzer;

    public BooleanQuery getFullQuery(SearchContext searchContext) throws SearchException {
        try {
            BooleanClause[] booleanClauses;
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            this.addContext(contextQuery, searchContext);
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            this.addSearchKeywords(searchQuery, searchContext);
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            if (contextQuery.hasClauses()) {
                fullQuery.add((com.liferay.portal.kernel.search.Query)contextQuery, BooleanClauseOccur.MUST);
            }
            if (searchQuery.hasClauses()) {
                fullQuery.add((com.liferay.portal.kernel.search.Query)searchQuery, BooleanClauseOccur.MUST);
            }
            if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
                BooleanClause[] booleanClauseArray = booleanClauses;
                int n = booleanClauses.length;
                int n2 = 0;
                while (n2 < n) {
                    BooleanClause booleanClause = booleanClauseArray[n2];
                    fullQuery.add(booleanClause.getQuery(), booleanClause.getBooleanClauseOccur());
                    ++n2;
                }
            }
            fullQuery.setQueryConfig(searchContext.getQueryConfig());
            return fullQuery;
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void setAnalyzer(Analyzer analyzer) {
        this._analyzer = analyzer;
    }

    protected void addContext(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] folderIds = searchContext.getFolderIds();
        if (folderIds != null && folderIds.length > 0) {
            if (folderIds[0] == 0L) {
                return;
            }
            BooleanQuery folderIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = folderIds;
            int n = folderIds.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    long folderId = lArray[n2];
                    try {
                        DLAppServiceUtil.getFolder((long)folderId);
                    }
                    catch (Exception exception) {
                        break block5;
                    }
                    folderIdsQuery.addTerm("folderId", folderId);
                }
                ++n2;
            }
            contextQuery.add((com.liferay.portal.kernel.search.Query)folderIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull((String)keywords)) {
            return;
        }
        BooleanQuery titleQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        this.addTerm(titleQuery, searchContext, "title", keywords);
        if (titleQuery.hasClauses() && !this.contains((com.liferay.portal.kernel.search.Query)searchQuery, (com.liferay.portal.kernel.search.Query)titleQuery)) {
            searchQuery.add((com.liferay.portal.kernel.search.Query)titleQuery, BooleanClauseOccur.SHOULD);
        }
        BooleanQuery userNameQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        this.addTerm(userNameQuery, searchContext, "userName", keywords);
        if (userNameQuery.hasClauses() && !this.contains((com.liferay.portal.kernel.search.Query)searchQuery, (com.liferay.portal.kernel.search.Query)userNameQuery)) {
            searchQuery.add((com.liferay.portal.kernel.search.Query)userNameQuery, BooleanClauseOccur.SHOULD);
        }
    }

    protected void addTerm(BooleanQuery booleanQuery, SearchContext searchContext, String field, String value) {
        if (Validator.isNull((String)value)) {
            return;
        }
        try {
            QueryParser queryParser = new QueryParser(LuceneHelperUtil.getVersion(), field, this._analyzer);
            queryParser.setAllowLeadingWildcard(true);
            queryParser.setLowercaseExpandedTerms(false);
            Query query = queryParser.parse(value);
            this.translateQuery(booleanQuery, searchContext, query, BooleanClause.Occur.SHOULD);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected boolean contains(com.liferay.portal.kernel.search.Query query1, com.liferay.portal.kernel.search.Query query2) {
        if (query1 instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query1;
            for (BooleanClause booleanClause : booleanQuery.clauses()) {
                if (!this.contains(booleanClause.getQuery(), query2)) continue;
                return true;
            }
            return false;
        }
        if (query2 instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query2;
            for (BooleanClause booleanClause : booleanQuery.clauses()) {
                if (!this.contains(query1, booleanClause.getQuery())) continue;
                return true;
            }
            return false;
        }
        if (query1 instanceof com.liferay.portal.kernel.search.TermQuery && query2 instanceof com.liferay.portal.kernel.search.TermQuery) {
            com.liferay.portal.kernel.search.TermQuery termQuery1 = (com.liferay.portal.kernel.search.TermQuery)query1;
            QueryTerm queryTerm1 = termQuery1.getQueryTerm();
            String field1 = queryTerm1.getField();
            String value1 = queryTerm1.getValue();
            com.liferay.portal.kernel.search.TermQuery termQuery2 = (com.liferay.portal.kernel.search.TermQuery)query2;
            QueryTerm queryTerm2 = termQuery2.getQueryTerm();
            String field2 = queryTerm2.getField();
            String value2 = queryTerm2.getValue();
            if (field1.equals(field2) && value1.equals(value2)) {
                return true;
            }
        } else if (query1 instanceof TermRangeQuery && query2 instanceof TermRangeQuery) {
            TermRangeQuery termRangeQuery1 = (TermRangeQuery)query1;
            boolean includesLower1 = termRangeQuery1.includesLower();
            boolean includesUpper1 = termRangeQuery1.includesUpper();
            String lowerTerm1 = termRangeQuery1.getLowerTerm();
            String upperTerm1 = termRangeQuery1.getUpperTerm();
            TermRangeQuery termRangeQuery2 = (TermRangeQuery)query2;
            boolean includesLower2 = termRangeQuery2.includesLower();
            boolean includesUpper2 = termRangeQuery2.includesUpper();
            String lowerTerm2 = termRangeQuery2.getLowerTerm();
            String upperTerm2 = termRangeQuery2.getUpperTerm();
            if (includesLower1 == includesLower2 && includesUpper1 == includesUpper2 && lowerTerm1.equals(lowerTerm2) && upperTerm1.equals(upperTerm2)) {
                return true;
            }
        } else if (query1 instanceof com.liferay.portal.kernel.search.WildcardQuery && query2 instanceof com.liferay.portal.kernel.search.WildcardQuery) {
            com.liferay.portal.kernel.search.WildcardQuery wildcardQuery1 = (com.liferay.portal.kernel.search.WildcardQuery)query1;
            QueryTerm queryTerm1 = wildcardQuery1.getQueryTerm();
            String field1 = queryTerm1.getField();
            String value1 = queryTerm1.getValue();
            com.liferay.portal.kernel.search.WildcardQuery wildcardQuery2 = (com.liferay.portal.kernel.search.WildcardQuery)query2;
            QueryTerm queryTerm2 = wildcardQuery2.getQueryTerm();
            String field2 = queryTerm2.getField();
            String value2 = queryTerm2.getValue();
            if (field1.equals(field2) && value1.equals(value2)) {
                return true;
            }
        }
        return false;
    }

    protected BooleanClause.Occur getBooleanClauseOccur(BooleanClauseOccur occur) {
        if (occur.equals(BooleanClauseOccur.MUST)) {
            return BooleanClause.Occur.MUST;
        }
        if (occur.equals(BooleanClauseOccur.MUST_NOT)) {
            return BooleanClause.Occur.MUST_NOT;
        }
        return BooleanClause.Occur.SHOULD;
    }

    protected BooleanClauseOccur getBooleanClauseOccur(BooleanClause.Occur occur) {
        if (occur.equals((Object)BooleanClause.Occur.MUST)) {
            return BooleanClauseOccur.MUST;
        }
        if (occur.equals((Object)BooleanClause.Occur.MUST_NOT)) {
            return BooleanClauseOccur.MUST_NOT;
        }
        return BooleanClauseOccur.SHOULD;
    }

    protected void translateQuery(BooleanQuery booleanQuery, SearchContext searchContext, Query query, BooleanClause.Occur occur) throws Exception {
        BooleanClauseOccur booleanClauseOccur = this.getBooleanClauseOccur(occur);
        if (query instanceof TermQuery) {
            HashSet terms = new HashSet();
            query.extractTerms(terms);
            for (Term term : terms) {
                String termValue = term.text();
                booleanQuery.addTerm(term.field(), termValue, false, this.getBooleanClauseOccur(occur));
            }
        } else if (query instanceof org.apache.lucene.search.BooleanQuery) {
            org.apache.lucene.search.BooleanQuery curBooleanQuery = (org.apache.lucene.search.BooleanQuery)query;
            BooleanQuery conjunctionQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            BooleanQuery disjunctionQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            org.apache.lucene.search.BooleanClause[] booleanClauseArray = curBooleanQuery.getClauses();
            int n = booleanClauseArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.apache.lucene.search.BooleanClause booleanClause = booleanClauseArray[n2];
                BooleanClauseOccur curBooleanClauseOccur = this.getBooleanClauseOccur(booleanClause.getOccur());
                BooleanQuery subbooleanQuery = null;
                subbooleanQuery = curBooleanClauseOccur.equals(BooleanClauseOccur.SHOULD) ? disjunctionQuery : conjunctionQuery;
                this.translateQuery(subbooleanQuery, searchContext, booleanClause.getQuery(), booleanClause.getOccur());
                ++n2;
            }
            if (conjunctionQuery.hasClauses()) {
                booleanQuery.add((com.liferay.portal.kernel.search.Query)conjunctionQuery, BooleanClauseOccur.MUST);
            }
            if (disjunctionQuery.hasClauses()) {
                booleanQuery.add((com.liferay.portal.kernel.search.Query)disjunctionQuery, BooleanClauseOccur.SHOULD);
            }
        } else if (query instanceof FuzzyQuery) {
            FuzzyQuery fuzzyQuery = (FuzzyQuery)query;
            Term term = fuzzyQuery.getTerm();
            String termValue = term.text().concat("*");
            booleanQuery.addTerm(term.field(), termValue, true, booleanClauseOccur);
        } else if (query instanceof PhraseQuery) {
            PhraseQuery phraseQuery = (PhraseQuery)query;
            Term[] terms = phraseQuery.getTerms();
            StringBundler sb = new StringBundler(terms.length * 2);
            Term[] termArray = terms;
            int n = terms.length;
            int n3 = 0;
            while (n3 < n) {
                Term term = termArray[n3];
                sb.append(term.text());
                sb.append(" ");
                ++n3;
            }
            booleanQuery.addTerm(terms[0].field(), sb.toString().trim(), false, booleanClauseOccur);
        } else if (query instanceof PrefixQuery) {
            PrefixQuery prefixQuery = (PrefixQuery)query;
            Term prefixTerm = prefixQuery.getPrefix();
            String termValue = prefixTerm.text().concat("*");
            booleanQuery.addTerm(prefixTerm.field(), termValue, true, booleanClauseOccur);
        } else if (query instanceof org.apache.lucene.search.TermRangeQuery) {
            org.apache.lucene.search.TermRangeQuery termRangeQuery = (org.apache.lucene.search.TermRangeQuery)query;
            booleanQuery.addRangeTerm(termRangeQuery.getField(), termRangeQuery.getLowerTerm(), termRangeQuery.getUpperTerm());
        } else if (query instanceof WildcardQuery) {
            WildcardQuery wildcardQuery = (WildcardQuery)query;
            Term wildcardTerm = wildcardQuery.getTerm();
            booleanQuery.addTerm(wildcardTerm.field(), wildcardTerm.text(), true, booleanClauseOccur);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Ignoring unknown query type " + query.getClass() + " with query " + query));
        }
    }
}

