/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.model.Lock;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.repository.liferayrepository.model.LiferayModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayFileEntry
extends LiferayModel
implements FileEntry {
    private DLFileEntry _dlFileEntry;
    private boolean _escapedModel;

    public LiferayFileEntry(DLFileEntry dlFileEntry) {
        this._dlFileEntry = dlFileEntry;
    }

    public LiferayFileEntry(DLFileEntry fileEntry, boolean escapedModel) {
        this._dlFileEntry = fileEntry;
        this._escapedModel = escapedModel;
    }

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) throws PortalException, SystemException {
        return DLFileEntryPermission.contains(permissionChecker, this._dlFileEntry, actionId);
    }

    public Map<String, Serializable> getAttributes() {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        return expandoBridge.getAttributes();
    }

    @Override
    public long getCompanyId() {
        return this._dlFileEntry.getCompanyId();
    }

    public InputStream getContentStream() throws PortalException, SystemException {
        return this._dlFileEntry.getContentStream();
    }

    public InputStream getContentStream(String version) throws PortalException, SystemException {
        return this._dlFileEntry.getContentStream(version);
    }

    public Date getCreateDate() {
        return this._dlFileEntry.getCreateDate();
    }

    public String getDescription() {
        return this._dlFileEntry.getDescription();
    }

    public DLFileEntry getDLFileEntry() {
        return this._dlFileEntry;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._dlFileEntry.getExpandoBridge();
    }

    public String getExtension() {
        return this._dlFileEntry.getExtension();
    }

    public long getFileEntryId() {
        return this._dlFileEntry.getFileEntryId();
    }

    public FileVersion getFileVersion() throws PortalException, SystemException {
        return new LiferayFileVersion(this._dlFileEntry.getFileVersion());
    }

    public FileVersion getFileVersion(String version) throws PortalException, SystemException {
        return new LiferayFileVersion(this._dlFileEntry.getFileVersion(version));
    }

    public List<FileVersion> getFileVersions(int status) throws SystemException {
        return this.toFileVersions(this._dlFileEntry.getFileVersions(status));
    }

    public Folder getFolder() {
        return new LiferayFolder(this._dlFileEntry.getFolder());
    }

    public long getFolderId() {
        return this._dlFileEntry.getFolderId();
    }

    public long getGroupId() {
        return this._dlFileEntry.getGroupId();
    }

    public String getIcon() {
        return this._dlFileEntry.getIcon();
    }

    public FileVersion getLatestFileVersion() throws PortalException, SystemException {
        return new LiferayFileVersion(this._dlFileEntry.getLatestFileVersion(false));
    }

    public Lock getLock() {
        return this._dlFileEntry.getLock();
    }

    public String getMimeType() {
        return this._dlFileEntry.getMimeType();
    }

    public String getMimeType(String version) {
        try {
            DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)this._dlFileEntry.getFileEntryId(), (String)version);
            return dlFileVersion.getMimeType();
        }
        catch (Exception exception) {
            return "application/octet-stream";
        }
    }

    public Object getModel() {
        return this._dlFileEntry;
    }

    public Class<?> getModelClass() {
        return DLFileEntry.class;
    }

    @Override
    public String getModelClassName() {
        return DLFileEntry.class.getName();
    }

    public Date getModifiedDate() {
        return this._dlFileEntry.getModifiedDate();
    }

    @Override
    public long getPrimaryKey() {
        return this._dlFileEntry.getPrimaryKey();
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public int getReadCount() {
        return this._dlFileEntry.getReadCount();
    }

    public long getRepositoryId() {
        return this._dlFileEntry.getRepositoryId();
    }

    public long getSize() {
        return this._dlFileEntry.getSize();
    }

    public String getTitle() {
        return this._dlFileEntry.getTitle();
    }

    public long getUserId() {
        return this._dlFileEntry.getUserId();
    }

    public String getUserName() {
        return this._dlFileEntry.getVersionUserName();
    }

    public String getUserUuid() throws SystemException {
        return this._dlFileEntry.getUserUuid();
    }

    public String getUuid() {
        return this._dlFileEntry.getUuid();
    }

    public String getVersion() {
        return this._dlFileEntry.getVersion();
    }

    public long getVersionUserId() {
        return this._dlFileEntry.getVersionUserId();
    }

    public String getVersionUserName() {
        return this._dlFileEntry.getVersionUserName();
    }

    public String getVersionUserUuid() throws SystemException {
        return this._dlFileEntry.getVersionUserUuid();
    }

    public boolean hasLock() {
        return this._dlFileEntry.hasLock();
    }

    public boolean isCheckedOut() {
        return this._dlFileEntry.isCheckedOut();
    }

    public boolean isDefaultRepository() {
        return this._dlFileEntry.getGroupId() == this._dlFileEntry.getRepositoryId();
    }

    public boolean isEscapedModel() {
        return this._escapedModel;
    }

    public boolean isSupportsLocking() {
        return true;
    }

    public boolean isSupportsMetadata() {
        return true;
    }

    public boolean isSupportsSocial() {
        return true;
    }

    public void setCompanyId(long companyId) {
        this._dlFileEntry.setCompanyId(companyId);
    }

    public void setCreateDate(Date date) {
        this._dlFileEntry.setCreateDate(date);
    }

    public void setGroupId(long groupId) {
        this._dlFileEntry.setGroupId(groupId);
    }

    public void setModifiedDate(Date date) {
        this._dlFileEntry.setModifiedDate(date);
    }

    public void setPrimaryKey(long primaryKey) {
        this._dlFileEntry.setPrimaryKey(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
        this._dlFileEntry.setUserId(userId);
    }

    public void setUserName(String userName) {
        this._dlFileEntry.setUserName(userName);
    }

    public void setUserUuid(String userUuid) {
        this._dlFileEntry.setUserUuid(userUuid);
    }

    public FileEntry toEscapedModel() {
        if (this.isEscapedModel()) {
            return this;
        }
        return new LiferayFileEntry(this._dlFileEntry.toEscapedModel(), true);
    }
}

