/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.pop.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.util.mail.MailEngine;
import java.util.List;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POPNotificationsMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(POPNotificationsMessageListener.class);
    private Folder _inboxFolder;
    private Store _store;

    protected void doReceive(Message message) throws Exception {
        try {
            this.pollPopServer();
        }
        finally {
            this._store = null;
            this._inboxFolder = null;
        }
    }

    protected String getEmailAddress(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        InternetAddress internetAddress = (InternetAddress)addresses[0];
        return internetAddress.getAddress();
    }

    protected void initInboxFolder() throws Exception {
        if (this._inboxFolder == null || !this._inboxFolder.isOpen()) {
            this.initStore();
            Folder defaultFolder = this._store.getDefaultFolder();
            Folder[] folders = defaultFolder.list();
            if (folders.length == 0) {
                throw new MessagingException("Inbox not found");
            }
            this._inboxFolder = folders[0];
            this._inboxFolder.open(2);
        }
    }

    protected void initStore() throws Exception {
        if (this._store == null || !this._store.isConnected()) {
            String password;
            Session session = MailEngine.getSession();
            String storeProtocol = GetterUtil.getString((String)session.getProperty("mail.store.protocol"));
            if (!storeProtocol.equals("pop3s")) {
                storeProtocol = "pop3";
            }
            this._store = session.getStore(storeProtocol);
            String prefix = "mail." + storeProtocol + ".";
            String host = session.getProperty(String.valueOf(prefix) + "host");
            String user = session.getProperty(String.valueOf(prefix) + "user");
            if (Validator.isNull((String)user)) {
                user = session.getProperty("mail.smtp.user");
            }
            if (Validator.isNull((String)(password = session.getProperty(String.valueOf(prefix) + "password")))) {
                password = session.getProperty("mail.smtp.password");
            }
            this._store.connect(host, user, password);
        }
    }

    protected void nostifyListeners(List<MessageListener> listeners, javax.mail.Message message) throws Exception {
        String from = this.getEmailAddress(message.getFrom());
        String recipient = this.getEmailAddress(message.getRecipients(Message.RecipientType.TO));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("From " + from));
            _log.debug((Object)("Recipient " + recipient));
        }
        for (MessageListener messageListener : listeners) {
            try {
                if (!messageListener.accept(from, recipient, message)) continue;
                messageListener.deliver(from, recipient, message);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void nostifyListeners(javax.mail.Message[] messages) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Messages " + messages.length));
        }
        List<MessageListener> listeners = POPServerUtil.getListeners();
        int i = 0;
        while (i < messages.length) {
            javax.mail.Message message = messages[i];
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Message " + message));
            }
            this.nostifyListeners(listeners, message);
            ++i;
        }
    }

    protected void pollPopServer() throws Exception {
        this.initInboxFolder();
        javax.mail.Message[] messages = this._inboxFolder.getMessages();
        try {
            this.nostifyListeners(messages);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Deleting messages");
            }
            this._inboxFolder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
            this._inboxFolder.close(true);
        }
    }
}

