/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.notifications.UnknownChannelException;
import com.liferay.portal.util.PropsValues;
import java.util.List;

public class SynchronousPollerChannelListener
implements ChannelListener {
    private static Log _log = LogFactoryUtil.getLog(SynchronousPollerChannelListener.class);
    private long _companyId;
    private boolean _complete;
    private JSONObject _pollerResponseHeaderJSONObject;
    private long _userId;

    public SynchronousPollerChannelListener(long companyId, long userId, JSONObject pollerResponseHeaderJSONObject) {
        this._companyId = companyId;
        this._userId = userId;
        this._pollerResponseHeaderJSONObject = pollerResponseHeaderJSONObject;
    }

    public synchronized void channelListenerRemoved(long channelId) {
        this._complete = true;
        this.notify();
    }

    public synchronized String getNotificationEvents(long timeout) throws ChannelException {
        try {
            if (!this._complete) {
                this.wait(timeout);
            }
        }
        catch (InterruptedException interruptedException) {}
        try {
            Thread.sleep(PropsValues.POLLER_NOTIFICATIONS_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {}
        List notificationEvents = null;
        try {
            notificationEvents = ChannelHubManagerUtil.getNotificationEvents((long)this._companyId, (long)this._userId, (boolean)true);
        }
        catch (UnknownChannelException uce) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to complete processing because user session ended", (Throwable)uce);
            }
            return null;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this._pollerResponseHeaderJSONObject);
        for (NotificationEvent notificationEvent : notificationEvents) {
            jsonArray.put(notificationEvent.toJSONObject());
        }
        return jsonArray.toString();
    }

    public synchronized void notificationEventsAvailable(long channelId) {
        this._complete = true;
        this.notify();
    }
}

