/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.parsers.creole.visitor.impl;

import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.parsers.creole.ast.ASTNode;
import com.liferay.portal.parsers.creole.ast.BoldTextNode;
import com.liferay.portal.parsers.creole.ast.CollectionNode;
import com.liferay.portal.parsers.creole.ast.ForcedEndOfLineNode;
import com.liferay.portal.parsers.creole.ast.FormattedTextNode;
import com.liferay.portal.parsers.creole.ast.HeadingNode;
import com.liferay.portal.parsers.creole.ast.HorizontalNode;
import com.liferay.portal.parsers.creole.ast.ImageNode;
import com.liferay.portal.parsers.creole.ast.ItalicTextNode;
import com.liferay.portal.parsers.creole.ast.LineNode;
import com.liferay.portal.parsers.creole.ast.NoWikiSectionNode;
import com.liferay.portal.parsers.creole.ast.OrderedListItemNode;
import com.liferay.portal.parsers.creole.ast.OrderedListNode;
import com.liferay.portal.parsers.creole.ast.ParagraphNode;
import com.liferay.portal.parsers.creole.ast.ScapedNode;
import com.liferay.portal.parsers.creole.ast.UnformattedTextNode;
import com.liferay.portal.parsers.creole.ast.UnorderedListItemNode;
import com.liferay.portal.parsers.creole.ast.UnorderedListNode;
import com.liferay.portal.parsers.creole.ast.WikiPageNode;
import com.liferay.portal.parsers.creole.ast.extension.TableOfContentsNode;
import com.liferay.portal.parsers.creole.ast.link.LinkNode;
import com.liferay.portal.parsers.creole.ast.table.TableDataNode;
import com.liferay.portal.parsers.creole.ast.table.TableHeaderNode;
import com.liferay.portal.parsers.creole.ast.table.TableNode;
import com.liferay.portal.parsers.creole.visitor.ASTVisitor;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XhtmlTranslationVisitor
implements ASTVisitor {
    private int _currentNodeLevel;
    private StringBundler _sb = new StringBundler();

    public String translate(WikiPageNode wikiPageNode) {
        this._sb.setIndex(0);
        this.visit(wikiPageNode);
        return this._sb.toString();
    }

    @Override
    public void visit(BoldTextNode boldTextNode) {
        this.append("<strong>");
        if (boldTextNode.hasContent()) {
            this.traverse(boldTextNode.getChildASTNodes());
        }
        this.append("</strong>");
    }

    @Override
    public void visit(CollectionNode collectionNode) {
        for (ASTNode astNode : collectionNode.getASTNodes()) {
            astNode.accept(this);
        }
    }

    @Override
    public void visit(ForcedEndOfLineNode forcedEndOfLineNode) {
        this.append("<br/>");
    }

    @Override
    public void visit(FormattedTextNode formattedTextNode) {
        if (formattedTextNode.getContent() != null) {
            this.append(HtmlUtil.escape((String)formattedTextNode.getContent()));
        } else {
            this.traverse(formattedTextNode.getChildASTNodes());
        }
    }

    @Override
    public void visit(HeadingNode headingNode) {
        int level = headingNode.getLevel();
        this.append("<h");
        this.append(level);
        this.append(">");
        this.traverse(headingNode.getChildASTNodes());
        this.append("</h");
        this.append(level);
        this.append(">");
    }

    @Override
    public void visit(HorizontalNode horizontalNode) {
        this.append("<hr/>");
    }

    @Override
    public void visit(ImageNode imageNode) {
        this.append("<img src=\"");
        this.append(HtmlUtil.escape((String)imageNode.getLink()));
        this.append("\" ");
        if (imageNode.hasAltCollectionNode()) {
            this.append("alt=\"");
            CollectionNode altCollectionNode = imageNode.getAltNode();
            this.traverse(altCollectionNode.getASTNodes());
            this.append("\"");
        }
        this.append("/>");
    }

    @Override
    public void visit(ItalicTextNode italicTextNode) {
        this.append("<em>");
        if (italicTextNode.hasContent()) {
            this.traverse(italicTextNode.getChildASTNodes());
        }
        this.append("</em>");
    }

    @Override
    public void visit(LineNode lineNode) {
        this.traverse(lineNode.getChildASTNodes(), null, " ");
    }

    @Override
    public void visit(LinkNode linkNode) {
        this.append("<a href=\"");
        this.append(HtmlUtil.escape((String)linkNode.getLink()));
        this.append("\">");
        if (linkNode.hasAltCollectionNode()) {
            CollectionNode altCollectionNode = linkNode.getAltCollectionNode();
            this.traverse(altCollectionNode.getASTNodes());
        } else {
            this.append(HtmlUtil.escape((String)linkNode.getLink()));
        }
        this.append("</a>");
    }

    @Override
    public void visit(NoWikiSectionNode noWikiSectionNode) {
        this.append("<pre>");
        this.append(HtmlUtil.escape((String)noWikiSectionNode.getContent()));
        this.append("</pre>");
    }

    @Override
    public void visit(OrderedListItemNode orderedListItemNode) {
        this.appendLevelTags(orderedListItemNode.getLevel(), true);
        this.traverse(orderedListItemNode.getChildASTNodes(), "<li>", "</li>");
    }

    @Override
    public void visit(OrderedListNode orderedListNode) {
        this._currentNodeLevel = 0;
        this.traverse(orderedListNode.getChildASTNodes());
        this.appendLevelTags(0, true);
    }

    @Override
    public void visit(ParagraphNode paragraphNode) {
        this.traverse(paragraphNode.getChildASTNodes(), "<p>", "</p>");
    }

    @Override
    public void visit(ScapedNode scapedNode) {
        this.append(HtmlUtil.escape((String)scapedNode.getContent()));
    }

    @Override
    public void visit(TableDataNode tableDataNode) {
        this.traverse(tableDataNode.getChildASTNodes(), "<td>", "</td>");
    }

    @Override
    public void visit(TableHeaderNode tableHeaderNode) {
        this.traverse(tableHeaderNode.getChildASTNodes(), "<th>", "</th>");
    }

    @Override
    public void visit(TableNode tableNode) {
        this.append("<table>");
        this.traverseAndWriteForEach(tableNode.getChildASTNodes(), "<tr>", "</tr>");
        this.append("</table>");
    }

    @Override
    public void visit(TableOfContentsNode tableOfContentsNode) {
    }

    @Override
    public void visit(UnformattedTextNode unformattedTextNode) {
        if (unformattedTextNode.hasContent()) {
            this.append(HtmlUtil.escape((String)unformattedTextNode.getContent()));
        } else {
            this.traverse(unformattedTextNode.getChildASTNodes());
        }
    }

    @Override
    public void visit(UnorderedListItemNode unorderedListItemNode) {
        this.appendLevelTags(unorderedListItemNode.getLevel(), false);
        this.traverse(unorderedListItemNode.getChildASTNodes(), "<li>", "</li>");
    }

    @Override
    public void visit(UnorderedListNode unorderedListNode) {
        this._currentNodeLevel = 0;
        this.traverse(unorderedListNode.getChildASTNodes());
        this.appendLevelTags(0, false);
    }

    @Override
    public void visit(WikiPageNode wikiPageNode) {
        this.traverse(wikiPageNode.getChildASTNodes());
    }

    protected void append(Object object) {
        if (object != null) {
            this._sb.append(object);
        }
    }

    protected void appendLevelTags(int nodeLevel, boolean ordered) {
        int diff = nodeLevel - this._currentNodeLevel;
        if (diff > 0) {
            int i = 0;
            while (i < diff) {
                if (ordered) {
                    this.append("<ol>");
                } else {
                    this.append("<ul>");
                }
                ++i;
            }
        } else if (diff < 0) {
            int i = 0;
            while (i > diff) {
                if (ordered) {
                    this.append("</ol>");
                } else {
                    this.append("</ul>");
                }
                --i;
            }
        }
        this._currentNodeLevel = nodeLevel;
    }

    protected void traverse(List<ASTNode> astNodes) {
        if (astNodes != null) {
            for (ASTNode astNode : astNodes) {
                astNode.accept(this);
            }
        }
    }

    protected void traverse(List<ASTNode> astNodes, String open, String close) {
        this.append(open);
        this.traverse(astNodes);
        this.append(close);
    }

    protected void traverseAndWriteForEach(List<ASTNode> astNodes, String open, String close) {
        for (ASTNode curNode : astNodes) {
            this.append(open);
            curNode.accept(this);
            this.append(close);
        }
    }
}

