/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.service;

import aQute.libg.header.OSGiHeader;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServiceLoader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.osgi.BundleListener;
import com.liferay.portal.osgi.FrameworkListener;
import com.liferay.portal.osgi.OSGiException;
import com.liferay.portal.osgi.ServiceListener;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.UniqueList;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiServiceUtil {
    private static Log _log = LogFactoryUtil.getLog(OSGiServiceUtil.class);
    private static OSGiServiceUtil _instance = new OSGiServiceUtil();
    private Framework _framework;

    public static Object addBundle(String location) throws PortalException {
        return OSGiServiceUtil.addBundle(location, null);
    }

    public static Object addBundle(String location, InputStream inputStream) throws PortalException {
        return _instance._addBundle(location, inputStream);
    }

    public static Framework getFramework() {
        return _instance._getFramework();
    }

    public static String getState(long bundleId) throws PortalException {
        return _instance._getState(bundleId);
    }

    public static void init() throws Exception {
        _instance._init();
    }

    public static void registerContext(Object context) {
        _instance._registerContext(context);
    }

    public static void setBundleStartLevel(long bundleId, int startLevel) throws PortalException {
        _instance._setBundleStartLevel(bundleId, startLevel);
    }

    public static void start() throws Exception {
        _instance._start();
    }

    public static void startBundle(long bundleId) throws PortalException {
        _instance._startBundle(bundleId);
    }

    public static void startBundle(long bundleId, int options) throws PortalException {
        _instance._startBundle(bundleId, options);
    }

    public static void stopFramework() throws Exception {
        _instance._stopFramework();
    }

    public static void stopRuntime() throws Exception {
        _instance._stopRuntime();
    }

    public static void stopBundle(long bundleId) throws PortalException {
        _instance._stopBundle(bundleId);
    }

    public static void stopBundle(long bundleId, int options) throws PortalException {
        _instance._stopBundle(bundleId, options);
    }

    public static void uninstallBundle(long bundleId) throws PortalException {
        _instance._uninstallBundle(bundleId);
    }

    public static void updateBundle(long bundleId) throws PortalException {
        _instance._updateBundle(bundleId);
    }

    public static void updateBundle(long bundleId, InputStream inputStream) throws PortalException {
        _instance._updateBundle(bundleId, inputStream);
    }

    private OSGiServiceUtil() {
    }

    private Object _addBundle(String location, InputStream inputStream) throws PortalException {
        this._checkPermission();
        if (this._framework == null) {
            return null;
        }
        BundleContext bundleContext = this._framework.getBundleContext();
        try {
            return bundleContext.installBundle(location, inputStream);
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new OSGiException(be);
        }
    }

    private Map<String, String> _buildProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Bundle-Description", ReleaseInfo.getReleaseInfo());
        properties.put("Bundle-Name", ReleaseInfo.getName());
        properties.put("Bundle-Vendor", ReleaseInfo.getVendor());
        properties.put("Bundle-Version", ReleaseInfo.getVersion());
        properties.put("org.osgi.framework.startlevel.beginning", String.valueOf(PropsValues.OSGI_FRAMEWORK_BEGINNING_START_LEVEL));
        properties.put("org.osgi.framework.bundle.parent", "app");
        properties.put("org.osgi.framework.storage", PropsValues.OSGI_FRAMEWORK_STORAGE);
        UniqueList packages = new UniqueList();
        try {
            this._getBundleExportPackages(PropsValues.OSGI_SYSTEM_BUNDLE_EXPORT_PACKAGES, (List<String>)packages);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        packages.addAll(Arrays.asList(PropsValues.OSGI_SYSTEM_PACKAGES_EXTRA));
        Collections.sort(packages);
        properties.put("org.osgi.framework.system.packages.extra", StringUtil.merge((Collection)packages));
        return properties;
    }

    private void _checkPermission() throws PrincipalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !permissionChecker.isOmniadmin()) {
            throw new PrincipalException();
        }
    }

    private Bundle _getBundle(long bundleId) {
        if (this._framework == null) {
            return null;
        }
        BundleContext bundleContext = this._framework.getBundleContext();
        return bundleContext.getBundle(bundleId);
    }

    private void _getBundleExportPackages(String[] bundleSymbolicNames, List<String> packages) throws Exception {
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        Enumeration<URL> enu = classLoader.getResources("META-INF/MANIFEST.MF");
        block0: while (enu.hasMoreElements()) {
            URL url = enu.nextElement();
            Manifest manifest = new Manifest(url.openStream());
            Attributes attributes = manifest.getMainAttributes();
            String bundleSymbolicName = attributes.getValue("Bundle-SymbolicName");
            if (Validator.isNull((String)bundleSymbolicName)) continue;
            String[] stringArray = bundleSymbolicNames;
            int n = bundleSymbolicNames.length;
            int n2 = 0;
            while (n2 < n) {
                String curBundleSymbolicName = stringArray[n2];
                if (bundleSymbolicName.startsWith(curBundleSymbolicName)) {
                    String exportPackage = attributes.getValue("Export-Package");
                    Map exportPackageMap = OSGiHeader.parseHeader((String)exportPackage);
                    for (Map.Entry entry : exportPackageMap.entrySet()) {
                        String javaPackage = (String)entry.getKey();
                        Map javaPackageMap = (Map)entry.getValue();
                        StringBundler sb = new StringBundler(4);
                        sb.append(javaPackage);
                        sb.append(";version=\"");
                        if (javaPackageMap.containsKey("version")) {
                            String version = (String)javaPackageMap.get("version");
                            sb.append(version);
                        } else {
                            String bundleVersionString = attributes.getValue("Bundle-Version");
                            sb.append(bundleVersionString);
                        }
                        sb.append("\"");
                        javaPackage = sb.toString();
                        packages.add(javaPackage);
                    }
                    continue block0;
                }
                ++n2;
            }
        }
    }

    private Framework _getFramework() {
        return this._framework;
    }

    private Set<Class<?>> _getInterfaces(Object bean) {
        Class<?> interfaceClass;
        HashSet interfaces = new HashSet();
        Class<?> beanClass = bean.getClass();
        Class<?>[] classArray = beanClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            interfaceClass = classArray[n2];
            interfaces.add(interfaceClass);
            ++n2;
        }
        while ((beanClass = beanClass.getSuperclass()) != null) {
            classArray = beanClass.getInterfaces();
            n = classArray.length;
            n2 = 0;
            while (n2 < n) {
                interfaceClass = classArray[n2];
                if (!interfaces.contains(interfaceClass)) {
                    interfaces.add(interfaceClass);
                }
                ++n2;
            }
        }
        return interfaces;
    }

    private String _getState(long bundleId) throws PortalException {
        this._checkPermission();
        Bundle bundle = this._getBundle(bundleId);
        if (bundle == null) {
            throw new OSGiException("No bundle with ID " + bundleId);
        }
        int state = bundle.getState();
        if (state == 32) {
            return "active";
        }
        if (state == 2) {
            return "installed";
        }
        if (state == 4) {
            return "resolved";
        }
        if (state == 8) {
            return "starting";
        }
        if (state == 16) {
            return "stopping";
        }
        if (state == 1) {
            return "uninstalled";
        }
        return "";
    }

    private void _init() throws Exception {
        List frameworkFactories = ServiceLoader.load(FrameworkFactory.class);
        if (frameworkFactories.isEmpty()) {
            return;
        }
        FrameworkFactory frameworkFactory = (FrameworkFactory)frameworkFactories.get(0);
        Map<String, String> properties = this._buildProperties();
        this._framework = frameworkFactory.newFramework(properties);
        this._framework.init();
        BundleContext bundleContext = this._framework.getBundleContext();
        BundleListener bundleListener = new BundleListener();
        bundleContext.addBundleListener((org.osgi.framework.BundleListener)bundleListener);
        FrameworkListener frameworkListener = new FrameworkListener();
        bundleContext.addFrameworkListener((org.osgi.framework.FrameworkListener)frameworkListener);
        ServiceListener serviceListener = new ServiceListener();
        bundleContext.addServiceListener((org.osgi.framework.ServiceListener)serviceListener);
        this._framework.start();
    }

    private void _registerApplicationContext(ApplicationContext applicationContext) {
        BundleContext bundleContext = this._framework.getBundleContext();
        String[] stringArray = applicationContext.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Object bean = null;
            try {
                bean = applicationContext.getBean(beanName);
            }
            catch (BeanIsAbstractException beanIsAbstractException) {
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (bean != null) {
                this._registerService(bundleContext, beanName, bean);
            }
            ++n2;
        }
    }

    private void _registerContext(Object context) {
        if (context == null) {
            return;
        }
        if (context instanceof ApplicationContext && PropsValues.OSGI_REGISTER_LIFERAY_SERVICES) {
            ApplicationContext applicationContext = (ApplicationContext)context;
            this._registerApplicationContext(applicationContext);
        } else if (context instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)context;
            this._registerServletContext(servletContext);
        }
    }

    private void _registerService(BundleContext bundleContext, String beanName, Object bean) {
        Set<Class<?>> interfaces = this._getInterfaces(bean);
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> interfaceClass : interfaces) {
            names.add(interfaceClass.getName());
        }
        if (names.isEmpty()) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("bean.id", beanName);
        properties.put("original.bean", Boolean.TRUE);
        properties.put("service.vendor", ReleaseInfo.getVendor());
        bundleContext.registerService(names.toArray(new String[names.size()]), bean, properties);
    }

    private void _registerServletContext(ServletContext servletContext) {
        BundleContext bundleContext = this._framework.getBundleContext();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("bean.id", ServletContext.class.getName());
        properties.put("original.bean", Boolean.TRUE);
        properties.put("service.vendor", ReleaseInfo.getVendor());
        bundleContext.registerService(new String[]{ServletContext.class.getName()}, (Object)servletContext, properties);
    }

    private void _setBundleStartLevel(long bundleId, int startLevel) throws PortalException {
        this._checkPermission();
        Bundle bundle = this._getBundle(bundleId);
        if (bundle == null) {
            throw new OSGiException("No bundle with ID " + bundleId);
        }
        BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        bundleStartLevel.setStartLevel(startLevel);
    }

    private void _start() throws Exception {
        if (this._framework == null) {
            return;
        }
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this._framework.adapt(FrameworkStartLevel.class);
        frameworkStartLevel.setStartLevel(PropsValues.OSGI_FRAMEWORK_RUNTIME_START_LEVEL, null);
    }

    private void _startBundle(long bundleId) throws PortalException {
        this._checkPermission();
        Bundle bundle = this._getBundle(bundleId);
        if (bundle == null) {
            throw new OSGiException("No bundle with ID " + bundleId);
        }
        try {
            bundle.start();
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new OSGiException(be);
        }
    }

    private void _startBundle(long bundleId, int options) throws PortalException {
        this._checkPermission();
        Bundle bundle = this._getBundle(bundleId);
        if (bundle == null) {
            throw new OSGiException("No bundle with ID " + bundleId);
        }
        try {
            bundle.start(options);
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new OSGiException(be);
        }
    }

    private void _stopFramework() throws Exception {
        if (this._framework == null) {
            return;
        }
        this._framework.stop();
    }

    private void _stopRuntime() throws Exception {
        if (this._framework == null) {
            return;
        }
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this._framework.adapt(FrameworkStartLevel.class);
        frameworkStartLevel.setStartLevel(PropsValues.OSGI_FRAMEWORK_BEGINNING_START_LEVEL, null);
    }

    private void _stopBundle(long bundleId) throws PortalException {
        this._checkPermission();
        Bundle bundle = this._getBundle(bundleId);
        if (bundle == null) {
            throw new OSGiException("No bundle with ID " + bundleId);
        }
        try {
            bundle.stop();
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new OSGiException(be);
        }
    }

    private void _stopBundle(long bundleId, int options) throws PortalException {
        this._checkPermission();
        Bundle bundle = this._getBundle(bundleId);
        if (bundle == null) {
            throw new OSGiException("No bundle with ID " + bundleId);
        }
        try {
            bundle.stop(options);
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new OSGiException(be);
        }
    }

    private void _uninstallBundle(long bundleId) throws PortalException {
        this._checkPermission();
        Bundle bundle = this._getBundle(bundleId);
        if (bundle == null) {
            throw new OSGiException("No bundle with ID " + bundleId);
        }
        try {
            bundle.uninstall();
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new OSGiException(be);
        }
    }

    private void _updateBundle(long bundleId) throws PortalException {
        this._checkPermission();
        Bundle bundle = this._getBundle(bundleId);
        if (bundle == null) {
            throw new OSGiException("No bundle with ID " + bundleId);
        }
        try {
            bundle.update();
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new OSGiException(be);
        }
    }

    private void _updateBundle(long bundleId, InputStream inputStream) throws PortalException {
        this._checkPermission();
        Bundle bundle = this._getBundle(bundleId);
        if (bundle == null) {
            throw new OSGiException("No bundle with ID " + bundleId);
        }
        try {
            bundle.update(inputStream);
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
            throw new OSGiException(be);
        }
    }
}

