/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;

public class FrameworkListener
implements org.osgi.framework.FrameworkListener {
    private static Log _log = LogFactoryUtil.getLog(FrameworkListener.class);

    public void frameworkEvent(FrameworkEvent frameworkEvent) {
        try {
            int type = frameworkEvent.getType();
            if (type == 2) {
                this.frameworkEventError(frameworkEvent);
            } else if (type == 32) {
                this.frameworkEventInfo(frameworkEvent);
            } else if (type == 4) {
                this.frameworkEventPackagesRefreshed(frameworkEvent);
            } else if (type == 1) {
                this.frameworkEventStarted(frameworkEvent);
            } else if (type == 8) {
                this.frameworkEventStartLevelChanged(frameworkEvent);
            } else if (type == 64) {
                this.frameworkEventStopped(frameworkEvent);
            } else if (type == 256) {
                this.frameworkEventStoppedBootClasspathModified(frameworkEvent);
            } else if (type == 128) {
                this.frameworkEventStoppedUpdate(frameworkEvent);
            } else if (type == 512) {
                this.frameworkEventWaitTimedout(frameworkEvent);
            } else if (type == 16) {
                this.frameworkEventWarning(frameworkEvent);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void frameworkEventError(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isErrorEnabled()) {
            return;
        }
        log.error((Object)"[ERROR]", frameworkEvent.getThrowable());
    }

    protected void frameworkEventInfo(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((Object)"[INFO]", frameworkEvent.getThrowable());
    }

    protected void frameworkEventPackagesRefreshed(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((Object)"[PACKAGES_REFRESHED]", frameworkEvent.getThrowable());
    }

    protected void frameworkEventStarted(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((Object)"[STARTED]", frameworkEvent.getThrowable());
    }

    protected void frameworkEventStartLevelChanged(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((Object)"[STARTLEVEL_CHANGED]", frameworkEvent.getThrowable());
    }

    protected void frameworkEventStopped(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((Object)"[STOPPED]", frameworkEvent.getThrowable());
    }

    protected void frameworkEventStoppedBootClasspathModified(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((Object)"[STOPPED_BOOTCLASSPATH_MODIFIED]", frameworkEvent.getThrowable());
    }

    protected void frameworkEventStoppedUpdate(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((Object)"[STOPPED_UPDATE]", frameworkEvent.getThrowable());
    }

    protected void frameworkEventWaitTimedout(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info((Object)"[WAIT_TIMEDOUT]", frameworkEvent.getThrowable());
    }

    protected void frameworkEventWarning(FrameworkEvent frameworkEvent) throws Exception {
        Bundle bundle = frameworkEvent.getBundle();
        Log log = LogFactoryUtil.getLog((String)bundle.getSymbolicName());
        if (!log.isWarnEnabled()) {
            return;
        }
        log.warn((Object)"[WARNING]", frameworkEvent.getThrowable());
    }
}

