/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.notifications;

import com.liferay.portal.kernel.notifications.Channel;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelHub;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.notifications.UnknownChannelException;
import com.liferay.portal.service.UserNotificationEventLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelHubImpl
implements ChannelHub {
    private Channel _channel;
    private ConcurrentMap<Long, Channel> _channels = new ConcurrentHashMap<Long, Channel>();
    private long _companyId = 0L;

    public void cleanUp() throws ChannelException {
        for (Channel channel : this._channels.values()) {
            channel.cleanUp();
        }
    }

    public void cleanUp(long userId) throws ChannelException {
        Channel channel = this.getChannel(userId);
        channel.cleanUp();
    }

    public ChannelHub clone(long companyId) {
        ChannelHubImpl channelHubImpl = new ChannelHubImpl();
        channelHubImpl.setChannelPrototype(this._channel);
        channelHubImpl.setCompanyId(companyId);
        return channelHubImpl;
    }

    public void confirmDelivery(long userId, Collection<String> notificationEventUuids) throws ChannelException {
        this.confirmDelivery(userId, notificationEventUuids, false);
    }

    public void confirmDelivery(long userId, Collection<String> notificationEventUuids, boolean archive) throws ChannelException {
        Channel channel = this.getChannel(userId);
        channel.confirmDelivery(notificationEventUuids, archive);
    }

    public void confirmDelivery(long userId, String notificationEventUuid) throws ChannelException {
        this.confirmDelivery(userId, notificationEventUuid, false);
    }

    public void confirmDelivery(long userId, String notificationEventUuid, boolean archive) throws ChannelException {
        Channel channel = this.getChannel(userId);
        channel.confirmDelivery(notificationEventUuid, archive);
    }

    public Channel createChannel(long userId) throws ChannelException {
        if (this._channels.containsKey(userId)) {
            return (Channel)this._channels.get(userId);
        }
        Channel channel = this._channel.clone(this._companyId, userId);
        Channel oldChannel = this._channels.putIfAbsent(userId, channel);
        if (oldChannel != null) {
            channel.sendNotificationEvents((Collection)oldChannel.getNotificationEvents());
        }
        channel.init();
        return channel;
    }

    public void deleteUserNotificiationEvent(long userId, String notificationEventUuid) throws ChannelException {
        Channel channel = this.getChannel(userId);
        channel.deleteUserNotificiationEvent(notificationEventUuid);
    }

    public void deleteUserNotificiationEvents(long userId, Collection<String> notificationEventUuids) throws ChannelException {
        Channel channel = this.getChannel(userId);
        channel.deleteUserNotificiationEvents(notificationEventUuids);
    }

    public void destroy() throws ChannelException {
        Set channels = this._channels.entrySet();
        Iterator itr = channels.iterator();
        while (itr.hasNext()) {
            Channel channel = (Channel)itr.next().getValue();
            channel.close();
            itr.remove();
        }
    }

    public Channel destroyChannel(long userId) throws ChannelException {
        Channel channel = (Channel)this._channels.remove(userId);
        if (channel != null) {
            channel.close();
        }
        return channel;
    }

    public Channel fetchChannel(long userId) throws ChannelException {
        return this.fetchChannel(userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel fetchChannel(long userId, boolean createIfAbsent) throws ChannelException {
        Channel channel = (Channel)this._channels.get(userId);
        if (channel == null) {
            ConcurrentMap<Long, Channel> concurrentMap = this._channels;
            synchronized (concurrentMap) {
                channel = (Channel)this._channels.get(userId);
                if (channel == null && createIfAbsent) {
                    channel = this.createChannel(userId);
                }
            }
        }
        return channel;
    }

    public void flush() throws ChannelException {
        for (Channel channel : this._channels.values()) {
            channel.flush();
        }
    }

    public void flush(long userId) throws ChannelException {
        Channel channel = this.fetchChannel(userId);
        if (channel != null) {
            channel.flush();
        }
    }

    public void flush(long userId, long timestamp) throws ChannelException {
        Channel channel = this.fetchChannel(userId);
        if (channel != null) {
            channel.flush(timestamp);
        }
    }

    public Channel getChannel(long userId) throws ChannelException {
        return this.getChannel(userId, false);
    }

    public Channel getChannel(long userId, boolean createIfAbsent) throws ChannelException {
        Channel channel = this.fetchChannel(userId, createIfAbsent);
        if (channel == null) {
            throw new UnknownChannelException("No channel exists with user id " + userId);
        }
        return channel;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public List<NotificationEvent> getNotificationEvents(long userId) throws ChannelException {
        return this.getNotificationEvents(userId, false);
    }

    public List<NotificationEvent> getNotificationEvents(long userId, boolean flush) throws ChannelException {
        Channel channel = this.getChannel(userId);
        return channel.getNotificationEvents(flush);
    }

    public Collection<Long> getUserIds() {
        return Collections.unmodifiableSet(this._channels.keySet());
    }

    public void registerChannelListener(long userId, ChannelListener channelListener) throws ChannelException {
        Channel channel = this.getChannel(userId);
        channel.registerChannelListener(channelListener);
    }

    public void removeTransientNotificationEvents(long userId, Collection<NotificationEvent> notificationEvents) throws ChannelException {
        Channel channel = this.fetchChannel(userId);
        if (channel != null) {
            channel.removeTransientNotificationEvents(notificationEvents);
        }
    }

    public void removeTransientNotificationEventsByUuid(long userId, Collection<String> notificationEventUuids) throws ChannelException {
        Channel channel = this.fetchChannel(userId);
        if (channel != null) {
            channel.removeTransientNotificationEventsByUuid(notificationEventUuids);
        }
    }

    public void sendNotificationEvent(long userId, NotificationEvent notificationEvent) throws ChannelException {
        Channel channel = this.fetchChannel(userId);
        if (channel != null) {
            channel.sendNotificationEvent(notificationEvent);
            return;
        }
        if (!PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED || !notificationEvent.isDeliveryRequired()) {
            return;
        }
        try {
            UserNotificationEventLocalServiceUtil.addUserNotificationEvent((long)userId, (NotificationEvent)notificationEvent);
        }
        catch (Exception e) {
            throw new ChannelException("Unable to send event", (Throwable)e);
        }
    }

    public void sendNotificationEvents(long userId, Collection<NotificationEvent> notificationEvents) throws ChannelException {
        Channel channel = this.fetchChannel(userId);
        if (channel != null) {
            channel.sendNotificationEvents(notificationEvents);
            return;
        }
        if (!PropsValues.USER_NOTIFICATION_EVENT_CONFIRMATION_ENABLED) {
            return;
        }
        ArrayList<NotificationEvent> persistedNotificationEvents = new ArrayList<NotificationEvent>(notificationEvents.size());
        for (NotificationEvent notificationEvent : notificationEvents) {
            if (!notificationEvent.isDeliveryRequired()) continue;
            persistedNotificationEvents.add(notificationEvent);
        }
        try {
            UserNotificationEventLocalServiceUtil.addUserNotificationEvents((long)userId, persistedNotificationEvents);
        }
        catch (Exception e) {
            throw new ChannelException("Unable to send events", (Throwable)e);
        }
    }

    public void setChannelPrototype(Channel channel) {
        this._channel = channel;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void unregisterChannelListener(long userId, ChannelListener channelListener) throws ChannelException {
        Channel channel = this.getChannel(userId);
        channel.unregisterChannelListener(channelListener);
    }
}

