/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.service;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.monitoring.statistics.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.statistics.RequestStatistics;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.monitoring.statistics.service.ServiceRequestDataSample;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceStatistics
implements DataSampleProcessor<ServiceRequestDataSample> {
    private String _className;
    private Map<MethodKey, RequestStatistics> _methodRequestStatistics = new ConcurrentHashMap<MethodKey, RequestStatistics>();

    public ServiceStatistics(String className) {
        this._className = className;
    }

    public long getAverageTime(String methodName, String[] parameterTypes) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(this._className, methodName, parameterTypes);
            RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodKey);
            if (requestStatistics != null) {
                return requestStatistics.getAverageTime();
            }
        }
        catch (ClassNotFoundException e) {
            throw new SystemException((Throwable)e);
        }
        return -1L;
    }

    public long getErrorCount(String methodName, String[] parameterTypes) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(this._className, methodName, parameterTypes);
            RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodKey);
            if (requestStatistics != null) {
                return requestStatistics.getErrorCount();
            }
        }
        catch (ClassNotFoundException e) {
            throw new SystemException((Throwable)e);
        }
        return -1L;
    }

    public long getMaxTime(String methodName, String[] parameterTypes) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(this._className, methodName, parameterTypes);
            RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodKey);
            if (requestStatistics != null) {
                return requestStatistics.getMaxTime();
            }
        }
        catch (ClassNotFoundException e) {
            throw new SystemException((Throwable)e);
        }
        return -1L;
    }

    public long getMinTime(String methodName, String[] parameterTypes) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(this._className, methodName, parameterTypes);
            RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodKey);
            if (requestStatistics != null) {
                return requestStatistics.getMinTime();
            }
        }
        catch (ClassNotFoundException e) {
            throw new SystemException((Throwable)e);
        }
        return -1L;
    }

    public long getRequestCount(String methodName, String[] parameterTypes) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(this._className, methodName, parameterTypes);
            RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodKey);
            if (requestStatistics != null) {
                return requestStatistics.getRequestCount();
            }
        }
        catch (ClassNotFoundException e) {
            throw new SystemException((Throwable)e);
        }
        return -1L;
    }

    public void processDataSample(ServiceRequestDataSample serviceRequestDataSample) {
        RequestStatus requestStatus;
        MethodKey methodKey = serviceRequestDataSample.getMethodKey();
        RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodKey);
        if (requestStatistics == null) {
            requestStatistics = new RequestStatistics(methodKey.toString());
            this._methodRequestStatistics.put(methodKey, requestStatistics);
        }
        if ((requestStatus = serviceRequestDataSample.getRequestStatus()) == RequestStatus.ERROR) {
            requestStatistics.incrementError();
        } else if (requestStatus == RequestStatus.TIMEOUT) {
            requestStatistics.incrementTimeout();
        } else if (requestStatus == RequestStatus.SUCCESS) {
            requestStatistics.incrementSuccessDuration(serviceRequestDataSample.getDuration());
        }
    }
}

