/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.portlet;

import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.monitoring.statistics.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.statistics.RequestStatistics;
import com.liferay.portal.monitoring.statistics.portlet.PortletRequestDataSample;
import com.liferay.portal.monitoring.statistics.portlet.PortletRequestType;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletStatistics
implements DataSampleProcessor<PortletRequestDataSample> {
    private RequestStatistics _actionRequestStatistics;
    private String _displayName;
    private RequestStatistics _eventRequestStatistics;
    private String _portletId;
    private String _portletName;
    private RequestStatistics _renderRequestStatistics;
    private Map<PortletRequestType, RequestStatistics> _requestStatistics = new HashMap<PortletRequestType, RequestStatistics>();
    private RequestStatistics _resourceRequestStatistics;

    public PortletStatistics(String portletId, String portletName, String displayName) {
        this._portletId = portletId;
        this._portletName = portletName;
        this._displayName = displayName;
        this._actionRequestStatistics = new RequestStatistics(portletId);
        this._eventRequestStatistics = new RequestStatistics(portletId);
        this._renderRequestStatistics = new RequestStatistics(portletId);
        this._resourceRequestStatistics = new RequestStatistics(portletId);
        this._requestStatistics.put(PortletRequestType.ACTION, this._actionRequestStatistics);
        this._requestStatistics.put(PortletRequestType.EVENT, this._eventRequestStatistics);
        this._requestStatistics.put(PortletRequestType.RENDER, this._renderRequestStatistics);
        this._requestStatistics.put(PortletRequestType.RESOURCE, this._resourceRequestStatistics);
    }

    public RequestStatistics getActionRequestStatistics() {
        return this._actionRequestStatistics;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public RequestStatistics getEventRequestStatistics() {
        return this._eventRequestStatistics;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public String getPortletName() {
        return this._portletName;
    }

    public RequestStatistics getRenderRequestStatistics() {
        return this._renderRequestStatistics;
    }

    public RequestStatistics getResourceRequestStatistics() {
        return this._resourceRequestStatistics;
    }

    public void processDataSample(PortletRequestDataSample portletRequestDataSample) throws MonitoringException {
        if (!portletRequestDataSample.getPortletId().equals(this._portletId)) {
            return;
        }
        PortletRequestType portletRequestType = portletRequestDataSample.getRequestType();
        RequestStatistics requestStatistics = this._requestStatistics.get((Object)portletRequestType);
        if (requestStatistics == null) {
            throw new MonitoringException("No statistics found for " + portletRequestDataSample);
        }
        RequestStatus requestStatus = portletRequestDataSample.getRequestStatus();
        if (requestStatus.equals((Object)RequestStatus.ERROR)) {
            requestStatistics.incrementError();
        } else if (requestStatus.equals((Object)RequestStatus.SUCCESS)) {
            requestStatistics.incrementSuccessDuration(portletRequestDataSample.getDuration());
        } else if (requestStatus.equals((Object)RequestStatus.TIMEOUT)) {
            requestStatistics.incrementTimeout();
        }
    }

    public void reset() {
        this._actionRequestStatistics.reset();
        this._eventRequestStatistics.reset();
        this._renderRequestStatistics.reset();
        this._resourceRequestStatistics.reset();
    }
}

