/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.portal;

import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.monitoring.statistics.RequestStatistics;
import com.liferay.portal.kernel.monitoring.statistics.SummaryStatistics;
import com.liferay.portal.monitoring.statistics.portal.CompanyStatistics;
import com.liferay.portal.monitoring.statistics.portal.ServerStatistics;
import java.util.Set;

public class ServerSummaryStatistics
implements SummaryStatistics {
    private ServerStatistics _serverStatistics;

    public long getAverageTime() {
        long averageTime = 0L;
        Set<CompanyStatistics> companyStatisticsSet = this._serverStatistics.getCompanyStatisticsSet();
        for (CompanyStatistics companyStatistics : companyStatisticsSet) {
            RequestStatistics requestStatistics = companyStatistics.getRequestStatistics();
            averageTime += requestStatistics.getAverageTime();
        }
        return averageTime / (long)companyStatisticsSet.size();
    }

    public long getAverageTimeByCompany(long companyId) throws MonitoringException {
        return this.getRequestStatistics(companyId).getAverageTime();
    }

    public long getAverageTimeByCompany(String webId) throws MonitoringException {
        return this.getRequestStatistics(webId).getAverageTime();
    }

    public long getErrorCount() {
        int errorCount = 0;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            errorCount = (int)((long)errorCount + companyStatistics.getRequestStatistics().getErrorCount());
        }
        return errorCount;
    }

    public long getErrorCountByCompany(long companyId) throws MonitoringException {
        return this.getRequestStatistics(companyId).getErrorCount();
    }

    public long getErrorCountByCompany(String webId) throws MonitoringException {
        return this.getRequestStatistics(webId).getErrorCount();
    }

    public long getMaxTime() {
        long maxTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            if (companyStatistics.getMaxTime() <= maxTime) continue;
            maxTime = companyStatistics.getMaxTime();
        }
        return maxTime;
    }

    public long getMaxTimeByCompany(long companyId) throws MonitoringException {
        return this.getRequestStatistics(companyId).getMaxTime();
    }

    public long getMaxTimeByCompany(String webId) throws MonitoringException {
        return this.getRequestStatistics(webId).getMaxTime();
    }

    public long getMinTime() {
        long minTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            if (companyStatistics.getMinTime() >= minTime) continue;
            minTime = companyStatistics.getMinTime();
        }
        return minTime;
    }

    public long getMinTimeByCompany(long companyId) throws MonitoringException {
        return this.getRequestStatistics(companyId).getMinTime();
    }

    public long getMinTimeByCompany(String webId) throws MonitoringException {
        return this.getRequestStatistics(webId).getMinTime();
    }

    public long getRequestCount() {
        int requestCount = 0;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            requestCount = (int)((long)requestCount + companyStatistics.getRequestStatistics().getRequestCount());
        }
        return requestCount;
    }

    public long getRequestCountByCompany(long companyId) throws MonitoringException {
        return this.getRequestStatistics(companyId).getRequestCount();
    }

    public long getRequestCountByCompany(String webId) throws MonitoringException {
        return this.getRequestStatistics(webId).getRequestCount();
    }

    public long getSuccessCount() {
        int successCount = 0;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            successCount = (int)((long)successCount + companyStatistics.getRequestStatistics().getSuccessCount());
        }
        return successCount;
    }

    public long getSuccessCountByCompany(long companyId) throws MonitoringException {
        return this.getRequestStatistics(companyId).getSuccessCount();
    }

    public long getSuccessCountByCompany(String webId) throws MonitoringException {
        return this.getRequestStatistics(webId).getSuccessCount();
    }

    public long getTimeoutCount() {
        int timeoutCount = 0;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            timeoutCount = (int)((long)timeoutCount + companyStatistics.getRequestStatistics().getTimeoutCount());
        }
        return timeoutCount;
    }

    public long getTimeoutCountByCompany(long companyId) throws MonitoringException {
        return this.getRequestStatistics(companyId).getTimeoutCount();
    }

    public long getTimeoutCountByCompany(String webId) throws MonitoringException {
        return this.getRequestStatistics(webId).getTimeoutCount();
    }

    public void setServerStatistics(ServerStatistics serverStatistics) {
        this._serverStatistics = serverStatistics;
    }

    protected RequestStatistics getRequestStatistics(long companyId) throws MonitoringException {
        try {
            CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
            return companyStatistics.getRequestStatistics();
        }
        catch (Exception e) {
            throw new MonitoringException("Unable to get company with company id " + companyId, (Throwable)e);
        }
    }

    protected RequestStatistics getRequestStatistics(String webId) throws MonitoringException {
        try {
            CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
            return companyStatistics.getRequestStatistics();
        }
        catch (Exception e) {
            throw new MonitoringException("Unable to get company with web id " + webId, (Throwable)e);
        }
    }
}

