/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeHelper;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.SpriteImage;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.ThemeSetting;
import com.liferay.portal.model.impl.PluginBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.theme.ThemeCompanyLimit;
import com.liferay.portal.theme.ThemeGroupLimit;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeImpl
extends PluginBaseImpl
implements Theme {
    private static Log _log = LogFactoryUtil.getLog(ThemeImpl.class);
    private Map<String, ColorScheme> _colorSchemesMap = new HashMap<String, ColorScheme>();
    private String _cssPath = "${root-path}/css";
    private String _imagesPath = "${root-path}/images";
    private String _javaScriptPath = "${root-path}/js";
    private boolean _loadFromServletContext;
    private String _name;
    private Map<String, Boolean> _resourceExistsMap = new ConcurrentHashMap<String, Boolean>();
    private Map<String, String> _resourcePathsMap = new ConcurrentHashMap<String, String>();
    private String _rootPath = "/";
    private String _servletContextName = "";
    private Map<String, ThemeSetting> _themeSettingsMap = new LinkedHashMap<String, ThemeSetting>();
    private Map<String, SpriteImage> _spriteImagesMap = new HashMap<String, SpriteImage>();
    private String _templateExtension = "vm";
    private String _templatesPath = "${root-path}/templates";
    private ThemeCompanyLimit _themeCompanyLimit;
    private ThemeGroupLimit _themeGroupLimit;
    private String _themeId;
    private long _timestamp;
    private String _virtualPath = "";
    private boolean _wapTheme;
    private boolean _warFile;

    public static String getDefaultRegularThemeId() {
        return PortalUtil.getJsSafePortletId((String)PropsValues.DEFAULT_REGULAR_THEME_ID);
    }

    public static String getDefaultRegularThemeId(long companyId) throws SystemException {
        String defaultRegularThemeId = PrefsPropsUtil.getString(companyId, "default.regular.theme.id");
        return PortalUtil.getJsSafePortletId((String)defaultRegularThemeId);
    }

    public static String getDefaultWapThemeId() {
        return PortalUtil.getJsSafePortletId((String)PropsValues.DEFAULT_WAP_THEME_ID);
    }

    public static String getDefaultWapThemeId(long companyId) throws SystemException {
        String defaultWapThemeId = PrefsPropsUtil.getString(companyId, "default.wap.theme.id");
        return PortalUtil.getJsSafePortletId((String)defaultWapThemeId);
    }

    public ThemeImpl() {
    }

    public ThemeImpl(String themeId) {
        this._themeId = themeId;
    }

    public ThemeImpl(String themeId, String name) {
        this._themeId = themeId;
        this._name = name;
    }

    public void addSetting(String key, String value, boolean configurable, String type, String[] options, String script) {
        ThemeSettingImpl themeSetting = new ThemeSettingImpl(configurable, options, script, type, value);
        this._themeSettingsMap.put(key, themeSetting);
    }

    public int compareTo(Theme theme) {
        return this.getName().compareTo(theme.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Theme theme = null;
        try {
            theme = (Theme)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        String themeId = theme.getThemeId();
        return this.getThemeId().equals(themeId);
    }

    public List<ColorScheme> getColorSchemes() {
        List colorSchemes = ListUtil.fromMapValues(this._colorSchemesMap);
        return ListUtil.sort((List)colorSchemes);
    }

    public Map<String, ColorScheme> getColorSchemesMap() {
        return this._colorSchemesMap;
    }

    public Map<String, ThemeSetting> getConfigurableSettings() {
        LinkedHashMap<String, ThemeSetting> configurableSettings = new LinkedHashMap<String, ThemeSetting>();
        for (Map.Entry<String, ThemeSetting> entry : this._themeSettingsMap.entrySet()) {
            ThemeSetting themeSetting = entry.getValue();
            if (!themeSetting.isConfigurable()) continue;
            configurableSettings.put(entry.getKey(), entry.getValue());
        }
        return configurableSettings;
    }

    public String getContextPath() {
        if (!this.isWARFile()) {
            return PortalUtil.getPathContext();
        }
        String servletContextName = this.getServletContextName();
        if (ServletContextPool.containsKey((String)servletContextName)) {
            ServletContext servletContext = ServletContextPool.get((String)servletContextName);
            return ContextPathUtil.getContextPath((ServletContext)servletContext);
        }
        return "/".concat(servletContextName);
    }

    public String getCssPath() {
        return this._cssPath;
    }

    public String getDevice() {
        if (this.isWapTheme()) {
            return "wap";
        }
        return "regular";
    }

    public String getFreeMarkerTemplateLoader() {
        if (this._loadFromServletContext) {
            return "_SERVLET_CONTEXT_";
        }
        return "_THEME_LOADER_CONTEXT_";
    }

    public String getImagesPath() {
        return this._imagesPath;
    }

    public String getJavaScriptPath() {
        return this._javaScriptPath;
    }

    public boolean getLoadFromServletContext() {
        return this._loadFromServletContext;
    }

    public String getName() {
        return this._name;
    }

    public String getPluginId() {
        return this.getThemeId();
    }

    public String getPluginType() {
        return "theme";
    }

    public String getResourcePath(ServletContext servletContext, String portletId, String path) {
        String resourcePath;
        if (!PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return ThemeHelper.getResourcePath((ServletContext)servletContext, (Theme)this, (String)portletId, (String)path);
        }
        String key = path;
        if (Validator.isNotNull((String)portletId)) {
            key = path.concat("#").concat(portletId);
        }
        if ((resourcePath = this._resourcePathsMap.get(key)) != null) {
            return resourcePath;
        }
        resourcePath = ThemeHelper.getResourcePath((ServletContext)servletContext, (Theme)this, (String)portletId, (String)path);
        this._resourcePathsMap.put(key, resourcePath);
        return resourcePath;
    }

    public String getRootPath() {
        return this._rootPath;
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public String getSetting(String key) {
        String value = null;
        ThemeSetting themeSetting = this._themeSettingsMap.get(key);
        if (themeSetting != null) {
            value = themeSetting.getValue();
        }
        return value;
    }

    public String[] getSettingOptions(String key) {
        String[] options = null;
        ThemeSetting themeSetting = this._themeSettingsMap.get(key);
        if (themeSetting != null) {
            options = themeSetting.getOptions();
        }
        return options;
    }

    public Map<String, ThemeSetting> getSettings() {
        return this._themeSettingsMap;
    }

    public Properties getSettingsProperties() {
        Properties properties = new Properties();
        for (String key : this._themeSettingsMap.keySet()) {
            ThemeSetting setting = this._themeSettingsMap.get(key);
            if (setting == null) continue;
            properties.setProperty(key, setting.getValue());
        }
        return properties;
    }

    public SpriteImage getSpriteImage(String fileName) {
        return this._spriteImagesMap.get(fileName);
    }

    public String getStaticResourcePath() {
        String proxyPath = PortalUtil.getPathProxy();
        String virtualPath = this.getVirtualPath();
        if (Validator.isNotNull((String)virtualPath)) {
            return proxyPath.concat(virtualPath);
        }
        String contextPath = this.getContextPath();
        if (!this.isWARFile()) {
            return contextPath;
        }
        return proxyPath.concat(contextPath);
    }

    public String getTemplateExtension() {
        return this._templateExtension;
    }

    public String getTemplatesPath() {
        return this._templatesPath;
    }

    public ThemeCompanyLimit getThemeCompanyLimit() {
        return this._themeCompanyLimit;
    }

    public ThemeGroupLimit getThemeGroupLimit() {
        return this._themeGroupLimit;
    }

    public String getThemeId() {
        return this._themeId;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public String getVelocityResourceListener() {
        if (this._loadFromServletContext) {
            return "_SERVLET_CONTEXT_";
        }
        return "_THEME_LOADER_CONTEXT_";
    }

    public String getVirtualPath() {
        return this._virtualPath;
    }

    public boolean getWapTheme() {
        return this._wapTheme;
    }

    public boolean getWARFile() {
        return this._warFile;
    }

    public boolean hasColorSchemes() {
        return this._colorSchemesMap.size() > 0;
    }

    public int hashCode() {
        return this._themeId.hashCode();
    }

    public boolean isCompanyAvailable(long companyId) {
        return this.isAvailable(this.getThemeCompanyLimit(), companyId);
    }

    public boolean isGroupAvailable(long groupId) {
        return this.isAvailable((ThemeCompanyLimit)this.getThemeGroupLimit(), groupId);
    }

    public boolean isLoadFromServletContext() {
        return this._loadFromServletContext;
    }

    public boolean isWapTheme() {
        return this._wapTheme;
    }

    public boolean isWARFile() {
        return this._warFile;
    }

    public boolean resourceExists(ServletContext servletContext, String portletId, String path) throws Exception {
        Boolean resourceExists;
        if (!PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return ThemeHelper.resourceExists((ServletContext)servletContext, (Theme)this, (String)portletId, (String)path);
        }
        String key = path;
        if (Validator.isNotNull((String)portletId)) {
            key = path.concat("#").concat(portletId);
        }
        if ((resourceExists = this._resourceExistsMap.get(key)) != null) {
            return resourceExists;
        }
        resourceExists = ThemeHelper.resourceExists((ServletContext)servletContext, (Theme)this, (String)portletId, (String)path);
        this._resourceExistsMap.put(key, resourceExists);
        return resourceExists;
    }

    public void setCssPath(String cssPath) {
        this._cssPath = cssPath;
    }

    public void setImagesPath(String imagesPath) {
        this._imagesPath = imagesPath;
    }

    public void setJavaScriptPath(String javaScriptPath) {
        this._javaScriptPath = javaScriptPath;
    }

    public void setLoadFromServletContext(boolean loadFromServletContext) {
        this._loadFromServletContext = loadFromServletContext;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRootPath(String rootPath) {
        this._rootPath = rootPath;
    }

    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
        this._warFile = Validator.isNotNull((String)this._servletContextName);
    }

    public void setSetting(String key, String value) {
        ThemeSetting themeSetting = this._themeSettingsMap.get(key);
        if (themeSetting != null) {
            themeSetting.setValue(value);
        } else {
            this.addSetting(key, value, false, null, null, null);
        }
    }

    public void setSpriteImages(String spriteFileName, Properties spriteProperties) {
        for (Map.Entry<Object, Object> entry : spriteProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int[] values = StringUtil.split((String)value, (int)0);
            int offset = values[0];
            int height = values[1];
            int width = values[2];
            SpriteImage spriteImage = new SpriteImage(spriteFileName, key, offset, height, width);
            this._spriteImagesMap.put(key, spriteImage);
        }
    }

    public void setTemplateExtension(String templateExtension) {
        this._templateExtension = templateExtension;
    }

    public void setTemplatesPath(String templatesPath) {
        this._templatesPath = templatesPath;
    }

    public void setThemeCompanyLimit(ThemeCompanyLimit themeCompanyLimit) {
        this._themeCompanyLimit = themeCompanyLimit;
    }

    public void setThemeGroupLimit(ThemeGroupLimit themeGroupLimit) {
        this._themeGroupLimit = themeGroupLimit;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public void setVirtualPath(String virtualPath) {
        if (this._warFile && Validator.isNull((String)virtualPath)) {
            virtualPath = PropsValues.THEME_VIRTUAL_PATH;
        }
        this._virtualPath = virtualPath;
    }

    public void setWapTheme(boolean wapTheme) {
        this._wapTheme = wapTheme;
    }

    protected boolean isAvailable(ThemeCompanyLimit limit, long id) {
        boolean available = true;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Check if theme " + this.getThemeId() + " is available for " + id));
        }
        if (limit != null) {
            List includes = limit.getIncludes();
            List excludes = limit.getExcludes();
            if (includes.size() != 0 && excludes.size() != 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check includes and excludes");
                }
                if (available = limit.isIncluded(id)) {
                    available = !limit.isExcluded(id);
                }
            } else if (includes.size() == 0 && excludes.size() != 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check excludes");
                }
                available = !limit.isExcluded(id);
            } else if (includes.size() != 0 && excludes.size() == 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check includes");
                }
                available = limit.isIncluded(id);
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"No includes or excludes set");
                }
                available = true;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Theme " + this.getThemeId() + " is " + (!available ? "NOT " : "") + "available for " + id));
        }
        return available;
    }
}

