/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.impl.PluginBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutTemplateImpl
extends PluginBaseImpl
implements LayoutTemplate {
    private static Log _log = LogFactoryUtil.getLog(LayoutTemplateImpl.class);
    private String _layoutTemplateId;
    private boolean _standard;
    private String _themeId;
    private String _name;
    private String _templatePath;
    private String _wapTemplatePath;
    private String _thumbnailPath;
    private String _content;
    private boolean _setContent;
    private String _wapContent;
    private boolean _setWapContent;
    private List<String> _columns = new ArrayList<String>();
    private transient ServletContext _servletContext;
    private String _servletContextName = "";
    private boolean _warFile;

    public LayoutTemplateImpl() {
    }

    public LayoutTemplateImpl(String layoutTemplateId) {
        this._layoutTemplateId = layoutTemplateId;
    }

    public LayoutTemplateImpl(String layoutTemplateId, String name) {
        this._layoutTemplateId = layoutTemplateId;
        this._name = name;
    }

    public String getLayoutTemplateId() {
        return this._layoutTemplateId;
    }

    public String getPluginId() {
        return this.getLayoutTemplateId();
    }

    public String getPluginType() {
        return "layout-template";
    }

    public boolean getStandard() {
        return this._standard;
    }

    public boolean isStandard() {
        return this._standard;
    }

    public void setStandard(boolean standard) {
        this._standard = standard;
    }

    public String getThemeId() {
        return this._themeId;
    }

    public void setThemeId(String themeId) {
        this._themeId = themeId;
    }

    public String getName() {
        if (Validator.isNull((String)this._name)) {
            return this._layoutTemplateId;
        }
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getTemplatePath() {
        return this._templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this._templatePath = templatePath;
    }

    public String getWapTemplatePath() {
        return this._wapTemplatePath;
    }

    public void setWapTemplatePath(String wapTemplatePath) {
        this._wapTemplatePath = wapTemplatePath;
    }

    public String getThumbnailPath() {
        return this._thumbnailPath;
    }

    public void setThumbnailPath(String thumbnailPath) {
        this._thumbnailPath = thumbnailPath;
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        this._setContent = true;
        this._content = content;
    }

    public boolean hasSetContent() {
        return this._setContent;
    }

    public String getUncachedContent() throws IOException {
        if (this._servletContext == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Cannot get latest content for " + this._servletContextName + " " + this.getTemplatePath() + " because the servlet context is null"));
            }
            return this._content;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Getting latest content for " + this._servletContextName + " " + this.getTemplatePath()));
        }
        String content = HttpUtil.URLtoString((URL)this._servletContext.getResource(this.getTemplatePath()));
        this.setContent(content);
        return content;
    }

    public String getWapContent() {
        return this._wapContent;
    }

    public void setWapContent(String wapContent) {
        this._setWapContent = true;
        this._wapContent = wapContent;
    }

    public boolean hasSetWapContent() {
        return this._setWapContent;
    }

    public String getUncachedWapContent() {
        if (this._servletContext == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Cannot get latest WAP content for " + this._servletContextName + " " + this.getWapTemplatePath() + " because the servlet context is null"));
            }
            return this._wapContent;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Getting latest WAP content for " + this._servletContextName + " " + this.getWapTemplatePath()));
        }
        String wapContent = null;
        try {
            wapContent = HttpUtil.URLtoString((URL)this._servletContext.getResource(this.getWapTemplatePath()));
        }
        catch (Exception e) {
            _log.error((Object)("Unable to get content at WAP template path " + this.getWapTemplatePath() + ": " + e.getMessage()));
        }
        this.setWapContent(wapContent);
        return wapContent;
    }

    public List<String> getColumns() {
        return this._columns;
    }

    public void setColumns(List<String> columns) {
        this._columns = columns;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
        this._warFile = Validator.isNotNull((String)this._servletContextName);
    }

    public boolean getWARFile() {
        return this._warFile;
    }

    public boolean isWARFile() {
        return this._warFile;
    }

    public String getContextPath() {
        if (!this.isWARFile()) {
            return PortalUtil.getPathContext();
        }
        String servletContextName = this.getServletContextName();
        if (ServletContextPool.containsKey((String)servletContextName)) {
            ServletContext servletContext = ServletContextPool.get((String)servletContextName);
            return ContextPathUtil.getContextPath((ServletContext)servletContext);
        }
        return "/".concat(servletContextName);
    }

    public String getStaticResourcePath() {
        String proxyPath = PortalUtil.getPathProxy();
        String contextPath = this.getContextPath();
        if (!this.isWARFile()) {
            return contextPath;
        }
        return proxyPath.concat(contextPath);
    }

    public int compareTo(LayoutTemplate layoutTemplate) {
        if (layoutTemplate == null) {
            return -1;
        }
        return this.getName().compareTo(layoutTemplate.getName());
    }

    public boolean equals(LayoutTemplate layoutTemplate) {
        if (layoutTemplate == null) {
            return false;
        }
        String layoutTemplateId = layoutTemplate.getLayoutTemplateId();
        return this.getLayoutTemplateId().equals(layoutTemplateId);
    }
}

