/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.model.impl.LayoutSetBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.IOException;

public class LayoutSetImpl
extends LayoutSetBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetImpl.class);
    private UnicodeProperties _settingsProperties;

    public Theme getTheme() throws SystemException {
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId(), (boolean)false);
    }

    public ColorScheme getColorScheme() throws SystemException {
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getTheme().getThemeId(), (String)this.getColorSchemeId(), (boolean)false);
    }

    public Group getGroup() throws PortalException, SystemException {
        return GroupLocalServiceUtil.getGroup((long)this.getGroupId());
    }

    public String getSettings() {
        if (this._settingsProperties == null) {
            return super.getSettings();
        }
        return this._settingsProperties.toString();
    }

    public UnicodeProperties getSettingsProperties() {
        if (this._settingsProperties == null) {
            this._settingsProperties = new UnicodeProperties(true);
            try {
                this._settingsProperties.load(super.getSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._settingsProperties;
    }

    public String getSettingsProperty(String key) {
        UnicodeProperties settingsProperties = this.getSettingsProperties();
        return settingsProperties.getProperty(key);
    }

    public String getThemeSetting(String key, String device) throws SystemException {
        UnicodeProperties settingsProperties = this.getSettingsProperties();
        String value = settingsProperties.getProperty(ThemeSettingImpl.namespaceProperty(device, key));
        if (value != null) {
            return value;
        }
        Theme theme = null;
        boolean controlPanel = false;
        try {
            Group group = this.getGroup();
            controlPanel = group.isControlPanel();
        }
        catch (Exception exception) {}
        if (controlPanel) {
            String themeId = PrefsPropsUtil.getString(this.getCompanyId(), "control.panel.layout.regular.theme.id");
            theme = ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)themeId, (!device.equals("regular") ? 1 : 0) != 0);
        } else {
            theme = device.equals("regular") ? this.getTheme() : this.getWapTheme();
        }
        value = theme.getSetting(key);
        return value;
    }

    public String getVirtualHostname() {
        VirtualHost virtualHost;
        block3: {
            try {
                virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((long)this.getCompanyId(), (long)this.getLayoutSetId());
                if (virtualHost != null) break block3;
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        return virtualHost.getHostname();
    }

    public Theme getWapTheme() throws SystemException {
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getWapThemeId(), (boolean)true);
    }

    public ColorScheme getWapColorScheme() throws SystemException {
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getWapTheme().getThemeId(), (String)this.getWapColorSchemeId(), (boolean)true);
    }

    public boolean isLayoutSetPrototypeLinkActive() {
        return this.isLayoutSetPrototypeLinkEnabled() && Validator.isNotNull((String)this.getLayoutSetPrototypeUuid());
    }

    public void setSettings(String settings) {
        this._settingsProperties = null;
        super.setSettings(settings);
    }

    public void setSettingsProperties(UnicodeProperties settingsProperties) {
        this._settingsProperties = settingsProperties;
        super.setSettings(this._settingsProperties.toString());
    }
}

