/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Shard;
import com.liferay.portal.model.User;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.model.impl.CompanyBaseImpl;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.service.AccountLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ShardLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.security.Key;
import java.util.Locale;
import java.util.TimeZone;

public class CompanyImpl
extends CompanyBaseImpl {
    private Key _keyObj;

    public int compareTo(Company company) {
        String webId1 = this.getWebId();
        String webId2 = company.getWebId();
        if (webId1.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            return -1;
        }
        if (webId2.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            return 1;
        }
        return webId1.compareTo(webId2);
    }

    public Account getAccount() throws PortalException, SystemException {
        return AccountLocalServiceUtil.getAccount((long)this.getCompanyId(), (long)this.getAccountId());
    }

    public String getAdminName() {
        return "Administrator";
    }

    public String getAuthType() throws SystemException {
        return PrefsPropsUtil.getString(this.getCompanyId(), "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
    }

    public User getDefaultUser() throws PortalException, SystemException {
        return UserLocalServiceUtil.getDefaultUser((long)this.getCompanyId());
    }

    public String getDefaultWebId() {
        return PropsValues.COMPANY_DEFAULT_WEB_ID;
    }

    public String getEmailAddress() {
        return "admin@" + this.getMx();
    }

    public Group getGroup() throws PortalException, SystemException {
        if (this.getCompanyId() > 0L) {
            return GroupLocalServiceUtil.getCompanyGroup((long)this.getCompanyId());
        }
        return new GroupImpl();
    }

    public Key getKeyObj() {
        String key;
        if (this._keyObj == null && Validator.isNotNull((String)(key = this.getKey()))) {
            this._keyObj = (Key)Base64.stringToObjectSilent((String)key);
        }
        return this._keyObj;
    }

    public Locale getLocale() throws PortalException, SystemException {
        return this.getDefaultUser().getLocale();
    }

    public String getName() throws PortalException, SystemException {
        return this.getAccount().getName();
    }

    public String getPortalURL(long groupId) throws PortalException, SystemException {
        LayoutSet layoutSet;
        String portalURL = PortalUtil.getPortalURL((String)this.getVirtualHostname(), (int)80, (boolean)false);
        if (groupId <= 0L) {
            return portalURL;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.hasPublicLayouts()) {
            LayoutSet layoutSet2 = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)false);
            if (Validator.isNotNull((String)layoutSet2.getVirtualHostname())) {
                portalURL = PortalUtil.getPortalURL((String)layoutSet2.getVirtualHostname(), (int)80, (boolean)false);
            }
        } else if (group.hasPrivateLayouts() && Validator.isNotNull((String)(layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)true)).getVirtualHostname())) {
            portalURL = PortalUtil.getPortalURL((String)layoutSet.getVirtualHostname(), (int)80, (boolean)false);
        }
        return portalURL;
    }

    public String getShardName() throws PortalException, SystemException {
        Shard shard = ShardLocalServiceUtil.getShard((String)Company.class.getName(), (long)this.getCompanyId());
        return shard.getName();
    }

    public String getShortName() throws PortalException, SystemException {
        return this.getName();
    }

    public TimeZone getTimeZone() throws PortalException, SystemException {
        return this.getDefaultUser().getTimeZone();
    }

    public String getVirtualHostname() {
        VirtualHost virtualHost;
        block3: {
            try {
                virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((long)this.getCompanyId(), (long)0L);
                if (virtualHost != null) break block3;
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        return virtualHost.getHostname();
    }

    public boolean hasCompanyMx(String emailAddress) throws SystemException {
        int pos = (emailAddress = emailAddress.trim().toLowerCase()).indexOf(64);
        if (pos == -1) {
            return false;
        }
        String mx = emailAddress.substring(pos + 1, emailAddress.length());
        if (mx.equals(this.getMx())) {
            return true;
        }
        String[] mailHostNames = PrefsPropsUtil.getStringArray(this.getCompanyId(), "admin.mail.host.names", "\n", PropsValues.ADMIN_MAIL_HOST_NAMES);
        int i = 0;
        while (i < mailHostNames.length) {
            if (mx.equalsIgnoreCase(mailHostNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isAutoLogin() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.auto.login", PropsValues.COMPANY_SECURITY_AUTO_LOGIN);
    }

    public boolean isSendPassword() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.send.password", PropsValues.COMPANY_SECURITY_SEND_PASSWORD);
    }

    public boolean isSendPasswordResetLink() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.send.password.reset.link", PropsValues.COMPANY_SECURITY_SEND_PASSWORD_RESET_LINK);
    }

    public boolean isSiteLogo() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.site.logo", PropsValues.COMPANY_SECURITY_SITE_LOGO);
    }

    public boolean isStrangers() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.strangers", PropsValues.COMPANY_SECURITY_STRANGERS);
    }

    public boolean isStrangersVerify() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.strangers.verify", PropsValues.COMPANY_SECURITY_STRANGERS_VERIFY);
    }

    public boolean isStrangersWithMx() throws SystemException {
        return PrefsPropsUtil.getBoolean(this.getCompanyId(), "company.security.strangers.with.mx", PropsValues.COMPANY_SECURITY_STRANGERS_WITH_MX);
    }

    public void setKey(String key) {
        this._keyObj = null;
        super.setKey(key);
    }

    public void setKeyObj(Key keyObj) {
        this._keyObj = keyObj;
    }
}

