/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.model.ModelHints;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.PwdGenerator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelHintsImpl
implements ModelHints {
    private static final String _ELEMENTS_SUFFIX = "_ELEMENTS";
    private static final String _HINTS_SUFFIX = "_HINTS";
    private static final String _LOCALIZATION_SUFFIX = "_LOCALIZATION";
    private static final String _SANITIZE_SUFFIX = "_SANITIZE_SUFFIX";
    private static final String _TYPE_SUFFIX = "_TYPE";
    private static final String _VALIDATORS_SUFFIX = "_VALIDATORS";
    private static Log _log = LogFactoryUtil.getLog(ModelHintsImpl.class);
    private Map<String, Map<String, String>> _defaultHints;
    private Map<String, Map<String, String>> _hintCollections;
    private Map<String, Object> _modelFields;
    private Set<String> _models;
    private SAXReader _saxReader;

    public void afterPropertiesSet() {
        this._hintCollections = new HashMap<String, Map<String, String>>();
        this._defaultHints = new HashMap<String, Map<String, String>>();
        this._modelFields = new HashMap<String, Object>();
        this._models = new TreeSet<String>();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String[] configs = StringUtil.split((String)PropsUtil.get("model.hints.configs"));
            int i = 0;
            while (i < configs.length) {
                this.read(classLoader, configs[i]);
                ++i;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public String buildCustomValidatorName(String validatorName) {
        return validatorName.concat("_").concat(PwdGenerator.getPassword((String)PwdGenerator.KEY3, (int)4));
    }

    public Map<String, String> getDefaultHints(String model) {
        return this._defaultHints.get(model);
    }

    public Element getFieldsEl(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        Element fieldsEl = (Element)fields.get(String.valueOf(field) + _ELEMENTS_SUFFIX);
        if (fieldsEl == null) {
            return null;
        }
        return fieldsEl;
    }

    public Map<String, String> getHints(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        return (Map)fields.get(String.valueOf(field) + _HINTS_SUFFIX);
    }

    public List<String> getModels() {
        return ListUtil.fromCollection(this._models);
    }

    public Tuple getSanitizeTuple(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        return (Tuple)fields.get(String.valueOf(field) + _SANITIZE_SUFFIX);
    }

    public List<Tuple> getSanitizeTuples(String model) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> sanitizeTuples = new ArrayList<Tuple>();
        for (Map.Entry entry : fields.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(_SANITIZE_SUFFIX)) continue;
            Tuple sanitizeTuple = (Tuple)entry.getValue();
            sanitizeTuples.add(sanitizeTuple);
        }
        return sanitizeTuples;
    }

    public String getType(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return null;
        }
        return (String)fields.get(String.valueOf(field) + _TYPE_SUFFIX);
    }

    public List<Tuple> getValidators(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null || fields.get(String.valueOf(field) + _VALIDATORS_SUFFIX) == null) {
            return null;
        }
        return (List)fields.get(String.valueOf(field) + _VALIDATORS_SUFFIX);
    }

    public boolean isCustomValidator(String validatorName) {
        return validatorName.equals("custom");
    }

    public boolean isLocalized(String model, String field) {
        Map fields = (Map)this._modelFields.get(model);
        if (fields == null) {
            return false;
        }
        Boolean localized = (Boolean)fields.get(String.valueOf(field) + _LOCALIZATION_SUFFIX);
        if (localized != null) {
            return localized;
        }
        return false;
    }

    public void read(ClassLoader classLoader, String source) throws Exception {
        String name;
        InputStream is = classLoader.getResourceAsStream(source);
        if (is == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Cannot load " + source));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        Document doc = this._saxReader.read(is);
        Element root = doc.getRootElement();
        for (Element hintCollection : root.elements("hint-collection")) {
            name = hintCollection.attributeValue("name");
            Map<String, String> hints = this._hintCollections.get(name);
            if (hints == null) {
                hints = new HashMap<String, String>();
                this._hintCollections.put(name, hints);
            }
            for (Element hint : hintCollection.elements("hint")) {
                String hintName = hint.attributeValue("name");
                String hintValue = hint.getText();
                hints.put(hintName, hintValue);
            }
        }
        for (Element model : root.elements("model")) {
            LinkedHashMap<String, Object> fields;
            name = model.attributeValue("name");
            if (classLoader != ModelHintsImpl.class.getClassLoader()) {
                ClassNameLocalServiceUtil.getClassName((String)name);
            }
            HashMap<String, String> defaultHints = new HashMap<String, String>();
            this._defaultHints.put(name, defaultHints);
            Element defaultHintsEl = model.element("default-hints");
            if (defaultHintsEl != null) {
                for (Element hint : defaultHintsEl.elements("hint")) {
                    String hintName = hint.attributeValue("name");
                    String hintValue = hint.getText();
                    defaultHints.put(hintName, hintValue);
                }
            }
            if ((fields = (LinkedHashMap<String, Object>)this._modelFields.get(name)) == null) {
                fields = new LinkedHashMap<String, Object>();
                this._modelFields.put(name, fields);
            }
            this._models.add(name);
            for (Element field : model.elements("field")) {
                String fieldName = field.attributeValue("name");
                String fieldType = field.attributeValue("type");
                boolean fieldLocalized = GetterUtil.getBoolean((String)field.attributeValue("localized"));
                HashMap<String, String> fieldHints = new HashMap<String, String>();
                fieldHints.putAll(defaultHints);
                for (Element hintCollection : field.elements("hint-collection")) {
                    Map<String, String> hints = this._hintCollections.get(hintCollection.attributeValue("name"));
                    fieldHints.putAll(hints);
                }
                for (Element hint : field.elements("hint")) {
                    String hintName = hint.attributeValue("name");
                    String hintValue = hint.getText();
                    fieldHints.put(hintName, hintValue);
                }
                Tuple fieldSanitize = null;
                Element sanitize = field.element("sanitize");
                if (sanitize != null) {
                    String contentType = sanitize.attributeValue("content-type");
                    String modes = sanitize.attributeValue("modes");
                    fieldSanitize = new Tuple(new Object[]{fieldName, contentType, modes});
                }
                TreeMap<String, Tuple> fieldValidators = new TreeMap<String, Tuple>();
                for (Element validator : field.elements("validator")) {
                    String validatorName = validator.attributeValue("name");
                    if (Validator.isNull((String)validatorName)) continue;
                    String validatorErrorMessage = GetterUtil.getString((String)validator.attributeValue("error-message"));
                    String validatorValue = GetterUtil.getString((String)validator.getText());
                    boolean customValidator = this.isCustomValidator(validatorName);
                    if (customValidator) {
                        validatorName = this.buildCustomValidatorName(validatorName);
                    }
                    Tuple fieldValidator = new Tuple(new Object[]{fieldName, validatorName, validatorErrorMessage, validatorValue, customValidator});
                    fieldValidators.put(validatorName, fieldValidator);
                }
                fields.put(String.valueOf(fieldName) + _ELEMENTS_SUFFIX, field);
                fields.put(String.valueOf(fieldName) + _TYPE_SUFFIX, fieldType);
                fields.put(String.valueOf(fieldName) + _LOCALIZATION_SUFFIX, fieldLocalized);
                fields.put(String.valueOf(fieldName) + _HINTS_SUFFIX, fieldHints);
                if (fieldSanitize != null) {
                    fields.put(String.valueOf(fieldName) + _SANITIZE_SUFFIX, fieldSanitize);
                }
                if (fieldValidators.isEmpty()) continue;
                fields.put(String.valueOf(fieldName) + _VALIDATORS_SUFFIX, ListUtil.fromMapValues(fieldValidators));
            }
        }
    }

    public void setSAXReader(SAXReader saxReader) {
        this._saxReader = saxReader;
    }

    public String trimString(String model, String field, String value) {
        if (value == null) {
            return value;
        }
        Map<String, String> hints = this.getHints(model, field);
        if (hints == null) {
            return value;
        }
        int maxLength = GetterUtil.getInteger((String)"75");
        maxLength = GetterUtil.getInteger((String)hints.get("max-length"), (int)maxLength);
        if (value.length() > maxLength) {
            return value.substring(0, maxLength);
        }
        return value;
    }
}

