/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.rulegroup.rule.impl;

import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.rulegroup.rule.RuleHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRuleHandler
implements RuleHandler {
    private static Collection<String> _propertyNames = new ArrayList<String>(2);

    static {
        _propertyNames.add("os");
        _propertyNames.add("tablet");
        _propertyNames = Collections.unmodifiableCollection(_propertyNames);
    }

    public static String getHandlerType() {
        return SimpleRuleHandler.class.getName();
    }

    public boolean evaluateRule(MDRRule mdrRule, ThemeDisplay themeDisplay) {
        String tablet;
        Device device = themeDisplay.getDevice();
        if (device == null) {
            return false;
        }
        UnicodeProperties typeSettingsProperties = mdrRule.getTypeSettingsProperties();
        boolean result = true;
        String os = (String)typeSettingsProperties.get((Object)"os");
        if (Validator.isNotNull((String)os)) {
            result = os.equals(device.getOS());
        }
        if (Validator.isNotNull((String)(tablet = (String)typeSettingsProperties.get((Object)"tablet")))) {
            boolean tabletBoolean = GetterUtil.getBoolean((String)tablet);
            result = result && tabletBoolean == device.isTablet();
        }
        return result;
    }

    public Collection<String> getPropertyNames() {
        return _propertyNames;
    }

    public String getType() {
        return SimpleRuleHandler.getHandlerType();
    }
}

