/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.rulegroup.action.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.mobile.device.rulegroup.action.impl.BaseRedirectActionHandler;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.GroupLocalService;
import com.liferay.portal.service.LayoutLocalService;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteRedirectActionHandler
extends BaseRedirectActionHandler {
    private static Log _log = LogFactoryUtil.getLog(SiteRedirectActionHandler.class);
    private static Collection<String> _propertyNames = new ArrayList<String>(2);
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=LayoutLocalService.class)
    private LayoutLocalService _layoutLocalService;

    static {
        _propertyNames.add("groupId");
        _propertyNames.add("plid");
        _propertyNames = Collections.unmodifiableCollection(_propertyNames);
    }

    public static String getHandlerType() {
        return SiteRedirectActionHandler.class.getName();
    }

    public Collection<String> getPropertyNames() {
        return _propertyNames;
    }

    public String getType() {
        return SiteRedirectActionHandler.getHandlerType();
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    public void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Override
    protected String getURL(MDRAction mdrAction, HttpServletRequest request, HttpServletResponse response) throws PortalException, SystemException {
        ThemeDisplay themeDisplay;
        Layout themeDisplayLayout;
        UnicodeProperties typeSettingsProperties = mdrAction.getTypeSettingsProperties();
        long plid = GetterUtil.getLong((String)typeSettingsProperties.getProperty("plid"));
        if (plid == (themeDisplayLayout = (themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY")).getLayout()).getPlid()) {
            return null;
        }
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        long groupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("groupId"));
        if (layout != null && layout.getGroupId() != groupId) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Layout " + layout.getPlid() + " does not belong to group " + groupId));
            }
            layout = null;
        }
        if (layout == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Using default public layout");
            }
            Group group = null;
            if (groupId != themeDisplayLayout.getGroupId()) {
                group = this._groupLocalService.fetchGroup(groupId);
            }
            if (group == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No group found with group ID " + groupId));
                }
                return null;
            }
            layout = LayoutLocalServiceUtil.fetchLayout((long)group.getDefaultPublicPlid());
        }
        if (layout != null) {
            return PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to resolve default layout");
        }
        return null;
    }
}

