/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.proxy;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.proxy.BaseMultiDestinationProxyBean;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.messaging.proxy.ProxyResponse;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.util.aspectj.AspectJUtil;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;

public class MultiDestinationMessagingProxyAdvice {
    public Object invoke(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Message message = new Message();
        ProxyRequest proxyRequest = this.createProxyRequest(proceedingJoinPoint);
        message.setPayload((Object)proxyRequest);
        Map<String, Object> messageValues = MessageValuesThreadLocal.getValues();
        if (!messageValues.isEmpty()) {
            for (String key : messageValues.keySet()) {
                message.put(key, messageValues.get(key));
            }
        }
        BaseMultiDestinationProxyBean baseMultiDestinationProxyBean = (BaseMultiDestinationProxyBean)proceedingJoinPoint.getTarget();
        String destinationName = baseMultiDestinationProxyBean.getDestinationName(proxyRequest);
        if (proxyRequest.isSynchronous() || ProxyModeThreadLocal.isForceSync()) {
            return this.doInvokeSynchronous(message, baseMultiDestinationProxyBean, destinationName);
        }
        this.doInvokeAsynchronous(message, baseMultiDestinationProxyBean, destinationName);
        return null;
    }

    protected ProxyRequest createProxyRequest(ProceedingJoinPoint proceedingJoinPoint) throws Exception {
        return new ProxyRequest(AspectJUtil.getMethod((ProceedingJoinPoint)proceedingJoinPoint), proceedingJoinPoint.getArgs());
    }

    protected void doInvokeAsynchronous(Message message, BaseMultiDestinationProxyBean baseMultiDestinationProxyBean, String destinationName) {
        MessageSender messageSender = baseMultiDestinationProxyBean.getMessageSender();
        if (messageSender == null) {
            throw new IllegalStateException("Asynchronous message sender was not configured properly for " + baseMultiDestinationProxyBean.getClass().getName());
        }
        messageSender.send(destinationName, message);
    }

    protected Object doInvokeSynchronous(Message message, BaseMultiDestinationProxyBean baseMultiDestinationProxyBean, String destinationName) throws Exception {
        SynchronousMessageSender synchronousMessageSender = baseMultiDestinationProxyBean.getSynchronousMessageSender();
        if (synchronousMessageSender == null) {
            throw new IllegalStateException("Synchronous message sender was not configured properly for " + baseMultiDestinationProxyBean.getClass().getName());
        }
        ProxyResponse proxyResponse = (ProxyResponse)synchronousMessageSender.send(destinationName, message);
        if (proxyResponse == null) {
            return null;
        }
        if (proxyResponse.hasError()) {
            throw proxyResponse.getException();
        }
        return proxyResponse.getResult();
    }
}

