/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.proxy;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageValuesThreadLocal {
    private static ThreadLocal<Map<String, Object>> _messageValuesThreadLocal = new AutoResetThreadLocal(MessageValuesThreadLocal.class.getName());

    public static Object getValue(String key) {
        Map<String, Object> messageValues = _messageValuesThreadLocal.get();
        if (messageValues == null) {
            return null;
        }
        return messageValues.get(key);
    }

    public static Map<String, Object> getValues() {
        Map<String, Object> messageValues = _messageValuesThreadLocal.get();
        if (messageValues == null) {
            return Collections.EMPTY_MAP;
        }
        return messageValues;
    }

    public static void setValue(String key, Object value) {
        Map<String, Object> messageValues = _messageValuesThreadLocal.get();
        if (messageValues == null) {
            messageValues = new HashMap<String, Object>();
            _messageValuesThreadLocal.set(messageValues);
        }
        messageValues.put(key, value);
    }
}

