/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.NoSuchTeamException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionImporter {
    private static Log _log = LogFactoryUtil.getLog(PermissionImporter.class);

    protected List<String> getActions(Element element) {
        ArrayList<String> actions = new ArrayList<String>();
        List actionKeyElements = element.elements("action-key");
        for (Element actionKeyElement : actionKeyElements) {
            actions.add(actionKeyElement.getText());
        }
        return actions;
    }

    protected void importGroupPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentElement, String elementName, boolean portletActions) throws Exception {
        Element actionElement = parentElement.element(elementName);
        if (actionElement == null) {
            return;
        }
        List<String> actions = this.getActions(actionElement);
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        PermissionLocalServiceUtil.setGroupPermissions((long)groupId, (String[])actions.toArray(new String[actions.size()]), (long)resource.getResourceId());
    }

    protected void importGroupRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentElement) throws Exception {
        Element entityRolesElement = parentElement.element(String.valueOf(entityName) + "-roles");
        if (entityRolesElement == null) {
            return;
        }
        this.importRolePermissions(layoutCache, companyId, resourceName, 2, String.valueOf(groupId), entityRolesElement, true);
    }

    protected void importInheritedPermissions(LayoutCache layoutCache, long companyId, String resourceName, String resourcePrimKey, Element permissionsElement, String entityName, boolean portletActions) throws Exception {
        Element entityPermissionsElement = permissionsElement.element(String.valueOf(entityName) + "-permissions");
        if (entityPermissionsElement == null) {
            return;
        }
        List actionsElements = entityPermissionsElement.elements(String.valueOf(entityName) + "-actions");
        int i = 0;
        while (i < actionsElements.size()) {
            Element actionElement = (Element)actionsElements.get(i);
            String name = actionElement.attributeValue("name");
            long entityGroupId = layoutCache.getEntityGroupId(companyId, entityName, name);
            if (entityGroupId == 0L) {
                _log.warn((Object)("Ignore inherited permissions for entity " + entityName + " with name " + name));
            } else {
                Element parentElement = SAXReaderUtil.createElement((String)"parent");
                parentElement.add(actionElement.createCopy());
                this.importGroupPermissions(layoutCache, companyId, entityGroupId, resourceName, resourcePrimKey, parentElement, String.valueOf(entityName) + "-actions", portletActions);
            }
            ++i;
        }
    }

    protected void importInheritedRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentElement) throws Exception {
        Element entityRolesElement = parentElement.element(String.valueOf(entityName) + "-roles");
        if (entityRolesElement == null) {
            return;
        }
        List entityElements = entityRolesElement.elements(entityName);
        for (Element entityElement : entityElements) {
            String name = entityElement.attributeValue("name");
            long entityGroupId = layoutCache.getEntityGroupId(companyId, entityName, name);
            if (entityGroupId == 0L) {
                _log.warn((Object)("Ignore inherited roles for entity " + entityName + " with name " + name));
                continue;
            }
            this.importRolePermissions(layoutCache, companyId, resourceName, 2, String.valueOf(groupId), entityElement, false);
        }
    }

    protected void importLayoutPermissions(LayoutCache layoutCache, long companyId, long groupId, long userId, Layout layout, Element layoutElement, Element parentElement, boolean importUserPermissions) throws Exception {
        Element permissionsElement = layoutElement.element("permissions");
        if (permissionsElement != null) {
            String resourceName = Layout.class.getName();
            String resourcePrimKey = String.valueOf(layout.getPlid());
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                this.importPermissions_5(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsElement, false);
            } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.importPermissions_6(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsElement, false);
            } else {
                Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
                this.importLayoutPermissions_1to4(layoutCache, companyId, groupId, guestGroup, layout, resourceName, resourcePrimKey, permissionsElement, importUserPermissions);
            }
        }
        Element rolesElement = parentElement.element("roles");
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5 && rolesElement != null) {
            this.importLayoutRoles(layoutCache, companyId, groupId, rolesElement);
        }
    }

    protected void importLayoutPermissions_1to4(LayoutCache layoutCache, long companyId, long groupId, Group guestGroup, Layout layout, String resourceName, String resourcePrimKey, Element permissionsElement, boolean importUserPermissions) throws Exception {
        this.importGroupPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement, "community-actions", false);
        if (groupId != guestGroup.getGroupId()) {
            this.importGroupPermissions(layoutCache, companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, permissionsElement, "guest-actions", false);
        }
        if (importUserPermissions) {
            this.importUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement, false);
        }
        this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsElement, "organization", false);
        this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsElement, "user-group", false);
    }

    protected void importLayoutRoles(LayoutCache layoutCache, long companyId, long groupId, Element rolesElement) throws Exception {
        String resourceName = Layout.class.getName();
        this.importGroupRoles(layoutCache, companyId, groupId, resourceName, "community", rolesElement);
        this.importUserRoles(layoutCache, companyId, groupId, resourceName, rolesElement);
        this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", rolesElement);
        this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", rolesElement);
    }

    protected void importPermissions_5(LayoutCache layoutCache, long companyId, long groupId, long userId, String resourceName, String resourcePrimKey, Element permissionsElement, boolean portletActions) throws Exception {
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        List roleElements = permissionsElement.elements("role");
        for (Element roleElement : roleElements) {
            String description;
            String name = roleElement.attributeValue("name");
            Role role = null;
            if (name.startsWith("ROLE_TEAM_,*")) {
                name = name.substring("ROLE_TEAM_,*".length());
                description = roleElement.attributeValue("description");
                Team team = null;
                try {
                    team = TeamLocalServiceUtil.getTeam((long)groupId, (String)name);
                }
                catch (NoSuchTeamException noSuchTeamException) {
                    team = TeamLocalServiceUtil.addTeam((long)userId, (long)groupId, (String)name, (String)description);
                }
                role = RoleLocalServiceUtil.getTeamRole((long)companyId, (long)team.getTeamId());
            } else {
                role = layoutCache.getRole(companyId, name);
            }
            if (role == null) {
                description = roleElement.attributeValue("description");
                Map descriptionMap = LocalizationUtil.getLocalizationMap((String)description);
                int type = Integer.valueOf(roleElement.attributeValue("type"));
                role = RoleLocalServiceUtil.addRole((long)userId, (long)companyId, (String)name, null, (Map)descriptionMap, (int)type);
            }
            List<String> actions = this.getActions(roleElement);
            roleIdsToActionIds.put(role.getRoleId(), actions.toArray(new String[actions.size()]));
        }
        if (roleIdsToActionIds.isEmpty()) {
            return;
        }
        PermissionLocalServiceUtil.setRolesPermissions((long)companyId, roleIdsToActionIds, (String)resourceName, (int)4, (String)resourcePrimKey);
    }

    protected void importPermissions_6(LayoutCache layoutCache, long companyId, long groupId, long userId, String resourceName, String resourcePrimKey, Element permissionsElement, boolean portletActions) throws Exception {
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        List roleElements = permissionsElement.elements("role");
        for (Element roleElement : roleElements) {
            String description;
            String name = roleElement.attributeValue("name");
            int type = GetterUtil.getInteger((String)roleElement.attributeValue("type"));
            Role role = null;
            if (name.startsWith("ROLE_TEAM_,*")) {
                name = name.substring("ROLE_TEAM_,*".length());
                description = roleElement.attributeValue("description");
                Team team = null;
                try {
                    team = TeamLocalServiceUtil.getTeam((long)groupId, (String)name);
                }
                catch (NoSuchTeamException noSuchTeamException) {
                    team = TeamLocalServiceUtil.addTeam((long)userId, (long)groupId, (String)name, (String)description);
                }
                role = RoleLocalServiceUtil.getTeamRole((long)companyId, (long)team.getTeamId());
            } else {
                role = layoutCache.getRole(companyId, name);
            }
            if (role == null) {
                description = roleElement.attributeValue("description");
                Map descriptionMap = LocalizationUtil.getLocalizationMap((String)description);
                role = RoleLocalServiceUtil.addRole((long)userId, (long)companyId, (String)name, null, (Map)descriptionMap, (int)type);
            }
            List<String> actions = this.getActions(roleElement);
            roleIdsToActionIds.put(role.getRoleId(), actions.toArray(new String[actions.size()]));
        }
        if (roleIdsToActionIds.isEmpty()) {
            return;
        }
        ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey, roleIdsToActionIds);
    }

    protected void importPortletPermissions(LayoutCache layoutCache, long companyId, long groupId, long userId, Layout layout, Element portletElement, String portletId, boolean importUserPermissions) throws Exception {
        Element permissionsElement = portletElement.element("permissions");
        if (permissionsElement != null) {
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                this.importPermissions_5(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsElement, true);
            } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.importPermissions_6(layoutCache, companyId, groupId, userId, resourceName, resourcePrimKey, permissionsElement, true);
            } else {
                Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
                this.importPortletPermissions_1to4(layoutCache, companyId, groupId, guestGroup, layout, permissionsElement, importUserPermissions);
            }
        }
        Element rolesElement = portletElement.element("roles");
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5 && rolesElement != null) {
            this.importPortletRoles(layoutCache, companyId, groupId, portletElement);
            this.importPortletRoles(layoutCache, companyId, groupId, portletId, rolesElement);
        }
    }

    protected void importPortletPermissions_1to4(LayoutCache layoutCache, long companyId, long groupId, Group guestGroup, Layout layout, Element permissionsElement, boolean importUserPermissions) throws Exception {
        List portletElements = permissionsElement.elements("portlet");
        for (Element portletElement : portletElements) {
            String portletId = portletElement.attributeValue("portlet-id");
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)resourceName);
            if (portlet == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not import portlet permissions for " + portletId + " because the portlet does not exist"));
                continue;
            }
            this.importGroupPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, portletElement, "community-actions", true);
            if (groupId != guestGroup.getGroupId()) {
                this.importGroupPermissions(layoutCache, companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, portletElement, "guest-actions", true);
            }
            if (importUserPermissions) {
                this.importUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, portletElement, true);
            }
            this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, portletElement, "organization", true);
            this.importInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, portletElement, "user-group", true);
        }
    }

    protected void importPortletRoles(LayoutCache layoutCache, long companyId, long groupId, String portletId, Element rolesElement) throws Exception {
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)resourceName);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet roles for " + portletId + " because the portlet does not exist"));
            }
        } else {
            this.importGroupRoles(layoutCache, companyId, groupId, resourceName, "community", rolesElement);
            this.importUserRoles(layoutCache, companyId, groupId, resourceName, rolesElement);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", rolesElement);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", rolesElement);
        }
    }

    protected void importPortletRoles(LayoutCache layoutCache, long companyId, long groupId, Element rolesElement) throws Exception {
        List portletElements = rolesElement.elements("portlet");
        for (Element portletElement : portletElements) {
            String portletId = portletElement.attributeValue("portlet-id");
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)resourceName);
            if (portlet == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not import portlet roles for " + portletId + " because the portlet does not exist"));
                continue;
            }
            this.importGroupRoles(layoutCache, companyId, groupId, resourceName, "community", portletElement);
            this.importUserRoles(layoutCache, companyId, groupId, resourceName, portletElement);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", portletElement);
            this.importInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", portletElement);
        }
    }

    protected void importRolePermissions(LayoutCache layoutCache, long companyId, String resourceName, int scope, String resourcePrimKey, Element parentElement, boolean communityRole) throws Exception {
        List roleElements = parentElement.elements("role");
        for (Element roleElement : roleElements) {
            String roleName = roleElement.attributeValue("name");
            Role role = layoutCache.getRole(companyId, roleName);
            if (role == null) {
                _log.warn((Object)("Ignoring permissions for role with name " + roleName));
                continue;
            }
            List<String> actions = this.getActions(roleElement);
            PermissionLocalServiceUtil.setRolePermissions((long)role.getRoleId(), (long)companyId, (String)resourceName, (int)scope, (String)resourcePrimKey, (String[])actions.toArray(new String[actions.size()]));
            if (!communityRole) continue;
            long[] groupIds = new long[]{GetterUtil.getLong((String)resourcePrimKey)};
            GroupLocalServiceUtil.addRoleGroups((long)role.getRoleId(), (long[])groupIds);
        }
    }

    protected void importUserPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentElement, boolean portletActions) throws Exception {
        Element userPermissionsElement = parentElement.element("user-permissions");
        if (userPermissionsElement == null) {
            return;
        }
        List userActionsElements = userPermissionsElement.elements("user-actions");
        for (Element userActionsElement : userActionsElements) {
            String uuid = userActionsElement.attributeValue("uuid");
            User user = layoutCache.getUser(companyId, groupId, uuid);
            if (user == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Ignoring permissions for user with uuid " + uuid));
                continue;
            }
            List<String> actions = this.getActions(userActionsElement);
            Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
            PermissionLocalServiceUtil.setUserPermissions((long)user.getUserId(), (String[])actions.toArray(new String[actions.size()]), (long)resource.getResourceId());
        }
    }

    protected void importUserRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, Element parentElement) throws Exception {
        Element userRolesElement = parentElement.element("user-roles");
        if (userRolesElement == null) {
            return;
        }
        List userElements = userRolesElement.elements("user");
        for (Element userElement : userElements) {
            String uuid = userElement.attributeValue("uuid");
            User user = layoutCache.getUser(companyId, groupId, uuid);
            if (user == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Ignoring roles for user with uuid " + uuid));
                continue;
            }
            this.importRolePermissions(layoutCache, companyId, resourceName, 2, String.valueOf(groupId), userElement, false);
        }
    }

    protected void readPortletDataPermissions(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(portletDataContext.getSourceRootPath()) + "/portlet-data-permissions.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List portletDataElements = rootElement.elements("portlet-data");
        for (Element portletDataElement : portletDataElements) {
            String resourceName = portletDataElement.attributeValue("resource-name");
            long resourcePK = GetterUtil.getLong((String)portletDataElement.attributeValue("resource-pk"));
            ArrayList<KeyValuePair> permissions = new ArrayList<KeyValuePair>();
            List permissionsElements = portletDataElement.elements("permissions");
            for (Element permissionsElement : permissionsElements) {
                String roleName = permissionsElement.attributeValue("role-name");
                String actions = permissionsElement.attributeValue("actions");
                KeyValuePair permission = new KeyValuePair(roleName, actions);
                permissions.add(permission);
            }
            portletDataContext.addPermissions(resourceName, resourcePK, permissions);
        }
    }
}

