/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.CamelCaseUtil;
import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionConfig;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionImpl;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParameters;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManager;
import com.liferay.portal.kernel.util.BinarySearch;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWebServiceActionsManagerImpl
implements JSONWebServiceActionsManager {
    private SortedArrayList<JSONWebServiceActionConfig> _jsonWebServiceActionConfigs = new SortedArrayList();
    private BinarySearch<String> _pathBinarySearch = new PathBinarySearch();

    public JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest request) {
        String path = GetterUtil.getString((String)request.getPathInfo());
        String method = GetterUtil.getString((String)request.getMethod());
        String pathParameters = null;
        JSONRPCRequest jsonRpcRequest = null;
        int pathParametersIndex = this._getPathParametersIndex(path);
        if (pathParametersIndex != -1) {
            pathParameters = path.substring(pathParametersIndex);
            path = path.substring(0, pathParametersIndex);
        } else if (method.equals("POST") && !PortalUtil.isMultipartRequest((HttpServletRequest)request) && (jsonRpcRequest = JSONRPCRequest.detectJSONRPCRequest(request)) != null) {
            path = String.valueOf(path) + "/" + jsonRpcRequest.getMethod();
            method = null;
        }
        JSONWebServiceActionParameters jsonWebServiceActionParameters = new JSONWebServiceActionParameters();
        jsonWebServiceActionParameters.collectAll(request, pathParameters, jsonRpcRequest);
        String[] parameterNames = jsonWebServiceActionParameters.getParameterNames();
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        String servletContextPath = ContextPathUtil.getContextPath((ServletContext)servletContext);
        int jsonWebServiceActionConfigIndex = this._getJSONWebServiceActionConfigIndex(servletContextPath, path, method, parameterNames);
        if (jsonWebServiceActionConfigIndex == -1) {
            throw new RuntimeException("No JSON web service action associated with path " + path + " and method " + method + " for /" + servletContextPath);
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)this._jsonWebServiceActionConfigs.get(jsonWebServiceActionConfigIndex);
        return new JSONWebServiceActionImpl(jsonWebServiceActionConfig, jsonWebServiceActionParameters);
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping(String signature) {
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            if (!signature.equals(jsonWebServiceActionConfig.getSignature())) continue;
            return jsonWebServiceActionConfig;
        }
        return null;
    }

    public List<JSONWebServiceActionMapping> getJSONWebServiceActionMappings(String servletContextPath) {
        ArrayList<JSONWebServiceActionMapping> jsonWebServiceActionMappings = new ArrayList<JSONWebServiceActionMapping>(this._jsonWebServiceActionConfigs.size());
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            String jsonWebServiceServletContextPath = jsonWebServiceActionConfig.getServletContextPath();
            if (!servletContextPath.equals(jsonWebServiceServletContextPath)) continue;
            jsonWebServiceActionMappings.add(jsonWebServiceActionConfig);
        }
        return jsonWebServiceActionMappings;
    }

    public void registerJSONWebServiceAction(String servletContextPath, Class<?> actionClass, Method actionMethod, String path, String method) {
        JSONWebServiceActionConfig jsonWebServiceActionConfig = new JSONWebServiceActionConfig(servletContextPath, actionClass, actionMethod, path, method);
        this._jsonWebServiceActionConfigs.add((Object)jsonWebServiceActionConfig);
    }

    public int unregisterJSONWebServiceActions(String servletContextPath) {
        int count = 0;
        Iterator itr = this._jsonWebServiceActionConfigs.iterator();
        while (itr.hasNext()) {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)itr.next();
            if (!servletContextPath.equals(jsonWebServiceActionConfig.getServletContextPath())) continue;
            itr.remove();
            ++count;
        }
        return count;
    }

    private int _countMatchedElements(String[] parameterNames, MethodParameter[] methodParameters) {
        int matched = 0;
        MethodParameter[] methodParameterArray = methodParameters;
        int n = methodParameters.length;
        int n2 = 0;
        while (n2 < n) {
            MethodParameter methodParameter = methodParameterArray[n2];
            String methodParameterName = methodParameter.getName();
            methodParameterName = CamelCaseUtil.normalizeCamelCase(methodParameterName);
            String[] stringArray = parameterNames;
            int n3 = parameterNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String parameterName = stringArray[n4];
                if (parameterName.equals(methodParameterName)) {
                    ++matched;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return matched;
    }

    private int _getJSONWebServiceActionConfigIndex(String servletContextPath, String path, String method, String[] parameterNames) {
        int firstIndex;
        int hint = -1;
        int dotIndex = path.indexOf(46);
        if (dotIndex != -1) {
            hint = GetterUtil.getInteger((String)path.substring(dotIndex + 1));
            path = path.substring(0, dotIndex);
        }
        if ((firstIndex = this._pathBinarySearch.findFirst((Object)(path = String.valueOf(servletContextPath) + path))) < 0) {
            return -1;
        }
        int lastIndex = this._pathBinarySearch.findLast((Object)path, firstIndex);
        if (lastIndex < 0) {
            lastIndex = firstIndex;
        }
        int index = -1;
        int max = -1;
        int i = firstIndex;
        while (i <= lastIndex) {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)this._jsonWebServiceActionConfigs.get(i);
            String jsonWebServiceActionConfigMethod = jsonWebServiceActionConfig.getMethod();
            if (!PropsValues.JSONWS_WEB_SERVICE_STRICT_HTTP_METHOD || method == null || jsonWebServiceActionConfigMethod == null || jsonWebServiceActionConfigMethod.equals(method)) {
                int count;
                MethodParameter[] jsonWebServiceActionConfigMethodParameters = jsonWebServiceActionConfig.getMethodParameters();
                int methodParametersCount = jsonWebServiceActionConfigMethodParameters.length;
                if (!(hint != -1 && methodParametersCount != hint || (count = this._countMatchedElements(parameterNames, jsonWebServiceActionConfigMethodParameters)) <= max || hint == -1 && count < methodParametersCount)) {
                    max = count;
                    index = i;
                }
            }
            ++i;
        }
        return index;
    }

    private int _getPathParametersIndex(String path) {
        int index = path.indexOf(47, 1);
        if (index != -1) {
            index = path.indexOf(47, index + 1);
        }
        return index;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathBinarySearch
    extends BinarySearch<String> {
        private PathBinarySearch() {
        }

        protected int compare(int index, String element) {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)JSONWebServiceActionsManagerImpl.this._jsonWebServiceActionConfigs.get(index);
            String fullPath = jsonWebServiceActionConfig.getFullPath();
            return fullPath.compareTo(element);
        }

        protected int getLastIndex() {
            return JSONWebServiceActionsManagerImpl.this._jsonWebServiceActionConfigs.size() - 1;
        }
    }
}

