/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.CamelCaseUtil;
import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONRPCResponse;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionConfig;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParameters;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.service.ServiceContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jodd.bean.BeanUtil;
import jodd.util.KeyValue;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWebServiceActionImpl
implements JSONWebServiceAction {
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceActionImpl.class);
    private JSONWebServiceActionConfig _jsonWebServiceActionConfig;
    private JSONWebServiceActionParameters _jsonWebServiceActionParameters;

    public JSONWebServiceActionImpl(JSONWebServiceActionConfig jsonWebServiceActionConfig, JSONWebServiceActionParameters jsonWebServiceActionParameters) {
        this._jsonWebServiceActionConfig = jsonWebServiceActionConfig;
        this._jsonWebServiceActionParameters = jsonWebServiceActionParameters;
    }

    public Object invoke() throws Exception {
        JSONRPCRequest jsonRpcRequest = this._jsonWebServiceActionParameters.getJSONRPCRequest();
        if (jsonRpcRequest == null) {
            return this._invokeActionMethod();
        }
        Object result = null;
        Exception exception = null;
        try {
            result = this._invokeActionMethod();
        }
        catch (Exception e) {
            exception = e;
            _log.error((Object)e, (Throwable)e);
        }
        return new JSONRPCResponse(jsonRpcRequest, result, exception);
    }

    private Object _createDefaultParameterValue(String parameterName, Class<?> parameterType) throws Exception {
        if (parameterName.equals("serviceContext") && parameterType.equals(ServiceContext.class)) {
            return new ServiceContext();
        }
        return parameterType.newInstance();
    }

    private List<?> _generifyList(List<?> list, Class<?>[] types) {
        if (types == null) {
            return list;
        }
        if (types.length != 1) {
            return list;
        }
        ArrayList newList = new ArrayList(list.size());
        for (Object entry : list) {
            if (entry != null) {
                entry = ReflectUtil.castType(entry, types[0]);
            }
            newList.add(entry);
        }
        return newList;
    }

    private Map<?, ?> _generifyMap(Map<?, ?> map, Class<?>[] types) {
        if (types == null) {
            return map;
        }
        if (types.length != 2) {
            return map;
        }
        HashMap newMap = new HashMap(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = ReflectUtil.castType(entry.getKey(), types[0]);
            Object value = entry.getValue();
            if (value != null) {
                value = ReflectUtil.castType(value, types[1]);
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    private Object _invokeActionMethod() throws Exception {
        Method actionMethod = this._jsonWebServiceActionConfig.getActionMethod();
        Class<?> actionClass = this._jsonWebServiceActionConfig.getActionClass();
        Object[] parameters = this._prepareParameters(actionClass);
        return actionMethod.invoke(actionClass, parameters);
    }

    private Object[] _prepareParameters(Class<?> actionClass) throws Exception {
        MethodParameter[] methodParameters = this._jsonWebServiceActionConfig.getMethodParameters();
        Object[] parameters = new Object[methodParameters.length];
        int i = 0;
        while (i < methodParameters.length) {
            List<KeyValue<String, Object>> innerParameters;
            String parameterName = methodParameters[i].getName();
            parameterName = CamelCaseUtil.normalizeCamelCase(parameterName);
            Object value = this._jsonWebServiceActionParameters.getParameter(parameterName);
            Object parameterValue = null;
            if (value != null) {
                Class<?> parameterType = methodParameters[i].getType();
                if (value.equals(Void.TYPE)) {
                    String parameterTypeName = this._jsonWebServiceActionParameters.getParameterTypeName(parameterName);
                    if (parameterTypeName != null) {
                        ClassLoader classLoader = actionClass.getClassLoader();
                        parameterType = classLoader.loadClass(parameterTypeName);
                    }
                    parameterValue = this._createDefaultParameterValue(parameterName, parameterType);
                } else if (parameterType.equals(Calendar.class)) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setLenient(false);
                    calendar.setTimeInMillis(Long.parseLong(value.toString()));
                    parameterValue = calendar;
                } else if (parameterType.equals(List.class)) {
                    List<?> list = (List<?>)JSONFactoryUtil.looseDeserialize((String)value.toString(), ArrayList.class);
                    list = this._generifyList(list, methodParameters[i].getGenericTypes());
                    parameterValue = list;
                } else if (parameterType.equals(Locale.class)) {
                    parameterValue = LocaleUtil.fromLanguageId((String)value.toString());
                } else if (parameterType.equals(Map.class)) {
                    Map<?, ?> map = (Map<?, ?>)JSONFactoryUtil.looseDeserialize((String)value.toString(), HashMap.class);
                    map = this._generifyMap(map, methodParameters[i].getGenericTypes());
                    parameterValue = map;
                } else {
                    parameterValue = ReflectUtil.castType((Object)value, parameterType);
                }
            }
            if (parameterValue != null && (innerParameters = this._jsonWebServiceActionParameters.getInnerParameters(parameterName)) != null) {
                for (KeyValue<String, Object> innerParameter : innerParameters) {
                    BeanUtil.setPropertySilent((Object)parameterValue, (String)((String)innerParameter.getKey()), (Object)innerParameter.getValue());
                }
            }
            parameters[i] = parameterValue;
            ++i;
        }
        return parameters;
    }
}

