/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jcr.jackrabbit;

import com.liferay.portal.jcr.JCRFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.TransientRepository;

public class JCRFactoryImpl
implements JCRFactory {
    public static final String REPOSITORY_ROOT = PropsUtil.get("jcr.jackrabbit.repository.root");
    public static final String CONFIG_FILE_PATH = PropsUtil.get("jcr.jackrabbit.config.file.path");
    public static final String REPOSITORY_HOME = PropsUtil.get("jcr.jackrabbit.repository.home");
    public static final String CREDENTIALS_USERNAME = PropsUtil.get("jcr.jackrabbit.credentials.username");
    public static final char[] CREDENTIALS_PASSWORD = GetterUtil.getString((String)PropsUtil.get("jcr.jackrabbit.credentials.password")).toCharArray();
    private static Log _log = LogFactoryUtil.getLog(JCRFactoryImpl.class);
    private boolean _initialized;
    private TransientRepository _transientRepository;

    public Session createSession(String workspaceName) throws RepositoryException {
        SimpleCredentials credentials = new SimpleCredentials(CREDENTIALS_USERNAME, CREDENTIALS_PASSWORD);
        Session session = null;
        try {
            session = this._transientRepository.login((Credentials)credentials, workspaceName);
        }
        catch (RepositoryException re) {
            _log.error((Object)("Could not login to the workspace " + workspaceName));
            throw re;
        }
        return session;
    }

    public void initialize() throws RepositoryException {
        Session session = null;
        try {
            try {
                session = this.createSession(null);
            }
            catch (RepositoryException re) {
                _log.error((Object)"Could not initialize Jackrabbit");
                throw re;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        this._initialized = true;
    }

    public void prepare() throws RepositoryException {
        try {
            File repositoryRoot = new File(REPOSITORY_ROOT);
            if (repositoryRoot.exists()) {
                return;
            }
            repositoryRoot.mkdirs();
            File tempFile = new File(String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + File.separator + Time.getTimestamp());
            String repositoryXmlPath = "com/liferay/portal/jcr/jackrabbit/dependencies/repository-ext.xml";
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader.getResource(repositoryXmlPath) == null) {
                repositoryXmlPath = "com/liferay/portal/jcr/jackrabbit/dependencies/repository.xml";
            }
            FileUtil.write((File)tempFile, (InputStream)classLoader.getResourceAsStream(repositoryXmlPath));
            FileUtil.copyFile((File)tempFile, (File)new File(CONFIG_FILE_PATH));
            tempFile.delete();
        }
        catch (IOException ioe) {
            _log.error((Object)"Could not prepare Jackrabbit directory");
            throw new RepositoryException((Throwable)ioe);
        }
    }

    public void shutdown() {
        if (this._initialized) {
            this._transientRepository.shutdown();
        }
        this._initialized = false;
    }

    protected JCRFactoryImpl() throws Exception {
        try {
            this._transientRepository = new TransientRepository(CONFIG_FILE_PATH, REPOSITORY_HOME);
        }
        catch (Exception e) {
            _log.error((Object)"Problem initializing Jackrabbit JCR.", (Throwable)e);
            throw e;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Jackrabbit JCR intialized with config file path " + CONFIG_FILE_PATH + " and repository home " + REPOSITORY_HOME));
        }
    }
}

