/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jcr;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Session;

public class JCRSessionInvocationHandler
implements InvocationHandler {
    private static Log _log = LogFactoryUtil.getLog(JCRSessionInvocationHandler.class);
    private Map<String, Binary> _binaries = new HashMap<String, Binary>();
    private Session _session;

    public JCRSessionInvocationHandler(Session session) {
        this._session = session;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Starting session " + this._session));
        }
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("close")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Closing session " + this._session));
            }
            for (Map.Entry<String, Binary> entry : this._binaries.entrySet()) {
                Binary binary = entry.getValue();
                binary.dispose();
            }
            this._session.logout();
            return null;
        }
        if (methodName.equals("logout")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping logout for session " + this._session));
            }
            return null;
        }
        if (methodName.equals("put")) {
            String key = (String)arguments[0];
            Binary binary = (Binary)arguments[1];
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Tracking binary " + key + " for session " + this._session));
            }
            this._binaries.put(key, binary);
            return null;
        }
        try {
            return method.invoke((Object)this._session, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        catch (Exception e) {
            throw e;
        }
    }
}

