/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jcr;

import com.liferay.portal.jcr.JCRFactory;
import com.liferay.portal.jcr.JCRSessionInvocationHandler;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class JCRFactoryUtil {
    private static ThreadLocal<CloseableSessionMap> _closeableSessionMaps = new AutoResetThreadLocal(JCRFactoryUtil.class + "._session", (Object)new CloseableSessionMap());
    private static JCRFactory _jcrFactory;

    public static void closeSession(Session session) {
        if (session != null) {
            session.logout();
        }
    }

    public static Session createSession() throws RepositoryException {
        return JCRFactoryUtil.createSession(null);
    }

    public static Session createSession(String workspaceName) throws RepositoryException {
        if (workspaceName == null) {
            workspaceName = JCRFactory.WORKSPACE_NAME;
        }
        if (!PropsValues.JCR_WRAP_SESSION) {
            return JCRFactoryUtil.getJCRFactory().createSession(workspaceName);
        }
        CloseableSessionMap closableSessionMap = _closeableSessionMaps.get();
        if (!closableSessionMap.containsKey(workspaceName)) {
            Session session = JCRFactoryUtil.getJCRFactory().createSession(workspaceName);
            Object sessionProxy = ProxyUtil.newProxyInstance((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (Class[])new Class[]{Closeable.class, Map.class, Session.class}, (InvocationHandler)new JCRSessionInvocationHandler(session));
            closableSessionMap.put(workspaceName, (Closeable)sessionProxy);
        }
        return (Session)closableSessionMap.get(workspaceName);
    }

    public static JCRFactory getJCRFactory() {
        if (_jcrFactory == null) {
            _jcrFactory = (JCRFactory)PortalBeanLocatorUtil.locate((String)JCRFactory.class.getName());
        }
        return _jcrFactory;
    }

    public static void initialize() throws RepositoryException {
        JCRFactoryUtil.getJCRFactory().initialize();
    }

    public static void prepare() throws RepositoryException {
        JCRFactoryUtil.getJCRFactory().prepare();
    }

    public static void shutdown() {
        JCRFactoryUtil.getJCRFactory().shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloseableSessionMap
    extends HashMap<String, Closeable>
    implements Closeable {
        private CloseableSessionMap() {
        }

        @Override
        public void close() throws IOException {
            for (Closeable closeableSession : this.values()) {
                closeableSession.close();
            }
        }
    }
}

