/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.increment;

import com.liferay.portal.increment.BufferedIncreasableEntry;
import com.liferay.portal.kernel.concurrent.BatchablePipe;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.security.auth.CompanyThreadLocal;

public class BufferedIncrementMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(BufferedIncrementMessageListener.class);

    protected void doReceive(Message message) throws Exception {
        BufferedIncreasableEntry bufferedIncreasableEntry;
        long companyId = message.getLong("companyId");
        CompanyThreadLocal.setCompanyId((Long)companyId);
        BatchablePipe batchablePipe = (BatchablePipe)message.getPayload();
        while ((bufferedIncreasableEntry = (BufferedIncreasableEntry)batchablePipe.take()) != null) {
            try {
                bufferedIncreasableEntry.proceed();
            }
            catch (Throwable t) {
                _log.error((Object)"Cannot write buffered increment value to the database", t);
            }
        }
    }
}

